/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentInstaller;
import org.graalvm.component.installer.ComponentParam;
import org.graalvm.component.installer.DependencyException;
import org.graalvm.component.installer.FailedOperationException;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.InstallerStopException;
import org.graalvm.component.installer.MetadataException;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.commands.QueryCommandBase;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.Verifier;
import org.graalvm.component.installer.persist.MetadataLoader;

public class InfoCommand
extends QueryCommandBase {
    private static final Map<String, String> OPTIONS = new HashMap<String, String>();
    private boolean ignoreOpenErrors;
    private boolean verifyJar;
    private boolean fullPath;
    private boolean suppressTable;
    private Version.Match versionFilter;
    private final List<ComponentParam> components = new ArrayList<ComponentParam>();
    private final Map<ComponentInfo, MetadataLoader> map = new HashMap<ComponentInfo, MetadataLoader>();
    private final Map<ComponentInfo, ComponentParam> files = new HashMap<ComponentInfo, ComponentParam>();

    @Override
    public Map<String, String> supportedOptions() {
        return OPTIONS;
    }

    public boolean isSuppressTable() {
        return this.suppressTable;
    }

    public void setSuppressTable(boolean suppressTable) {
        this.suppressTable = suppressTable;
    }

    public boolean isIgnoreOpenErrors() {
        return this.ignoreOpenErrors;
    }

    public void setIgnoreOpenErrors(boolean ignoreOpenErrors) {
        this.ignoreOpenErrors = ignoreOpenErrors;
    }

    public boolean isVerifyJar() {
        return this.verifyJar;
    }

    public void setVerifyJar(boolean verifyJar) {
        this.verifyJar = verifyJar;
    }

    public boolean isFullPath() {
        return this.fullPath;
    }

    public void setFullPath(boolean fullPath) {
        this.fullPath = fullPath;
    }

    @Override
    public void init(CommandInput commandInput, Feedback feedBack) {
        super.init(commandInput, feedBack);
        this.ignoreOpenErrors = this.input.optValue("r") != null;
        this.verifyJar = this.input.optValue("s") == null;
        this.suppressTable = this.input.optValue("t") != null;
        this.fullPath = this.input.optValue("p") != null;
        String vf = this.input.optValue("V");
        if (vf != null) {
            this.versionFilter = Version.versionFilter(vf);
        }
    }

    void collectComponents() throws IOException {
        Iterator it = this.input.existingFiles().matchVersion(this.versionFilter).allowIncompatible().iterator();
        while (it.hasNext()) {
            ComponentParam cp;
            try {
                cp = (ComponentParam)it.next();
            }
            catch (FailedOperationException ex) {
                this.feedback.error("INFO_InvalidComponent", ex, ex.getLocalizedMessage());
                continue;
            }
            try {
                this.processComponentParam(cp);
            }
            catch (ZipException ex) {
                if (this.ignoreOpenErrors) {
                    this.feedback.error("INFO_ErrorOpeningBundle", ex, cp.getDisplayName(), ex.getLocalizedMessage());
                    continue;
                }
                throw ex;
            }
            catch (MetadataException ex) {
                if (this.ignoreOpenErrors) {
                    this.feedback.error("INFO_CorruptedBundleMetadata", ex, cp.getDisplayName(), ex.getOffendingHeader(), ex.getLocalizedMessage());
                    continue;
                }
                throw ex;
            }
            catch (IOException ex) {
                if (this.ignoreOpenErrors) {
                    this.feedback.error("INFO_ErrorReadingBundle", ex, cp.getDisplayName(), ex.getLocalizedMessage());
                    continue;
                }
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute() throws IOException {
        if (this.input.optValue("h") != null) {
            this.feedback.output("INFO_Help", new Object[0]);
            return 0;
        }
        if (!this.input.hasParameter()) {
            this.feedback.error("INFO_MissingFilename", null, new Object[0]);
            return 1;
        }
        try {
            this.collectComponents();
            this.printTable = this.getComponents().size() > 1 && !this.isVerbose() && !this.suppressTable;
            super.printComponents();
        }
        catch (Throwable throwable) {
            for (ComponentParam c : this.components) {
                try {
                    c.close();
                }
                catch (IOException ex) {
                    ComponentInfo ci = c.createMetaLoader().getComponentInfo();
                    this.feedback.error("INFO_ClosingComponent", ex, ci == null ? c.getSpecification() : this.shortenComponentId(ci), ex.getLocalizedMessage());
                }
            }
            throw throwable;
        }
        for (ComponentParam c : this.components) {
            try {
                c.close();
            }
            catch (IOException ex) {
                ComponentInfo ci = c.createMetaLoader().getComponentInfo();
                this.feedback.error("INFO_ClosingComponent", ex, ci == null ? c.getSpecification() : this.shortenComponentId(ci), ex.getLocalizedMessage());
            }
        }
        return 0;
    }

    void processComponentParam(ComponentParam cp) throws IOException {
        MetadataLoader ldr = cp.createMetaLoader();
        this.components.add(cp);
        this.loadComponentDetails(cp, ldr);
        this.addComponent(cp, ldr.getComponentInfo());
    }

    void registerFile(ComponentParam param, ComponentInfo info, MetadataLoader ldr) {
        this.files.put(info, param);
        this.map.put(info, ldr);
    }

    void loadComponentDetails(ComponentParam param, MetadataLoader ldr) throws IOException {
        ldr.infoOnly(true);
        ComponentInfo info = ldr.getComponentInfo();
        this.registerFile(param, info, ldr);
        if (this.isListFiles()) {
            ldr.loadPaths();
        }
    }

    @Override
    void printHeader() {
        if (this.printTable) {
            if (this.fullPath) {
                this.feedback.output("INFO_ComponentLongListHeader", new Object[0]);
            } else {
                this.feedback.output("INFO_ComponentShortListHeader", new Object[0]);
            }
        }
    }

    protected String filePath(ComponentInfo info) {
        ComponentParam p = this.files.get(info);
        if (this.fullPath) {
            return p.getFullPath();
        }
        String s = p.getShortName();
        int idx = s.lastIndexOf(46);
        return idx == -1 ? s : s.substring(0, idx);
    }

    @Override
    void printDetails(ComponentParam param, ComponentInfo info) {
        Verifier vfy;
        MetadataLoader ldr;
        List<InstallerStopException> errs;
        if (this.printTable) {
            String line = String.format(this.feedback.l10n("INFO_ComponentShortList", new Object[0]), this.shortenComponentId(info), this.val(info.getVersion().displayString()), this.val(info.getName()), this.filePath(info));
            this.feedback.verbatimOut(line, false);
            return;
        }
        this.feedback.output("INFO_ComponentBasicInfo", this.shortenComponentId(info), this.val(info.getVersion().displayString()), this.val(info.getName()), param.getFullPath(), this.findRequiredGraalVMVersion(info));
        ArrayList<String> keys = new ArrayList<String>(info.getRequiredGraalValues().keySet());
        keys.remove("graalvm_version");
        if (!keys.isEmpty() && this.feedback.verboseOutput("INFO_ComponentRequirementsHeader", new Object[0])) {
            Collections.sort(keys);
            for (String cap : keys) {
                this.feedback.verboseOutput("INFO_ComponentRequirement", this.getRegistry().localizeCapabilityName(cap), info.getRequiredGraalValues().get(cap));
            }
        }
        if (!(errs = (ldr = this.map.get(info)).getErrors()).isEmpty()) {
            this.feedback.message("INFO_ComponentBroken", this.files.get(info));
            for (InstallerStopException ex : errs) {
                this.feedback.message("INFO_ComponentErrorIndent", ex.getLocalizedMessage());
            }
        }
        if ((vfy = new Verifier(this.feedback, this.input.getLocalRegistry(), this.catalog).collect(true).validateRequirements(info)).hasErrors()) {
            this.feedback.message("INFO_ComponentWillNotInstall", this.shortenComponentId(info));
            for (DependencyException ex : vfy.getErrors()) {
                this.feedback.message("INFO_ComponentDependencyIndent", ex.getLocalizedMessage());
            }
        }
    }

    static {
        OPTIONS.putAll(BASE_OPTIONS);
        OPTIONS.putAll(ComponentInstaller.componentOptions);
        OPTIONS.put("s", "");
        OPTIONS.put("p", "");
        OPTIONS.put("r", "");
        OPTIONS.put("t", "");
        OPTIONS.put("n", "");
        OPTIONS.put("no-verify-jars", "s");
        OPTIONS.put("paths", "p");
        OPTIONS.put("ignore-open", "r");
        OPTIONS.put("no-tables", "t");
        OPTIONS.put("no-progress", "n");
        OPTIONS.put("V", "s");
        OPTIONS.put("use-version", "V");
    }
}

