/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.graalvm.component.installer.Archive;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentInstaller;
import org.graalvm.component.installer.ComponentParam;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.InstallerCommand;
import org.graalvm.component.installer.InstallerStopException;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.UserAbortException;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.commands.Installer;
import org.graalvm.component.installer.commands.LicensePresenter;
import org.graalvm.component.installer.commands.PostInstProcess;
import org.graalvm.component.installer.commands.Uninstaller;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.Verifier;
import org.graalvm.component.installer.persist.MetadataLoader;

public class InstallCommand
implements InstallerCommand {
    private static final Logger LOG = Logger.getLogger(InstallCommand.class.getName());
    private static final Map<String, String> OPTIONS = new HashMap<String, String>();
    private CommandInput input;
    private Feedback feedback;
    private boolean ignoreFailures;
    private boolean force;
    private boolean validateBeforeInstall;
    private boolean validateDownload;
    private boolean allowUpgrades;
    private boolean verifyJar = true;
    private boolean wasFile;
    private PostInstProcess postinstHelper;
    List<ComponentParam> components = new ArrayList<ComponentParam>();
    Map<ComponentParam, Installer> realInstallers = new LinkedHashMap<ComponentParam, Installer>();
    private String current;
    private Version minRequiredGraalVersion;
    private Map<String, List<MetadataLoader>> licensesToAccept = new LinkedHashMap<String, List<MetadataLoader>>();
    private List<ComponentParam> dependencies = new ArrayList<ComponentParam>();
    private Map<String, Collection<ComponentInfo>> dependencyMap = new HashMap<String, Collection<ComponentInfo>>();
    private Set<String> unresolvedDependencies = new HashSet<String>();
    private Set<ComponentInfo> knownDeps = new HashSet<ComponentInfo>();
    private final List<Installer> installers = new ArrayList<Installer>();
    private final List<Installer> executedInstallers = new ArrayList<Installer>();
    Map<String, String> permissions;
    Map<String, String> symlinks;
    ComponentInfo fullInfo;

    @Override
    public void init(CommandInput commandInput, Feedback feedBack) {
        this.input = commandInput;
        this.feedback = feedBack;
        this.ignoreFailures = this.input.optValue("x") != null;
        this.validateBeforeInstall = this.input.optValue("y") != null;
        this.validateDownload = this.input.optValue("Y") != null;
        this.verifyJar = this.input.optValue("s") == null;
        this.postinstHelper = new PostInstProcess(this.input, feedBack);
    }

    public boolean isVerifyJar() {
        return this.verifyJar;
    }

    public void setVerifyJar(boolean verifyJar) {
        this.verifyJar = verifyJar;
    }

    public boolean isAllowUpgrades() {
        return this.allowUpgrades;
    }

    public void setAllowUpgrades(boolean allowUpgrades) {
        this.allowUpgrades = allowUpgrades;
    }

    @Override
    public Map<String, String> supportedOptions() {
        return OPTIONS;
    }

    protected void executionInit() throws IOException {
        this.input.getLocalRegistry().verifyAdministratorAccess();
        this.input.existingFiles().setVerifyJars(this.verifyJar);
        this.minRequiredGraalVersion = this.input.getLocalRegistry().getGraalVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute() throws IOException {
        this.executionInit();
        if (this.input.optValue("h") != null) {
            this.feedback.output("INSTALL_Help", new Object[0]);
            return 0;
        }
        if (!this.input.hasParameter()) {
            this.feedback.output("INSTALL_ParametersMissing", new Object[0]);
            return 1;
        }
        if (this.input.optValue("D") != null && this.input.optValue("L") == null) {
            this.feedback.error("INSTALL_WarnLocalDependencies", null, new Object[0]);
        }
        try {
            this.executeStep(this::prepareInstallation, false);
            if (this.validateBeforeInstall) {
                int n = 0;
                return n;
            }
            this.executeStep(this::completeInstallers, false);
            this.executeStep(this::acceptLicenses, false);
            this.executeStep(this::doInstallation, false);
            this.executeStep(this::printMessages, true);
        }
        finally {
            for (Map.Entry<ComponentParam, Installer> e : this.realInstallers.entrySet()) {
                ComponentParam p = e.getKey();
                Installer i = e.getValue();
                p.close();
                if (i == null) continue;
                i.close();
            }
        }
        return 0;
    }

    void addLicenseToAccept(String id, MetadataLoader ldr) {
        this.licensesToAccept.computeIfAbsent(id, x -> new ArrayList()).add(ldr);
    }

    protected Version.Match matchInstallVesion() {
        return this.input.getLocalRegistry().getGraalVersion().match(this.allowUpgrades ? Version.Match.Type.INSTALLABLE : Version.Match.Type.COMPATIBLE);
    }

    private void addLicenseToAccept(Installer inst, MetadataLoader ldr) {
        if (ldr.getLicenseType() != null) {
            String path = ldr.getLicensePath();
            if (path != null) {
                inst.setLicenseRelativePath(SystemUtils.fromCommonRelative(ldr.getLicensePath()));
            }
            String licId = ldr.getLicenseID();
            this.addLicenseToAccept(licId, ldr);
        }
    }

    void cleanDependencies() {
        this.dependencies = new ArrayList<ComponentParam>();
    }

    public List<ComponentParam> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    void addDependencies(ComponentInfo ci) {
        HashSet<ComponentInfo> deps = new HashSet<ComponentInfo>();
        LOG.log(Level.FINE, "Inspecting dependencies of {0}", ci);
        Set<String> errors = this.input.getRegistry().findDependencies(ci, true, Boolean.FALSE, deps);
        LOG.log(Level.FINE, "Direct dependencies: {0}, errors: {1}", new Object[]{deps, errors});
        if (errors != null) {
            this.unresolvedDependencies.addAll(errors);
            for (String s : errors) {
                this.dependencyMap.computeIfAbsent(s, id -> new HashSet()).add(ci);
            }
        }
        for (ComponentInfo i : deps) {
            if (!this.knownDeps.add(i)) continue;
            ComponentParam p = this.input.existingFiles().createParam(i.getId(), i);
            this.dependencies.add(p);
            this.dependencyMap.computeIfAbsent(i.getId(), id -> new HashSet()).add(ci);
        }
    }

    void printRequiredComponents() throws IOException {
        if (this.dependencies.isEmpty()) {
            return;
        }
        this.feedback.output("INSTALL_RequiredDependencies", new Object[0]);
        for (ComponentParam p : this.dependencies) {
            ComponentInfo ci = p.createMetaLoader().getComponentInfo();
            this.feedback.output("INSTALL_RequiredDependencyLine", p.getDisplayName(), ci.getId(), ci.getVersion().displayString(), this.printComponentList(this.dependencyMap.get(ci.getId())));
        }
    }

    Iterable<ComponentParam> componentsWithDependencies() {
        return () -> new Params(this.input.existingFiles().iterator(), this.dependencies);
    }

    boolean verifyInstaller(Installer inst) {
        boolean keep;
        ComponentInfo info = inst.getComponentInfo();
        Verifier vrf = inst.createVerifier();
        vrf.setVersionMatch(this.matchInstallVesion());
        vrf.validateRequirements(info);
        boolean bl = keep = this.force || vrf.shouldInstall(info);
        if (!keep) {
            this.feedback.output("INSTALL_ComponentAlreadyInstalled", inst.getComponentInfo().getName(), inst.getComponentInfo().getId());
            return false;
        }
        Version minV = vrf.getMinVersion();
        if (minV != null && minV.compareTo(this.minRequiredGraalVersion) > 0) {
            this.minRequiredGraalVersion = minV;
        }
        this.addDependencies(info);
        return true;
    }

    String printComponentList(Collection<ComponentInfo> requestors) {
        if (requestors == null || requestors.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<ComponentInfo> infos = new ArrayList<ComponentInfo>(requestors);
        Collections.sort(infos, (c1, c2) -> c1.getId().compareTo(c2.getId()));
        for (ComponentInfo i : infos) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.feedback.l10n("INSTALL_RequiredDependencyItem", i.getName(), i.getId()));
        }
        return this.feedback.l10n("INSTALL_RequiredDependencySuffix", sb.toString());
    }

    void checkDependencyErrors() {
        if (this.unresolvedDependencies.isEmpty()) {
            return;
        }
        this.feedback.error("INSTALL_UnknownComponents", null, new Object[0]);
        ArrayList<String> ordered = new ArrayList<String>(this.unresolvedDependencies);
        Collections.sort(ordered);
        for (String s : ordered) {
            this.feedback.error("INSTALL_UnknownComponentLine", null, s, this.printComponentList(this.dependencyMap.get(s)));
        }
        if (!this.input.getRegistry().isRemoteEnabled()) {
            this.feedback.error("INSTALL_UnknownComponentsNote1", null, new Object[0]);
        }
        if (this.wasFile && !this.input.hasOption("D")) {
            this.feedback.error("INSTALL_UnknownComponentsNote2", null, new Object[0]);
        }
        throw this.feedback.failure("INSTALL_UnresolvedDependencies", null, new Object[0]);
    }

    protected void processComponents(Iterable<ComponentParam> toProcess) throws IOException {
        for (ComponentParam p : toProcess) {
            this.feedback.output(p.isComplete() ? "INSTALL_VerboseProcessingArchive" : "INSTALL_VerboseProcessingComponent", p.getDisplayName());
            this.current = p.getSpecification();
            MetadataLoader ldr = this.validateDownload ? p.createFileLoader() : p.createMetaLoader();
            Installer inst = this.createInstaller(p, ldr);
            if (!this.verifyInstaller(inst)) continue;
            this.installers.add(inst);
            if (p.isComplete()) {
                this.addLicenseToAccept(inst, ldr);
                this.realInstallers.put(p, inst);
            } else {
                this.realInstallers.put(p, null);
            }
            this.current = null;
            URL remote = ldr.getComponentInfo().getRemoteURL();
            if (remote != null && !remote.getProtocol().equalsIgnoreCase("file")) continue;
            this.wasFile = true;
        }
        for (Installer i : new ArrayList<Installer>(this.installers)) {
            if (!this.validateBeforeInstall) continue;
            this.current = i.getComponentInfo().getName();
            i.validateAll();
        }
    }

    protected void prepareInstallation() throws IOException {
        this.processComponents(this.input.existingFiles());
        this.checkDependencyErrors();
        this.printRequiredComponents();
        if (this.dependencies.isEmpty()) {
            return;
        }
        this.processComponents(new ArrayList<ComponentParam>(this.dependencies));
        this.checkDependencyErrors();
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setValidateBeforeInstall(boolean validateBeforeInstall) {
        this.validateBeforeInstall = validateBeforeInstall;
    }

    public void setValidateDownload(boolean validateDownload) {
        this.validateDownload = validateDownload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeStep(Step s, boolean close) throws IOException {
        block19: {
            boolean ok = false;
            try {
                s.execute();
                ok = true;
            }
            catch (ZipException ex) {
                this.feedback.error("INSTALL_InvalidComponentArchive", ex, this.current);
                throw ex;
            }
            catch (UserAbortException ex) {
                throw ex;
            }
            catch (IOException | InstallerStopException ex) {
                if (this.ignoreFailures) {
                    if (this.current == null) {
                        this.feedback.error("INSTALL_IgnoreFailedInstallation", ex, ex.getLocalizedMessage());
                    }
                    this.feedback.error("INSTALL_IgnoreFailedInstallation2", ex, this.current, ex.getLocalizedMessage());
                }
                if (this.current != null) {
                    this.feedback.error("INSTALL_ErrorDuringProcessing", ex, this.current, ex.getLocalizedMessage());
                }
                throw ex;
            }
            finally {
                if (!ok) {
                    for (Installer inst : this.executedInstallers) {
                        inst.revertInstall();
                    }
                }
                if (!close && ok) break block19;
                for (Installer inst : this.installers) {
                    try {
                        inst.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    void printMessages() {
        this.postinstHelper.run();
    }

    void completeInstallers() throws IOException {
        ArrayList<ComponentParam> allDependencies = new ArrayList<ComponentParam>();
        List<ComponentParam> in = new ArrayList<ComponentParam>(this.realInstallers.keySet());
        do {
            this.cleanDependencies();
            this.completeInstallers0(in);
            allDependencies.addAll(this.dependencies);
            in = this.dependencies;
            this.printRequiredComponents();
        } while (!in.isEmpty());
        this.dependencies = allDependencies;
        this.checkDependencyErrors();
    }

    void completeInstallers0(List<ComponentParam> in) throws IOException {
        for (ComponentParam p : in) {
            MetadataLoader floader;
            Installer i = this.realInstallers.get(p);
            if (i != null || !this.verifyInstaller(i = this.createInstaller(p, floader = p.createFileLoader()))) continue;
            this.addLicenseToAccept(i, floader);
            this.installers.add(i);
            if (this.validateBeforeInstall) {
                this.current = i.getComponentInfo().getName();
                i.validateAll();
            } else if (!this.force) {
                i.validateRequirements();
            }
            this.realInstallers.put(p, i);
        }
    }

    void doInstallation() throws IOException {
        for (Installer i : this.realInstallers.values()) {
            this.current = i.getComponentInfo().getName();
            this.ensureExistingComponentRemoved(i.getComponentInfo());
            this.executedInstallers.add(i);
            i.setComponentDirectories(this.input.getLocalRegistry().getComponentDirectories());
            i.install();
            this.postinstHelper.addComponentInfo(i.getComponentInfo());
        }
    }

    void ensureExistingComponentRemoved(ComponentInfo info) throws IOException {
        String componentId = info.getId();
        ComponentInfo oldInfo = this.input.getLocalRegistry().loadSingleComponent(componentId, true);
        if (oldInfo == null) {
            this.feedback.output("INSTALL_InstallNewComponent", info.getId(), info.getName(), info.getVersionString());
        } else {
            Uninstaller uninstaller = new Uninstaller(this.feedback, this.input.getFileOperations(), oldInfo, this.input.getLocalRegistry());
            uninstaller.setInstallPath(this.input.getGraalHomePath());
            uninstaller.setDryRun(this.input.optValue("0") != null);
            uninstaller.setPreservePaths(new HashSet<String>(this.input.getLocalRegistry().getPreservedFiles(oldInfo)));
            this.feedback.output("INSTALL_RemoveExistingComponent", oldInfo.getId(), oldInfo.getName(), oldInfo.getVersionString(), info.getId(), info.getName(), info.getVersionString());
            uninstaller.uninstall();
        }
    }

    List<Installer> getInstallers() {
        return this.installers;
    }

    protected void configureInstaller(Installer inst) {
        inst.setInstallPath(this.input.getGraalHomePath());
        inst.setDryRun(this.input.optValue("0") != null);
        this.force = this.input.optValue("f") != null;
        inst.setFailOnExisting(this.input.optValue("i") != null);
        inst.setReplaceComponents(this.force || this.input.optValue("r") != null);
        inst.setIgnoreRequirements(this.force);
        inst.setReplaceDiferentFiles(this.force || this.input.optValue("o") != null);
        if (this.validateBeforeInstall) {
            inst.setDryRun(true);
        }
    }

    Installer createInstaller(ComponentParam p, MetadataLoader ldr) throws IOException {
        ComponentInfo partialInfo = ldr.getComponentInfo();
        this.feedback.verboseOutput("INSTALL_PrepareToInstall", p.getDisplayName(), partialInfo.getId(), partialInfo.getVersionString(), partialInfo.getName());
        ldr.loadPaths();
        Archive a = null;
        if (p.isComplete()) {
            a = ldr.getArchive();
            a.verifyIntegrity(this.input);
        }
        Installer inst = new Installer(this.feedback, this.input.getFileOperations(), partialInfo, this.input.getLocalRegistry(), this.input.getRegistry(), a);
        inst.setPermissions(ldr.loadPermissions());
        inst.setSymlinks(ldr.loadSymlinks());
        this.configureInstaller(inst);
        return inst;
    }

    void acceptLicenses() throws IOException {
        new LicensePresenter(this.feedback, this.input.getLocalRegistry(), this.licensesToAccept).run();
    }

    public Set<String> getUnresolvedDependencies() {
        return Collections.unmodifiableSet(this.unresolvedDependencies);
    }

    static {
        OPTIONS.put("0", "");
        OPTIONS.put("f", "");
        OPTIONS.put("r", "");
        OPTIONS.put("o", "");
        OPTIONS.put("y", "");
        OPTIONS.put("Y", "");
        OPTIONS.put("x", "");
        OPTIONS.put("i", "");
        OPTIONS.put("n", "");
        OPTIONS.put("s", "");
        OPTIONS.put("D", "");
        OPTIONS.put("dry-run", "0");
        OPTIONS.put("force", "f");
        OPTIONS.put("replace", "r");
        OPTIONS.put("overwrite", "o");
        OPTIONS.put("only-validate", "y");
        OPTIONS.put("validate-before", "Y");
        OPTIONS.put("ignore", "x");
        OPTIONS.put("fail-existing", "i");
        OPTIONS.put("no-progress", "n");
        OPTIONS.put("no-verify-jars", "s");
        OPTIONS.put("local-deps", "D");
        OPTIONS.putAll(ComponentInstaller.componentOptions);
    }

    static interface Step {
        public void execute() throws IOException;
    }

    private static final class Params
    implements Iterator<ComponentParam> {
        private final Iterator<ComponentParam> first;
        private final List<ComponentParam> second;
        private int index = 0;

        Params(Iterator<ComponentParam> first, List<ComponentParam> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean hasNext() {
            return this.first.hasNext() || this.index < this.second.size();
        }

        @Override
        public ComponentParam next() {
            if (this.first.hasNext()) {
                return this.first.next();
            }
            if (this.index < this.second.size()) {
                return this.second.get(this.index++);
            }
            throw new NoSuchElementException();
        }
    }
}

