/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.graalvm.component.installer.MetadataException;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.commands.QueryCommandBase;
import org.graalvm.component.installer.model.ComponentInfo;

public class ListInstalledCommand
extends QueryCommandBase {
    private List<String> expressions = Collections.emptyList();
    private Pattern filterPattern;

    public List<String> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<String> expressions) {
        this.expressions = expressions;
    }

    @Override
    public Map<String, String> supportedOptions() {
        HashMap<String, String> m = new HashMap<String, String>(super.supportedOptions());
        m.put("c", "");
        m.put("catalog", "c");
        m.put("u", "X");
        m.put("L", "X");
        return m;
    }

    private void makeRegularExpression() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.expressions) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(Pattern.quote(s)).append("$");
        }
        if (sb.length() == 0) {
            sb.append(".*");
        }
        this.filterPattern = Pattern.compile(sb.toString(), 2);
    }

    List<String> findComponentIds() {
        Collection<String> comps = this.catalog.getComponentIDs();
        ArrayList<String> ids = new ArrayList<String>(comps.size());
        for (String s : comps) {
            if (!this.filterPattern.matcher(s).find()) continue;
            ids.add(s);
        }
        Collections.sort(ids);
        return ids;
    }

    protected String acceptExpression(String expr) {
        return expr;
    }

    @Override
    public int execute() throws IOException {
        if (this.input.optValue("h") != null) {
            this.feedback.output("LIST_Help", new Object[0]);
            return 0;
        }
        this.init(this.input, this.feedback);
        this.expressions = new ArrayList<String>();
        while (this.input.hasParameter()) {
            String accepted;
            String s = this.input.nextParameter();
            if (s == null || s.isEmpty() || (accepted = this.acceptExpression(s)) == null) continue;
            this.expressions.add(accepted);
        }
        if (this.process()) {
            this.printComponents();
        }
        return 0;
    }

    protected Version.Match getVersionFilter() {
        return this.input.getLocalRegistry().getGraalVersion().match(Version.Match.Type.INSTALLABLE);
    }

    protected List<ComponentInfo> filterDisplayedVersions(String id, Collection<ComponentInfo> infos) {
        ArrayList<ComponentInfo> ordered = new ArrayList<ComponentInfo>(infos);
        Collections.sort(ordered, ComponentInfo.versionComparator());
        return ordered;
    }

    boolean process() {
        this.makeRegularExpression();
        List<String> ids = this.findComponentIds();
        ArrayList<MetadataException> exceptions = new ArrayList<MetadataException>();
        if (ids.isEmpty()) {
            this.feedback.message("LIST_NoComponentsFound", new Object[0]);
            return false;
        }
        Version.Match versionFilter = this.getVersionFilter();
        for (String string : ids) {
            try {
                Collection<ComponentInfo> infos = this.catalog.loadComponents(string, versionFilter, this.listFiles);
                if (infos == null) continue;
                for (ComponentInfo ci : this.filterDisplayedVersions(string, infos)) {
                    this.addComponent(null, ci);
                }
            }
            catch (MetadataException ex) {
                exceptions.add(ex);
            }
        }
        if (this.components.isEmpty()) {
            this.feedback.message("LIST_NoComponentsFound", new Object[0]);
            return false;
        }
        if (!exceptions.isEmpty()) {
            this.feedback.error("LIST_ErrorInComponentMetadata", null, new Object[0]);
            for (Exception exception : exceptions) {
                this.feedback.error("LIST_ErrorInComponentMetadataItem", exception, exception.getLocalizedMessage());
            }
        }
        return true;
    }
}

