/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.jar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.graalvm.component.installer.Archive;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.jar.JarArchive;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.persist.ComponentPackageLoader;

public class JarMetaLoader
extends ComponentPackageLoader {
    private final JarFile jarFile;
    private final Feedback fb;

    public JarMetaLoader(JarFile jarFile, Feedback feedback) throws IOException {
        super(new ManifestValues(jarFile), feedback);
        this.jarFile = jarFile;
        this.fb = feedback.withBundle(JarMetaLoader.class);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.jarFile.close();
    }

    @Override
    public Archive getArchive() {
        return new JarArchive(this.jarFile);
    }

    @Override
    public Map<String, String> loadPermissions() throws IOException {
        JarEntry permEntry = this.jarFile.getJarEntry("META-INF/permissions");
        if (permEntry == null) {
            return Collections.emptyMap();
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(this.jarFile.getInputStream(permEntry), "UTF-8"));){
            Map<String, String> permissions;
            Map<String, String> map = permissions = this.parsePermissions(r);
            return map;
        }
    }

    @Override
    public void loadPaths() {
        ComponentInfo cinfo = this.getComponentInfo();
        HashSet<String> emptyDirectories = new HashSet<String>();
        ArrayList<String> files = new ArrayList<String>();
        for (JarEntry en : Collections.list(this.jarFile.entries())) {
            String eName = en.getName();
            if (eName.startsWith("META-INF/")) continue;
            int li = eName.lastIndexOf("/", en.isDirectory() ? eName.length() - 2 : eName.length() - 1);
            if (li > 0) {
                emptyDirectories.remove(eName.substring(0, li + 1));
            }
            if (en.isDirectory()) {
                emptyDirectories.add(eName);
                continue;
            }
            files.add(eName);
        }
        this.addFiles(new ArrayList<String>(emptyDirectories));
        Collections.sort(files);
        cinfo.addPaths(files);
        this.addFiles(files);
    }

    @Override
    public Map<String, String> loadSymlinks() throws IOException {
        JarEntry symEntry = this.jarFile.getJarEntry("META-INF/symlinks");
        if (symEntry == null) {
            return Collections.emptyMap();
        }
        Properties links = new Properties();
        try (InputStream istm = this.jarFile.getInputStream(symEntry);){
            links.load(istm);
        }
        return this.parseSymlinks(links);
    }

    @Override
    public String getLicenseID() {
        String licPath = this.getLicensePath();
        if (licPath == null) {
            return null;
        }
        JarEntry je = this.jarFile.getJarEntry(licPath);
        if (je == null) {
            return null;
        }
        long crc = je.getCrc();
        return Long.toHexString(crc);
    }

    private static class ManifestValues
    implements Function<String, String> {
        private final Manifest mf;
        private final Attributes mainAttributes;

        ManifestValues(JarFile jf) throws IOException {
            this.mf = jf.getManifest();
            this.mainAttributes = this.mf == null ? null : this.mf.getMainAttributes();
        }

        @Override
        public String apply(String t) {
            return this.mainAttributes == null ? null : this.mainAttributes.getValue(t);
        }
    }
}

