/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.URLConnectionFactory;

public class ProxyConnectionFactory
implements URLConnectionFactory {
    private static final int DEFAULT_CONNECT_DELAY = Integer.getInteger("org.graalvm.component.installer.connectDelaySec", 10);
    private static final int DEFAULT_DIRECT_CONNECT_DELAY = Integer.getInteger("org.graalvm.component.installer.directConnectDelaySec", 20);
    private static final String PROXY_SCHEME_PREFIX = "http://";
    private final Feedback feedback;
    private final URL urlBase;
    private Connector winningConnector;
    private final ExecutorService connectors = Executors.newCachedThreadPool();
    String envHttpProxy = System.getProperty("http_proxy", System.getenv("http_proxy"));
    String envHttpsProxy = System.getProperty("https_proxy", System.getenv("https_proxy"));
    private int connectDelay = DEFAULT_CONNECT_DELAY;
    private int directConnectDelay = DEFAULT_DIRECT_CONNECT_DELAY;

    public ProxyConnectionFactory(Feedback feedback, URL urlBase) {
        this.feedback = feedback.withBundle(ProxyConnectionFactory.class);
        this.urlBase = urlBase;
    }

    public void setConnectDelay(int delay, int directDelay) {
        if (delay < 0) {
            throw new IllegalArgumentException();
        }
        this.connectDelay = delay;
        if (directDelay >= 0) {
            this.directConnectDelay = directDelay;
        } else {
            float factor = Math.min(1.0f, (float)DEFAULT_DIRECT_CONNECT_DELAY / (float)DEFAULT_CONNECT_DELAY);
            this.directConnectDelay = Math.round((float)delay * factor);
        }
    }

    public void setConnectDelayFactor(float factor) {
        this.connectDelay = Math.round((float)DEFAULT_CONNECT_DELAY * factor);
        this.directConnectDelay = Math.round((float)DEFAULT_DIRECT_CONNECT_DELAY * factor);
    }

    public ProxyConnectionFactory setProxy(boolean secure, String proxyURI) {
        if (secure) {
            this.envHttpsProxy = proxyURI;
        } else {
            this.envHttpProxy = proxyURI;
        }
        return this;
    }

    public URLConnection openConnection(URI relative, Consumer<URLConnection> configCallback) throws IOException {
        if (relative != null) {
            try {
                return this.openConnectionWithProxies(this.urlBase.toURI().resolve(relative).toURL(), configCallback);
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }
        return this.openConnectionWithProxies(this.urlBase, configCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLConnection openConnectionWithProxies(URL url, Consumer<URLConnection> configCallback) throws IOException {
        Connector winner;
        String httpsProxy;
        String httpProxy;
        CountDownLatch connected = new CountDownLatch(1);
        ConnectionContext ctx = new ConnectionContext(url, configCallback, connected);
        ProxyConnectionFactory proxyConnectionFactory = this;
        synchronized (proxyConnectionFactory) {
            httpProxy = this.envHttpProxy;
            httpsProxy = this.envHttpsProxy;
            winner = this.winningConnector;
        }
        boolean haveProxy = false;
        if (winner != null && winner.accepts(url)) {
            winner.bind(ctx);
            ctx.submit(winner);
        } else {
            if (httpProxy != null) {
                ctx.submit(new Connector(httpProxy).bind(ctx));
            }
            if (httpsProxy != null && !Objects.equals(httpProxy, httpsProxy)) {
                ctx.submit(new Connector(httpsProxy).bind(ctx));
            }
            ctx.submit(new Connector(null).bind(ctx));
        }
        ctx.start();
        int shouldDelay = haveProxy ? this.connectDelay : this.directConnectDelay;
        URLConnection res = null;
        try {
            if (shouldDelay > 0) {
                if (!connected.await(shouldDelay, TimeUnit.SECONDS)) {
                    throw ctx.getConnectException();
                }
                res = ctx.getConnection();
            } else {
                connected.await();
                res = ctx.getConnection();
            }
        }
        catch (InterruptedException ex) {
            throw new ConnectException(this.feedback.l10n("EXC_InterruptedConnectingTo", url));
        }
        return res;
    }

    @Override
    public URLConnection createConnection(URL u, Consumer<URLConnection> configCallback) throws IOException {
        try {
            return this.openConnection(u.toURI(), configCallback);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    final class Connector
    implements Runnable {
        private final String proxySpec;
        private URL url;
        private ConnectionContext context;

        Connector(String proxySpec) {
            this.proxySpec = proxySpec;
        }

        boolean isDirect() {
            return this.proxySpec == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean accepts(URL u) {
            Connector connector = this;
            synchronized (connector) {
                return Objects.equals(u.getAuthority(), this.url.getAuthority());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Connector bind(ConnectionContext ctx) {
            Connector connector = this;
            synchronized (connector) {
                this.context = ctx;
                this.url = ctx.url;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConnectionContext ctx;
            Connector connector = this;
            synchronized (connector) {
                ctx = this.context;
                this.context = null;
            }
            this.runWithContext(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runWithContext(ConnectionContext ctx) {
            Proxy proxy;
            if (this.isDirect()) {
                proxy = null;
            } else {
                if (this.proxySpec == null || this.proxySpec.isEmpty()) {
                    return;
                }
                try {
                    URI uri = new URI(this.proxySpec);
                    if (uri.getScheme() == null || uri.getHost() == null) {
                        try {
                            uri = new URI(ProxyConnectionFactory.PROXY_SCHEME_PREFIX + this.proxySpec);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                    InetSocketAddress address = InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort());
                    proxy = new Proxy(Proxy.Type.HTTP, address);
                }
                catch (URISyntaxException ex) {
                    ctx.setOutcome(false, new IOException(ex.getLocalizedMessage(), ex));
                    return;
                }
            }
            Consumer configCallback = ctx.configCallback;
            boolean won = false;
            URLConnection test = null;
            try {
                HttpURLConnection htest;
                int rcode;
                URLConnection uRLConnection = test = proxy == null ? this.url.openConnection() : this.url.openConnection(proxy);
                if (configCallback != null) {
                    configCallback.accept(test);
                }
                test.connect();
                if (test instanceof HttpURLConnection && (rcode = (htest = (HttpURLConnection)test).getResponseCode()) >= 400) {
                    block19: {
                        InputStream stm = test.getInputStream();
                        try {
                            stm.close();
                        }
                        catch (IOException ex) {
                            if (!this.isDirect()) break block19;
                            throw ex;
                        }
                    }
                    if (!this.isDirect()) {
                        throw new IOException(ProxyConnectionFactory.this.feedback.l10n("EXC_ProxyFailed", rcode));
                    }
                }
                won = ctx.setOutcome(this, test);
            }
            catch (IOException ex) {
                ctx.setOutcome(this.isDirect(), ex);
            }
            finally {
                if (!won && test instanceof HttpURLConnection) {
                    ((HttpURLConnection)test).disconnect();
                }
            }
        }
    }

    private class ConnectionContext {
        private final Consumer<URLConnection> configCallback;
        private final CountDownLatch countDown;
        private final URL url;
        private final List<Connector> tryConnectors = new ArrayList<Connector>();
        private Connector winner;
        private URLConnection openedConnection;
        private IOException exProxy;
        private IOException exDirect;
        private int outcomes;

        ConnectionContext(URL url, Consumer<URLConnection> configCallback, CountDownLatch latch) {
            this.configCallback = configCallback;
            this.countDown = latch;
            this.url = url;
        }

        synchronized URLConnection getConnection() throws IOException {
            if (this.openedConnection == null) {
                if (this.exDirect != null) {
                    throw this.exDirect;
                }
                if (this.exProxy != null) {
                    throw this.exProxy;
                }
                throw new ConnectException(ProxyConnectionFactory.this.feedback.l10n("EXC_CannotConnectTo", this.url));
            }
            return this.openedConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setOutcome(Connector w, URLConnection opened) {
            ConnectionContext connectionContext = this;
            synchronized (connectionContext) {
                if (this.winner != null) {
                    return false;
                }
                this.winner = w;
                this.openedConnection = opened;
            }
            if (this.countDown != null) {
                this.countDown.countDown();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setOutcome(boolean direct, IOException e) {
            ConnectionContext connectionContext = this;
            synchronized (connectionContext) {
                if (direct) {
                    this.exDirect = e;
                } else {
                    this.exProxy = e;
                }
                if (++this.outcomes == this.tryConnectors.size()) {
                    this.countDown.countDown();
                }
            }
        }

        synchronized IOException getConnectException() {
            if (this.exDirect != null) {
                return this.exDirect;
            }
            return new ConnectException(ProxyConnectionFactory.this.feedback.l10n("EXC_TimeoutConnectTo", this.url));
        }

        synchronized void submit(Connector c) {
            this.tryConnectors.add(c);
        }

        void start() {
            for (Connector c : this.tryConnectors) {
                ProxyConnectionFactory.this.connectors.submit(c);
            }
        }
    }
}

