/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.ContextActionEnabler;
import org.openide.awt.ContextActionPerformer;
import org.openide.awt.ContextManager;
import org.openide.awt.ContextSelection;
import org.openide.awt.GeneralAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;

class ContextAction<T>
implements Action,
ContextAwareAction,
ChangeListener,
Runnable {
    static final Logger LOG = Logger.getLogger(ContextAction.class.getName());
    final Class<T> type;
    final ContextSelection selectMode;
    final Performer<? super T> performer;
    final ContextManager global;
    private PropertyChangeSupport support;
    private boolean previousEnabled;
    protected final StatefulMonitor enableMonitor;
    private static final Reference<Object> NONE = new WeakReference<Object>(null);

    public ContextAction(Performer<? super T> performer, ContextSelection contextSelection, Lookup lookup, Class<T> clazz, boolean bl, StatefulMonitor statefulMonitor) {
        if (performer == null) {
            throw new NullPointerException("Has to provide a key!");
        }
        this.type = clazz;
        this.selectMode = contextSelection;
        this.performer = performer;
        this.global = ContextManager.findManager(lookup, bl);
        this.enableMonitor = statefulMonitor;
        if (statefulMonitor != null) {
            LOG.log(Level.FINE, "Setting enable monitor {0}: {1}", new Object[]{this, statefulMonitor});
        }
    }

    public String toString() {
        return super.toString() + "[type=" + this.type + ", performer=" + this.performer + "]";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.global.actionPerformed(actionEvent, this.performer, this.type, this.selectMode);
    }

    @Override
    public boolean isEnabled() {
        assert (EventQueue.isDispatchThread());
        boolean bl = this.enableMonitor != null ? this.fetchEnabledValue() : this.global.isEnabled(this.type, this.selectMode, this.performer);
        this.previousEnabled = bl;
        return bl;
    }

    private boolean fetchEnabledValue() {
        return this.global.runEnabled(this.type, this.selectMode, (list2, provider2) -> {
            Supplier<Action> supplier = () -> (Action)((Performer)this.performer).delegate0(provider2, list2, true);
            if (this.enableMonitor.getType() == Action.class) {
                Action action = (Action)this.performer.delegate((Lookup.Provider)provider2, (List<?>)list2);
                return this.enableMonitor.enabled(Collections.singletonList(action), () -> action);
            }
            if (this.enableMonitor.getType() != this.type) {
                return this.global.runEnabled(this.enableMonitor.getType(), this.selectMode, (list, provider) -> this.enableMonitor.enabled(list, supplier));
            }
            return this.enableMonitor.enabled(list2, supplier);
        });
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Mutex.EVENT.readAccess((Runnable)this);
    }

    @Override
    public void run() {
        this.updateStateProperties();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl = false;
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
            bl = true;
        }
        this.support.addPropertyChangeListener(propertyChangeListener);
        if (bl) {
            this.startListeners();
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null != this.support) {
            this.support.removePropertyChangeListener(propertyChangeListener);
            if (!this.support.hasListeners(null)) {
                this.stopListeners();
                this.support = null;
            }
        }
    }

    protected void startListeners() {
        this.performer.startListeners();
        this.global.registerListener(this.type, this);
        if (this.enableMonitor != null) {
            this.fetchEnabledValue();
            this.enableMonitor.addChangeListener(this);
        }
    }

    protected void stopListeners() {
        this.global.unregisterListener(this.type, this);
        this.performer.stopListeners();
        if (this.enableMonitor != null) {
            this.enableMonitor.removeChangeListener(this);
        }
    }

    @Override
    public void putValue(String string, Object object) {
    }

    @Override
    public Object getValue(String string) {
        if ("enabler".equals(string)) {
            assert (EventQueue.isDispatchThread());
            this.updateState();
        } else if ("ActionCommandKey".equals(string)) {
            Object v = this.performer.delegate.get("ActionCommandKey");
            if (v == null) {
                v = this.performer.delegate.get("key");
            }
            if (v != null) {
                return v.toString();
            }
        }
        return null;
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    void clearState() {
        this.performer.clear();
        if (this.enableMonitor != null) {
            this.enableMonitor.clear();
        }
    }

    void updateState() {
        this.clearState();
        if (!this.isListening()) {
            return;
        }
        this.updateStateProperties();
    }

    void updateStateProperties() {
        boolean bl = this.previousEnabled;
        boolean bl2 = this.isEnabled();
        if (bl != bl2) {
            this.updateEnabledState(bl2);
        }
    }

    boolean wasEnabled() {
        return this.previousEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isListening() {
        ContextAction contextAction = this;
        synchronized (contextAction) {
            return this.support != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChange(String string, Boolean bl, Boolean bl2) {
        PropertyChangeSupport propertyChangeSupport;
        ContextAction contextAction = this;
        synchronized (contextAction) {
            propertyChangeSupport = this.support;
            if (propertyChangeSupport == null) {
                return;
            }
        }
        propertyChangeSupport.firePropertyChange(string, bl, bl2);
    }

    protected void updateEnabledState(boolean bl) {
        this.previousEnabled = bl;
        this.firePropertyChange("enabled", !bl, bl);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction<T>(this.performer, this.selectMode, lookup, this.type, this.global.isSurvive(), this.enableMonitor == null ? null : this.enableMonitor.createContextMonitor(lookup));
    }

    public int hashCode() {
        int n = this.type.hashCode();
        int n2 = this.selectMode.hashCode();
        int n3 = this.performer.hashCode();
        return (n << 2) + (n2 << 1) + n3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ContextAction) {
            ContextAction contextAction = (ContextAction)object;
            return this.type.equals(contextAction.type) && this.selectMode.equals((Object)contextAction.selectMode) && this.performer.equals(contextAction.performer);
        }
        return false;
    }

    static interface StatefulMonitor<T> {
        public void clear();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public boolean enabled(List<? extends T> var1, Supplier<Action> var2);

        public Class<?> getType();

        public StatefulMonitor<T> createContextMonitor(Lookup var1);
    }

    static class Performer<Data>
    implements ChangeListener {
        final Map delegate;
        Reference<ContextAction> owner;
        Reference<Object> instDelegate = null;
        StatefulMonitor enabler = null;
        ChangeListener weakEnableListener;
        PropertyChangeListener weakActionListener;

        public Performer(Map map) {
            this.delegate = map;
        }

        public Performer(ContextActionPerformer<Data> contextActionPerformer, ContextActionEnabler<Data> contextActionEnabler) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("delegate", contextActionPerformer);
            hashMap.put("enabler", contextActionEnabler);
            this.delegate = hashMap;
        }

        void clear() {
            Object object;
            this.stopListeners();
            Reference<Object> reference = this.instDelegate;
            this.instDelegate = null;
            if (reference != null && (object = reference.get()) instanceof Performer) {
                ((Performer)object).clear();
            }
        }

        void attach(ContextAction contextAction) {
            this.owner = new WeakReference<ContextAction>(contextAction);
        }

        Object delegate(Lookup.Provider provider, List<?> list) {
            return this.delegate0(provider, list, true);
        }

        private Object delegate0(Lookup.Provider provider, List<?> list, boolean bl) {
            Object object;
            Object object2 = object = this.instDelegate != null ? this.instDelegate.get() : null;
            if (object != null) {
                if (bl && object instanceof Performer) {
                    return ((Performer)object).delegate0(provider, list, bl);
                }
                return object;
            }
            object = this.createDelegate(provider, list);
            if (object != null) {
                if (bl && object instanceof Performer) {
                    final Object object3 = object;
                    this.instDelegate = new WeakReference<Object>(object){
                        private Object hardRef;
                        {
                            super(object);
                            this.hardRef = object3;
                        }
                    };
                    return ((Performer)object).delegate0(provider, list, bl);
                }
                if (object instanceof ContextAwareAction) {
                    object = ((ContextAwareAction)object).createContextAwareInstance(provider.getLookup());
                }
                this.instDelegate = new WeakReference<Object>(object);
            } else {
                this.instDelegate = NONE;
            }
            return object;
        }

        void stopListeners() {
            if (this.enabler != null) {
                this.enabler.removeChangeListener(this.weakEnableListener);
                this.weakEnableListener = null;
            }
        }

        void startListeners() {
            if (this.enabler != null) {
                this.weakEnableListener = WeakListeners.change((ChangeListener)this, (Object)this.enabler);
                this.enabler.addChangeListener(this.weakEnableListener);
            }
        }

        void detach() {
            Object object;
            this.stopListeners();
            Object object2 = object = this.instDelegate != null ? this.instDelegate.get() : null;
            if (object instanceof Action) {
                ((Action)object).removePropertyChangeListener(this.weakActionListener);
            }
        }

        public boolean enabled(List<? extends Object> list, Lookup.Provider provider) {
            Object v = this.delegate.get("enabler");
            if (v == null) {
                return true;
            }
            if (v instanceof ContextActionEnabler) {
                ContextActionEnabler contextActionEnabler = (ContextActionEnabler)v;
                return contextActionEnabler.enabled(list);
            }
            GeneralAction.LOG.warning("Wrong enabler for " + this.delegate + ":" + v);
            return false;
        }

        protected Object createDelegate(Lookup.Provider provider, List<?> list) {
            Object v = this.delegate.get("delegate");
            if (v instanceof ContextActionPerformer) {
                return v;
            }
            if (v instanceof Performer) {
                return v;
            }
            if (!(v instanceof ActionListener)) {
                GeneralAction.LOG.warning("Wrong delegate for " + this.delegate + ":" + v);
            }
            return v;
        }

        public void actionPerformed(ActionEvent actionEvent, List<? extends Data> list, Lookup.Provider provider) {
            Object object = this.delegate0(provider, list, false);
            if (object instanceof ContextActionPerformer) {
                ContextActionPerformer contextActionPerformer = (ContextActionPerformer)object;
                contextActionPerformer.actionPerformed(actionEvent, list);
                return;
            }
            if (object instanceof Performer) {
                Performer performer = (Performer)object;
                performer.actionPerformed(actionEvent, list, provider);
                return;
            }
            if (object instanceof ActionListener) {
                ((ActionListener)object).actionPerformed(actionEvent);
            }
        }

        public int hashCode() {
            return this.delegate.hashCode() + 117;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Performer) {
                Performer performer = (Performer)object;
                return this.delegate.equals(performer.delegate);
            }
            return false;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ContextAction contextAction = this.owner.get();
            if (contextAction != null) {
                contextAction.updateState();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Object v = this.delegate.get("ActionCommandKey");
            if (v == null) {
                v = this.delegate.get("key");
            }
            Object object = this.instDelegate == null ? null : this.instDelegate.get();
            stringBuilder.append("Performer{id = ").append(Objects.toString(v)).append(", del = ").append(Objects.toString(object)).append("}");
            return stringBuilder.toString();
        }
    }
}

