/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import org.graalvm.compiler.nodes.ValueNode;

public class NullCheckTypeFlow
extends TypeFlow<ValueNode> {
    private final boolean filterNull;

    public NullCheckTypeFlow(ValueNode node, AnalysisType inputType, boolean filterNull) {
        super(node, inputType);
        this.filterNull = filterNull;
    }

    public NullCheckTypeFlow(MethodFlowsGraph methodFlows, NullCheckTypeFlow original) {
        super(original, methodFlows);
        this.filterNull = original.filterNull;
    }

    @Override
    public TypeFlow<ValueNode> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        return new NullCheckTypeFlow(methodFlows, this);
    }

    public boolean isFilterNull() {
        return this.filterNull;
    }

    @Override
    public TypeState filter(BigBang bb, TypeState newState) {
        if (this.filterNull) {
            return newState.forNonNull(bb);
        }
        if (newState.canBeNull()) {
            return TypeState.forNull();
        }
        return TypeState.forEmpty();
    }

    @Override
    public boolean addState(BigBang bb, TypeState add) {
        assert (this.isClone());
        return super.addState(bb, add);
    }

    @Override
    public String toString() {
        return "NullCheckTypeFlow<" + (this.getDeclaredType() != null ? this.getDeclaredType().toJavaName(false) : "null") + " : " + this.getState() + ">";
    }
}

