/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class AnalysisError
extends Error {
    private static final long serialVersionUID = -4489048906003856416L;

    AnalysisError() {
    }

    AnalysisError(String msg) {
        super(msg);
    }

    AnalysisError(Throwable ex) {
        super(ex);
    }

    AnalysisError(String msg, Throwable cause) {
        super(msg, cause);
    }

    private static String parsingContext(AnalysisMethod method) {
        StringBuilder msg = new StringBuilder("Parsing context:");
        if (method.getTypeFlow().getParsingContext().length > 0) {
            for (StackTraceElement e : method.getTypeFlow().getParsingContext()) {
                msg.append(String.format("%n\tparsing %s", e));
            }
            msg.append(String.format("%n", new Object[0]));
        } else {
            msg.append(String.format(" <no parsing context available> %n", new Object[0]));
        }
        return msg.toString();
    }

    public static TypeNotFoundError typeNotFound(ResolvedJavaType type) {
        throw new TypeNotFoundError(type);
    }

    public static ParsingError parsingError(AnalysisMethod method, Throwable original) {
        throw new ParsingError(method, original);
    }

    public static FieldNotPresentError fieldNotPresentError(AnalysisMethod context, AnalysisField field, AnalysisType type) {
        throw new FieldNotPresentError(context, field, type);
    }

    public static RuntimeException shouldNotReachHere() {
        throw new AnalysisError("should not reach here");
    }

    public static RuntimeException shouldNotReachHere(String msg) {
        throw new AnalysisError("should not reach here: " + msg);
    }

    public static RuntimeException shouldNotReachHere(Throwable cause) {
        throw new AnalysisError(cause);
    }

    public static class FieldNotPresentError
    extends AnalysisError {
        private static final long serialVersionUID = -7167507945764369928L;

        FieldNotPresentError(AnalysisMethod context, AnalysisField field, AnalysisType type) {
            super(FieldNotPresentError.message(context, field, type));
        }

        private static String message(AnalysisMethod context, AnalysisField field, AnalysisType type) {
            String msg = String.format("Field %s is not present on type %s. ", field.format("%H.%n"), type.toJavaName());
            if (context != null) {
                msg = msg + String.format("Error encountered while analysing %s %n", context.format("%H.%n(%P)"));
                msg = msg + AnalysisError.parsingContext(context);
            }
            return msg;
        }
    }

    public static class ParsingError
    extends AnalysisError {
        private static final long serialVersionUID = -7167507945764369928L;
        private final AnalysisMethod method;

        ParsingError(AnalysisMethod method, Throwable cause) {
            super(ParsingError.message(method), cause);
            this.method = method;
        }

        public AnalysisMethod getMethod() {
            return this.method;
        }

        private static String message(AnalysisMethod method) {
            String msg = String.format("Error encountered while parsing %s %n", method.format("%H.%n(%P)"));
            msg = msg + AnalysisError.parsingContext(method);
            return msg;
        }
    }

    public static class TypeNotFoundError
    extends AnalysisError {
        private static final long serialVersionUID = -7167507945764369928L;
        private final ResolvedJavaType type;

        TypeNotFoundError(ResolvedJavaType type) {
            super("Type not found during analysis: " + type);
            this.type = type;
        }

        public ResolvedJavaType getType() {
            return this.type;
        }
    }
}

