/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle.memory;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.sampler.truffle.cpu.ThreadInfoProvider;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MemoryHistogramProvider {
    private static final Logger LOGGER = Logger.getLogger(ThreadInfoProvider.class.getName());
    private static String AGENT_PATH = "modules/ext/stagent.jar";
    private final String status;
    private ObjectName truffleObjectName;
    private MBeanServerConnection conn;

    public MemoryHistogramProvider(Application app) {
        this.status = this.initialize(app);
    }

    public String getStatus() {
        return this.status;
    }

    private String initialize(Application application) {
        if (application.getState() != 1) {
            return NbBundle.getMessage(MemoryHistogramProvider.class, (String)"MSG_unavailable");
        }
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)application);
        if (jmxModel == null) {
            return NbBundle.getMessage(MemoryHistogramProvider.class, (String)"MSG_unavailable_init_jmx");
        }
        if (jmxModel.getConnectionState() != JmxModel.ConnectionState.CONNECTED) {
            return NbBundle.getMessage(MemoryHistogramProvider.class, (String)"MSG_unavailable_create_jmx");
        }
        this.conn = jmxModel.getMBeanServerConnection();
        try {
            if (!this.checkandLoadJMX(application)) {
                return NbBundle.getMessage(MemoryHistogramProvider.class, (String)"MSG_unavailable_threads");
            }
            if (!this.isHeapHistogramEnabled()) {
                return NbBundle.getMessage(MemoryHistogramProvider.class, (String)"MSG_unavailable_heaphisto");
            }
        }
        catch (SecurityException e) {
            LOGGER.log(Level.INFO, "MemoryHistogramProvider.initialize() throws SecurityException for " + application, e);
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads");
        }
        catch (Throwable t) {
            LOGGER.log(Level.INFO, "MemoryHistogramProvider.initialize() throws Throwable for " + application, t);
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads");
        }
        return null;
    }

    Map<String, Object>[] heapHistogram() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return (Map[])this.conn.invoke(this.truffleObjectName, "heapHistogram", null, null);
    }

    boolean isHeapHistogramEnabled() throws InstanceNotFoundException, MBeanException, IOException, ReflectionException, AttributeNotFoundException {
        return (Boolean)this.conn.getAttribute(this.truffleObjectName, "HeapHistogramEnabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkandLoadJMX(Application app) throws MalformedObjectNameException, IOException, InterruptedException {
        Application application = app;
        synchronized (application) {
            this.truffleObjectName = new ObjectName("com.truffle:type=Threading");
            if (this.conn.isRegistered(this.truffleObjectName)) {
                return true;
            }
            if (this.loadAgent(app)) {
                for (int i = 0; i < 10; ++i) {
                    if (this.conn.isRegistered(this.truffleObjectName)) {
                        return true;
                    }
                    Thread.sleep(300L);
                }
            }
            return this.conn.isRegistered(this.truffleObjectName);
        }
    }

    boolean loadAgent(Application app) {
        String pid = String.valueOf(app.getPid());
        String agentPath = this.getAgentPath();
        LOGGER.warning("Agent " + agentPath);
        try {
            VirtualMachine vm = VirtualMachine.attach(pid);
            LOGGER.warning(vm.toString());
            vm.loadAgent(agentPath);
            vm.detach();
            LOGGER.warning("Agent loaded");
            return true;
        }
        catch (AttachNotSupportedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (AgentLoadException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (AgentInitializationException ex) {
            LOGGER.log(Level.INFO, "loadAgent()", ex);
        }
        return false;
    }

    private String getAgentPath() {
        InstalledFileLocator loc = InstalledFileLocator.getDefault();
        File jar = loc.locate(AGENT_PATH, "org.graalvm.visualvm.sampler.truffle", false);
        return jar.getAbsolutePath();
    }
}

