/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstanceReferenceNode;
import org.graalvm.visualvm.heapviewer.java.PrimitiveNode;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;

public abstract class JavaFieldsProvider
extends HeapViewerNode.Provider {
    @Override
    public HeapViewerNode[] getNodes(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        List<FieldValue> fields = this.getFields(parent, heap);
        return JavaFieldsProvider.getNodes(fields, parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
    }

    static HeapViewerNode[] getNodes(final List<FieldValue> fields, HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        if (fields == null) {
            return null;
        }
        NodesComputer<Integer> computer = new NodesComputer<Integer>(fields.size(), UIThresholds.MAX_INSTANCE_FIELDS){

            @Override
            protected boolean sorts(DataType dataType) {
                return !DataType.COUNT.equals(dataType);
            }

            @Override
            protected HeapViewerNode createNode(Integer index) {
                FieldValue field = (FieldValue)fields.get(index);
                return field instanceof ObjectFieldValue ? new InstanceReferenceNode.Field((ObjectFieldValue)field, false) : new PrimitiveNode.Field(field);
            }

            @Override
            protected ProgressIterator<Integer> objectsIterator(int index, Progress progress) {
                Iterator<Integer> iterator = 1.integerIterator(index, fields.size());
                return new ProgressIterator<Integer>(iterator, index, false, progress);
            }

            @Override
            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.JavaFieldsProvider_MoreNodes(moreNodesCount);
            }

            @Override
            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.JavaFieldsProvider_SamplesContainer(objectsCount);
            }

            @Override
            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.JavaFieldsProvider_NodesContainer(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
    }

    protected abstract List<FieldValue> getFields(HeapViewerNode var1, Heap var2);

    public static class ClassFieldsProvider
    extends JavaFieldsProvider {
        @Override
        public String getName() {
            return Bundle.ClassFieldsProvider_Name();
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("java_objects");
        }

        @Override
        public boolean supportsNode(HeapViewerNode parent, Heap heap, String viewID) {
            if (parent instanceof ClassNode) {
                JavaClass javaClass = ((ClassNode)parent).getJavaClass();
                return javaClass != null && !javaClass.isArray();
            }
            return false;
        }

        @Override
        protected List<FieldValue> getFields(HeapViewerNode parent, Heap heap) {
            JavaClass jclass = HeapViewerNode.getValue(parent, DataType.CLASS, heap);
            return jclass == null ? null : jclass.getStaticFieldValues();
        }
    }

    public static class InstanceFieldsProvider
    extends JavaFieldsProvider {
        private boolean includeStaticFields = true;
        private boolean includeInstanceFields = true;

        @Override
        public String getName() {
            return Bundle.InstanceFieldsProvider_Name();
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("java_");
        }

        @Override
        public boolean supportsNode(HeapViewerNode parent, Heap heap, String viewID) {
            if (parent instanceof InstanceNode && !InstanceNode.Mode.INCOMING_REFERENCE.equals((Object)((InstanceNode)parent).getMode())) {
                Instance instance = ((InstanceNode)parent).getInstance();
                return instance != null && !instance.getJavaClass().isArray();
            }
            return false;
        }

        @Override
        protected List<FieldValue> getFields(HeapViewerNode parent, Heap heap) {
            return InstanceFieldsProvider.getFields(parent, heap, this.includeInstanceFields, this.includeStaticFields);
        }

        static List<FieldValue> getFields(HeapViewerNode parent, Heap heap, boolean instanceFields, boolean staticFields) {
            Instance instance = HeapViewerNode.getValue(parent, DataType.INSTANCE, heap);
            if (instance == null) {
                return null;
            }
            if (staticFields == instanceFields) {
                ArrayList<FieldValue> fields = new ArrayList<FieldValue>(instance.getFieldValues());
                fields.addAll(instance.getStaticFieldValues());
                return fields;
            }
            if (instanceFields) {
                return instance.getFieldValues();
            }
            return instance.getStaticFieldValues();
        }
    }
}

