/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstanceNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.InstanceReferenceNode;
import org.graalvm.visualvm.heapviewer.java.InstancesWrapper;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.java.impl.JavaReferencesProvider;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.ErrorNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.swing.LinkButton;
import org.graalvm.visualvm.heapviewer.ui.HeapViewPlugin;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.heapviewer.ui.TreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.ExcludingIterator;
import org.graalvm.visualvm.heapviewer.utils.HeapOperations;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.heapviewer.utils.InterruptibleIterator;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.Value;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

class JavaReferencesPlugin
extends HeapViewPlugin {
    private static final TreeTableView.ColumnConfiguration CCONF_CLASS = new TreeTableView.ColumnConfiguration(DataType.COUNT, null, DataType.COUNT, SortOrder.DESCENDING, Boolean.FALSE);
    private static final TreeTableView.ColumnConfiguration CCONF_INSTANCE = new TreeTableView.ColumnConfiguration(null, DataType.COUNT, DataType.NAME, SortOrder.UNSORTED, null);
    private final Heap heap;
    private HeapViewerNode selected;
    private volatile boolean mergedRequest;
    private final TreeTableView objectsView;
    private JComponent component;
    private static final String KEY_MERGED_REFERENCES = "HeapViewer.autoMergedReferences";
    private static final String KEY_LOGICAL_REFERENCES = "HeapViewer.logicalReferences";
    private static final Set<String> COLLAPSED_ITEMS = new HashSet<String>(Arrays.asList("java.util.HashMap$Node", "java.util.WeakHashMap$Entry"));

    public JavaReferencesPlugin(HeapContext context, HeapViewerActions actions, final JavaReferencesProvider provider) {
        super(Bundle.JavaReferencesPlugin_Name(), Bundle.JavaReferencesPlugin_Description(), Icons.getIcon((String)"ProfilerIcons.NodeReverse"));
        this.heap = context.getFragment().getHeap();
        TreeTableViewColumn[] columns = new TreeTableViewColumn[]{new TreeTableViewColumn.Name(this.heap), new TreeTableViewColumn.LogicalValue(this.heap), new TreeTableViewColumn.Count(this.heap, true, true), new TreeTableViewColumn.OwnSize(this.heap, false, false), new TreeTableViewColumn.RetainedSize(this.heap, false, false), new TreeTableViewColumn.ObjectID(this.heap)};
        this.objectsView = new TreeTableView("java_objects_references", context, actions, columns){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                HeapViewerNode _selected;
                if (JavaReferencesPlugin.this.mergedRequest) {
                    return HeapViewerNode.NO_NODES;
                }
                TreeTableView treeTableView = JavaReferencesPlugin.this.objectsView;
                synchronized (treeTableView) {
                    _selected = JavaReferencesPlugin.this.selected;
                }
                if (_selected == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!CCONF_INSTANCE.equals(JavaReferencesPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                                JavaReferencesPlugin.this.objectsView.configureColumns(CCONF_INSTANCE);
                            }
                        }
                    });
                    return new HeapViewerNode[]{new TextNode(Bundle.JavaReferencesPlugin_NoSelection())};
                }
                InstancesWrapper wrapper = HeapViewerNode.getValue(_selected, DataType.INSTANCES_WRAPPER, heap);
                if (wrapper != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!CCONF_CLASS.equals(JavaReferencesPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                                JavaReferencesPlugin.this.objectsView.configureColumns(CCONF_CLASS);
                            }
                        }
                    });
                    return JavaReferencesPlugin.this.computeInstancesReferences(wrapper, root, heap, viewID, null, dataTypes, sortOrders, progress);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!CCONF_INSTANCE.equals(JavaReferencesPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                            JavaReferencesPlugin.this.objectsView.configureColumns(CCONF_INSTANCE);
                        }
                    }
                });
                Instance instance = HeapViewerNode.getValue(_selected, DataType.INSTANCE, heap);
                if (instance != null) {
                    HeapViewerNode[] heapViewerNodeArray;
                    HeapViewerNode[] nodes = provider.getNodes(instance, root, heap, viewID, null, dataTypes, sortOrders, progress);
                    if (nodes == null || nodes.length == 0) {
                        HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
                        heapViewerNodeArray = heapViewerNodeArray2;
                        heapViewerNodeArray2[0] = new TextNode(Bundle.JavaReferencesPlugin_NoReferences());
                    } else {
                        heapViewerNodeArray = nodes;
                    }
                    return heapViewerNodeArray;
                }
                return new HeapViewerNode[]{new TextNode(Bundle.JavaReferencesPlugin_NoSelection())};
            }

            @Override
            protected void populatePopup(HeapViewerNode node, JPopupMenu popup) {
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                popup.add(new JCheckBoxMenuItem(Bundle.JavaReferencesPlugin_AutoComputeMergedReferencesLbl(), JavaReferencesPlugin.this.isAutoMerge()){

                    @Override
                    protected void fireActionPerformed(ActionEvent event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JavaReferencesPlugin.this.setAutoMerge(this.isSelected());
                            }
                        });
                    }
                });
                if (!CCONF_INSTANCE.equals(JavaReferencesPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                    popup.add(new JCheckBoxMenuItem(Bundle.JavaReferencesPlugin_MenuShowLogicalReferences(), JavaReferencesPlugin.this.isLogicalReferences()){

                        @Override
                        protected void fireActionPerformed(ActionEvent event) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JavaReferencesPlugin.this.setLogicalReferences(this.isSelected());
                                    if (CCONF_CLASS.equals(JavaReferencesPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                                        this.reloadView();
                                    }
                                }
                            });
                        }
                    });
                }
            }
        };
    }

    private void showObjectsView() {
        JComponent c = this.objectsView.getComponent();
        if (c.isVisible()) {
            return;
        }
        c.setVisible(true);
        this.component.removeAll();
        this.component.add((Component)c, "Center");
        this.mergedRequest = false;
        this.component.invalidate();
        this.component.revalidate();
        this.component.repaint();
    }

    private void showMergedView() {
        JComponent c = this.objectsView.getComponent();
        if (!c.isVisible()) {
            return;
        }
        c.setVisible(false);
        this.component.removeAll();
        JButton jb = new JButton(Bundle.JavaReferencesPlugin_ComputeMergedReferencesLbl(), Icons.getIcon((String)"ProfilerIcons.NodeReverse")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                JavaReferencesPlugin.this.showObjectsView();
                JavaReferencesPlugin.this.objectsView.reloadView();
            }
        };
        jb.setIconTextGap(jb.getIconTextGap() + 2);
        jb.setToolTipText(Bundle.JavaReferencesPlugin_ComputeMergedReferencesTtp());
        Insets margin = jb.getMargin();
        if (margin != null) {
            jb.setMargin(new Insets(margin.top + 3, margin.left + 3, margin.bottom + 3, margin.right + 3));
        }
        LinkButton lb = new LinkButton(Bundle.JavaReferencesPlugin_AutoComputeMergedReferencesLbl()){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                JavaReferencesPlugin.this.setAutoMerge(true);
                JavaReferencesPlugin.this.showObjectsView();
                JavaReferencesPlugin.this.objectsView.reloadView();
            }
        };
        lb.setToolTipText(Bundle.JavaReferencesPlugin_AutoComputeMergedReferencesTtp());
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GridBagConstraints g = new GridBagConstraints();
        g.fill = 2;
        g.gridy = 0;
        p.add((Component)jb, g);
        g = new GridBagConstraints();
        g.fill = 2;
        g.gridy = 1;
        g.insets = new Insets(10, 0, 0, 0);
        p.add((Component)lb, g);
        this.component.add(p);
        this.mergedRequest = true;
        this.component.invalidate();
        this.component.revalidate();
        this.component.repaint();
    }

    @Override
    protected JComponent createComponent() {
        this.component = new JPanel(new BorderLayout());
        this.component.setOpaque(true);
        this.component.setBackground(UIUtils.getProfilerResultsBackground());
        this.objectsView.getComponent().setVisible(false);
        this.showObjectsView();
        return this.component;
    }

    @Override
    protected void closed() {
        this.objectsView.closed();
    }

    private static InterruptibleIterator<Instance> instancesIterator(InstancesWrapper instances) {
        return new InterruptibleIterator<Instance>(instances.getInstancesIterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeapViewerNode[] computeInstancesReferences(final InstancesWrapper instances, RootNode root, final Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        HeapOperations.initializeReferences(heap);
        final HashMap<Long, Integer> values = new HashMap<Long, Integer>();
        try {
            progress.setupKnownSteps(instances.getInstancesCount());
            InterruptibleIterator<Instance> instancesI = JavaReferencesPlugin.instancesIterator(instances);
            while (instancesI.hasNext()) {
                Instance instance = instancesI.next();
                progress.step();
                List references = instance.getReferences();
                HashSet<Instance> referers = new HashSet<Instance>();
                if (references.isEmpty()) {
                    referers.add(null);
                } else {
                    for (Value reference : references) {
                        referers.add(this.logicalReferer(reference.getDefiningInstance()));
                    }
                }
                for (Instance referer : referers) {
                    long refererID = referer == null ? -1L : referer.getInstanceId();
                    Integer count = (Integer)values.get(refererID);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    values.put(refererID, count);
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of memory in JavaReferencesPlugin: " + e.getMessage());
            HeapUtils.handleOOME(true, e);
            HeapViewerNode[] heapViewerNodeArray = new HeapViewerNode[]{new ErrorNode.OOME()};
            return heapViewerNodeArray;
        }
        finally {
            progress.finish();
        }
        if (values.isEmpty()) {
            return new HeapViewerNode[]{new TextNode(Bundle.JavaReferencesPlugin_NoReferences())};
        }
        NodesComputer<Map.Entry<Long, Integer>> computer = new NodesComputer<Map.Entry<Long, Integer>>(values.size(), UIThresholds.MAX_CLASS_INSTANCES){

            @Override
            protected boolean sorts(DataType dataType) {
                return true;
            }

            @Override
            protected HeapViewerNode createNode(final Map.Entry<Long, Integer> node) {
                long refererID = node.getKey();
                return new ReferenceNode(refererID == -1L ? null : heap.getInstanceByID(refererID)){

                    @Override
                    int getCount() {
                        return (Integer)node.getValue();
                    }

                    @Override
                    InterruptibleIterator<Instance> instancesIterator() {
                        return JavaReferencesPlugin.instancesIterator(instances);
                    }
                };
            }

            @Override
            protected ProgressIterator<Map.Entry<Long, Integer>> objectsIterator(int index, Progress progress) {
                Iterator iterator = values.entrySet().iterator();
                return new ProgressIterator<Map.Entry<Long, Integer>>(iterator, index, true, progress);
            }

            @Override
            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.JavaReferencesPlugin_MoreNodes(moreNodesCount);
            }

            @Override
            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.JavaReferencesPlugin_SamplesContainer(objectsCount);
            }

            @Override
            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.JavaReferencesPlugin_NodesContainer(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(root, heap, viewID, null, dataTypes, sortOrders, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        TreeTableView treeTableView = this.objectsView;
        synchronized (treeTableView) {
            if (Objects.equals((Object)this.selected, (Object)node)) {
                return;
            }
            this.selected = node;
        }
        if (this.selected != null && !this.isAutoMerge() && HeapViewerNode.getValue(this.selected, DataType.INSTANCES_WRAPPER, this.heap) != null) {
            this.showMergedView();
        } else {
            this.showObjectsView();
        }
        this.objectsView.reloadView();
    }

    private boolean isAutoMerge() {
        return NbPreferences.root().getBoolean(KEY_MERGED_REFERENCES, false);
    }

    private void setAutoMerge(boolean value) {
        NbPreferences.root().putBoolean(KEY_MERGED_REFERENCES, value);
    }

    private boolean isLogicalReferences() {
        return NbPreferences.root().getBoolean(KEY_LOGICAL_REFERENCES, false);
    }

    private void setLogicalReferences(boolean value) {
        NbPreferences.root().putBoolean(KEY_LOGICAL_REFERENCES, value);
    }

    private Instance logicalReferer(Instance realReferer) {
        if (realReferer == null) {
            return null;
        }
        return this.isLogicalReferences() ? this.logicalRefererImpl(realReferer) : realReferer;
    }

    private Instance logicalRefererImpl(Instance realReferer) {
        Value reference;
        JavaClass jclass = realReferer.getJavaClass();
        if (jclass.isArray() && (reference = JavaReferencesPlugin.getDirectReferrer(realReferer)) != null) {
            return this.logicalRefererImpl(reference.getDefiningInstance());
        }
        if (COLLAPSED_ITEMS.contains(jclass.getName()) && (reference = JavaReferencesPlugin.getDirectReferrer(realReferer)) != null) {
            return this.logicalRefererImpl(reference.getDefiningInstance());
        }
        return realReferer;
    }

    private static Value getDirectReferrer(Instance instance) {
        List references = instance.getReferences();
        return references.size() == 1 ? (Value)references.get(0) : null;
    }

    public static class Provider
    extends HeapViewPlugin.Provider {
        @Override
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (!viewID.startsWith("diff") && JavaHeapFragment.isJavaHeap(context)) {
                JavaReferencesProvider provider = (JavaReferencesProvider)Lookup.getDefault().lookup(JavaReferencesProvider.class);
                return new JavaReferencesPlugin(context, actions, provider);
            }
            return null;
        }
    }

    public static class JavaReferencesRendererProvider
    extends HeapViewerRenderer.Provider {
        @Override
        public boolean supportsView(HeapContext context, String viewID) {
            return "java_objects_references".equals(viewID);
        }

        @Override
        public void registerRenderers(Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> renderers, HeapContext context) {
            renderers.put(ReferenceNode.class, new ReferenceNodeRenderer(context.getFragment().getHeap()));
        }
    }

    private abstract class ReferredInstanceNode
    extends InstanceNode {
        ReferredInstanceNode(Instance instance) {
            super(instance);
        }

        abstract Instance getReferer();

        @Override
        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            HeapOperations.initializeReferences(heap);
            Instance referer = this.getReferer();
            if (referer == null) {
                return HeapViewerNode.NO_NODES;
            }
            final List references = this.getInstance().getReferences();
            Iterator referencesI = references.iterator();
            while (referencesI.hasNext()) {
                if (referer.equals(JavaReferencesPlugin.this.logicalReferer(((Value)referencesI.next()).getDefiningInstance()))) continue;
                referencesI.remove();
            }
            NodesComputer<Value> computer = new NodesComputer<Value>(references.size(), UIThresholds.MAX_MERGED_OBJECTS){

                @Override
                protected boolean sorts(DataType dataType) {
                    return !DataType.COUNT.equals(dataType);
                }

                @Override
                protected HeapViewerNode createNode(Value object) {
                    return InstanceReferenceNode.incoming(object);
                }

                @Override
                protected ProgressIterator<Value> objectsIterator(int index, Progress progress) {
                    ListIterator iterator = references.listIterator(index);
                    return new ProgressIterator<Value>(iterator, index, false, progress);
                }

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.JavaReferencesPlugin_MoreNodes(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.JavaReferencesPlugin_SamplesContainer(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.JavaReferencesPlugin_NodesContainer(firstNodeIdx, lastNodeIdx);
                }
            };
            return computer.computeNodes(this, heap, viewID, null, dataTypes, sortOrders, progress);
        }

        @Override
        public boolean isLeaf() {
            return this.getReferer() == null;
        }
    }

    private static class ReferenceNodeRenderer
    extends InstanceNodeRenderer {
        private static final ImageIcon ICON = Icons.getImageIcon((String)"ProfilerIcons.NodeForward");

        ReferenceNodeRenderer(Heap heap) {
            super(heap);
        }

        @Override
        public void setValue(Object value, int row) {
            ReferenceNode node;
            if (value != null && (node = (ReferenceNode)((Object)value)).getInstance() == null) {
                this.setNormalValue(Bundle.JavaReferencesPlugin_NoReferences());
                this.setBoldValue("");
                this.setGrayValue("");
                this.setIcon(ICON);
                return;
            }
            super.setValue(value, row);
            this.setIconTextGap(4);
            ((LabelRenderer)this.valueRenderers()[0]).setMargin(3, 3, 3, 0);
        }

        @Override
        protected ImageIcon getIcon(Instance instance, boolean isGCRoot) {
            return ICON;
        }
    }

    private abstract class ReferenceNode
    extends InstanceNode.IncludingNull {
        ReferenceNode(Instance reference) {
            super(reference);
        }

        abstract int getCount();

        abstract InterruptibleIterator<Instance> instancesIterator();

        @Override
        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            HeapOperations.initializeReferences(heap);
            NodesComputer<Instance> computer = new NodesComputer<Instance>(this.getCount(), UIThresholds.MAX_MERGED_OBJECTS){

                @Override
                protected boolean sorts(DataType dataType) {
                    return !DataType.COUNT.equals(dataType);
                }

                @Override
                protected HeapViewerNode createNode(Instance object) {
                    return new ReferredInstanceNode(object){

                        @Override
                        Instance getReferer() {
                            return ReferenceNode.this.getInstance();
                        }
                    };
                }

                @Override
                protected ProgressIterator<Instance> objectsIterator(int index, final Progress _progress) {
                    final Instance _instance = ReferenceNode.this.getInstance();
                    _progress.setupUnknownSteps();
                    ExcludingIterator<Instance> fieldInstanceIterator = new ExcludingIterator<Instance>(ReferenceNode.this.instancesIterator()){

                        @Override
                        protected boolean exclude(Instance instance) {
                            _progress.step();
                            List references = instance.getReferences();
                            if (_instance == null) {
                                return !references.isEmpty();
                            }
                            for (Value reference : references) {
                                if (!_instance.equals(JavaReferencesPlugin.this.logicalReferer(reference.getDefiningInstance()))) continue;
                                return false;
                            }
                            return true;
                        }
                    };
                    return new ProgressIterator<Instance>(fieldInstanceIterator, index, true, _progress);
                }

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.JavaReferencesPlugin_IMoreNodes(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.JavaReferencesPlugin_ISamplesContainer(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.JavaReferencesPlugin_INodesContainer(firstNodeIdx, lastNodeIdx);
                }
            };
            return computer.computeNodes(this, heap, viewID, null, dataTypes, sortOrders, progress);
        }

        @Override
        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.COUNT) {
                return this.getCount();
            }
            return super.getValue(type, heap);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }
}

