/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.oql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.graalvm.visualvm.heapviewer.oql.Bundle;
import org.graalvm.visualvm.heapviewer.oql.CustomOQLQueries;
import org.graalvm.visualvm.heapviewer.oql.OQLConsoleView;
import org.graalvm.visualvm.heapviewer.oql.OQLQueryCustomizer;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.OQLSupport;
import org.graalvm.visualvm.lib.profiler.oql.repository.api.OQLQueryCategory;
import org.graalvm.visualvm.lib.profiler.oql.repository.api.OQLQueryDefinition;
import org.graalvm.visualvm.lib.profiler.oql.repository.api.OQLQueryRepository;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

final class OQLQueries {
    static final Icon ICON_LOAD = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)(OQLConsoleView.class.getPackage().getName().replace('.', '/') + "/loadOQL.png"), (boolean)true));
    static final Icon ICON_SAVE = Icons.getIcon((String)"GeneralIcons.Save");
    private static final Icon ICON_EMPTY = Icons.getIcon((String)"GeneralIcons.Empty");
    private static final int EXTERNAL_QUERIES_CACHE = 5;
    private static OQLQueries INSTANCE;
    private CustomOQLQueries customQueries;
    private List<? extends OQLQueryCategory> predefinedCategories;
    private List<OQLSupport.Query> externalQueries;
    private JPopupMenu tempPopup;
    private OQLSupport.Query tempCurrentQuery;
    private String tempQueryText;
    private Handler tempHandler;
    private boolean tempLoad;
    private File lastDirectory;

    public static synchronized OQLQueries instance() {
        if (INSTANCE == null) {
            INSTANCE = new OQLQueries();
        }
        return INSTANCE;
    }

    public void populateLoadQuery(JPopupMenu popup, OQLSupport.Query currentQuery, final Handler handler) {
        if (this.customQueries == null || this.predefinedCategories == null) {
            JMenuItem progressItem = new JMenuItem(Bundle.OQLQueries_LoadingProgress(), Icons.getIcon((String)"HeapWalkerIcons.Progress"));
            progressItem.setEnabled(false);
            popup.add(progressItem);
            this.tempPopup = popup;
            this.tempCurrentQuery = currentQuery;
            this.tempHandler = handler;
            this.tempLoad = true;
            return;
        }
        this.tempPopup = null;
        this.tempCurrentQuery = null;
        this.tempQueryText = null;
        this.tempHandler = null;
        popup.add(new PopupSeparator(Bundle.OQLQueries_PopupLoadCustomScript()));
        if (this.customQueries.isEmpty()) {
            JMenuItem noItems = new JMenuItem(Bundle.OQLQueries_PopupNoSaved(), ICON_EMPTY);
            noItems.setEnabled(false);
            popup.add(noItems);
        } else {
            for (OQLSupport.Query query : this.customQueries.list()) {
                popup.add(new QueryMenuItem(query, currentQuery, ICON_LOAD, null, handler));
            }
        }
        popup.add(new PopupSpacer(5));
        popup.add(new PopupSeparator(Bundle.OQLQueries_PopupLoadExternalScript()));
        popup.add(new JMenuItem(Bundle.OQLQueries_PopupLoadFromFile(), ICON_EMPTY){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OQLQueries.this.loadFromFile(handler);
                    }
                });
            }
        });
        if (this.externalQueries != null && !this.externalQueries.isEmpty()) {
            popup.add(new PopupSpacer(5));
            for (OQLSupport.Query query : this.externalQueries) {
                popup.add(new QueryMenuItem(query, currentQuery, ICON_LOAD, null, handler));
            }
        }
        if (!this.predefinedCategories.isEmpty()) {
            popup.add(new PopupSpacer(5));
            popup.add(new PopupSeparator(Bundle.OQLQueries_PopupLoadPredefinedScript()));
            for (final OQLQueryCategory oQLQueryCategory : this.predefinedCategories) {
                JMenu categoryMenu = new JMenu(oQLQueryCategory.getName()){

                    @Override
                    protected void fireStateChanged() {
                        boolean active = this.isSelected() || this.isArmed();
                        StatusDisplayer.getDefault().setStatusText(active ? oQLQueryCategory.getDescription() : null);
                        super.fireStateChanged();
                    }
                };
                popup.add(categoryMenu);
                List queries = oQLQueryCategory.listQueries();
                for (OQLQueryDefinition queryDef : queries) {
                    categoryMenu.add(new QueryMenuItem(new OQLSupport.Query(queryDef), currentQuery, ICON_LOAD, categoryMenu, handler));
                }
            }
        }
    }

    public void populateSaveQuery(JPopupMenu popup, final OQLSupport.Query currentQuery, final String queryText, final Handler handler) {
        if (this.customQueries == null) {
            JMenuItem progressItem = new JMenuItem(Bundle.OQLQueries_PopupLoadingScripts(), Icons.getIcon((String)"HeapWalkerIcons.Progress"));
            progressItem.setEnabled(false);
            popup.add(progressItem);
            this.tempPopup = popup;
            this.tempCurrentQuery = currentQuery;
            this.tempQueryText = queryText;
            this.tempHandler = handler;
            this.tempLoad = false;
            return;
        }
        this.tempPopup = null;
        this.tempCurrentQuery = null;
        this.tempQueryText = null;
        this.tempHandler = null;
        popup.add(new PopupSeparator(Bundle.OQLQueries_PopupSaveCustomScript()));
        popup.add(new JMenuItem(Bundle.OQLQueries_PopupSaveNew(), ICON_EMPTY){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                OQLSupport.Query query = OQLQueryCustomizer.saveCustomizer(currentQuery, queryText);
                if (query == null) {
                    return;
                }
                String name = query.getName();
                int nameExt = 0;
                while (OQLQueries.containsQuery(OQLQueries.this.customQueries.list(), query)) {
                    query.setName(name + " " + ++nameExt);
                }
                OQLQueries.this.customQueries.add(query);
                if (handler != null) {
                    handler.querySelected(query);
                }
            }
        });
        if (!this.customQueries.isEmpty()) {
            popup.add(new PopupSpacer(5));
            for (final OQLSupport.Query query : this.customQueries.list()) {
                popup.add(new QueryMenuItem(query, currentQuery, ICON_SAVE, null, handler){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        query.setScript(queryText);
                        OQLQueries.this.customQueries.save(query);
                        super.fireActionPerformed(e);
                    }
                });
            }
        }
        popup.add(new PopupSpacer(5));
        popup.add(new PopupSeparator(Bundle.OQLQueries_PopupSaveExternalScript()));
        popup.add(new JMenuItem(Bundle.OQLQueries_PopupSaveFile(), ICON_EMPTY){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OQLQueries.this.saveToFile(currentQuery, queryText, handler);
                    }
                });
            }
        });
        if (this.externalQueries != null && !this.externalQueries.isEmpty()) {
            popup.add(new PopupSpacer(5));
            for (final OQLSupport.Query query : this.externalQueries) {
                popup.add(new QueryMenuItem(query, currentQuery, ICON_SAVE, null, handler){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        query.setScript(queryText);
                        OQLQueries.this.saveToQuery(query, null);
                        super.fireActionPerformed(e);
                    }
                });
            }
        }
    }

    private void loadAllQueries() {
        new RequestProcessor("OQL Scripts Loader").post(new Runnable(){

            @Override
            public void run() {
                OQLQueries.this.customQueries = CustomOQLQueries.instance();
                OQLQueries.this.predefinedCategories = OQLQueryRepository.getInstance().listCategories();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (OQLQueries.this.tempPopup != null && OQLQueries.this.tempPopup.isShowing()) {
                            JPopupMenu popup = OQLQueries.this.tempPopup;
                            popup.removeAll();
                            if (OQLQueries.this.tempLoad) {
                                OQLQueries.this.populateLoadQuery(popup, OQLQueries.this.tempCurrentQuery, OQLQueries.this.tempHandler);
                            } else {
                                OQLQueries.this.populateSaveQuery(popup, OQLQueries.this.tempCurrentQuery, OQLQueries.this.tempQueryText, OQLQueries.this.tempHandler);
                            }
                            popup.pack();
                        }
                    }
                });
            }
        });
    }

    private void loadFromFile(final Handler handler) {
        JFileChooser chooser = new JFileChooser();
        if (this.lastDirectory != null) {
            chooser.setCurrentDirectory(this.lastDirectory);
        }
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(Bundle.OQLQueries_LoadExternalCaption());
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fname = f.getName().toLowerCase(Locale.ENGLISH);
                return fname.endsWith(".oql") || fname.endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return Bundle.OQLQueries_OQLFileFilter("*.oql, *.txt");
            }
        });
        if (chooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            final File file = chooser.getSelectedFile();
            this.lastDirectory = file.getParentFile();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!file.isFile() || !file.canRead()) {
                            ProfilerDialogs.displayError((String)Bundle.OQLQueries_InvalidScript());
                            return;
                        }
                        String script = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                        String name = file.getName();
                        String description = file.getAbsolutePath();
                        final OQLSupport.Query query = new OQLSupport.Query(script, name, description);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                handler.querySelected(query);
                                if (OQLQueries.this.externalQueries == null) {
                                    OQLQueries.this.externalQueries = new ArrayList(5);
                                }
                                if (OQLQueries.containsQuery(OQLQueries.this.externalQueries, query)) {
                                    return;
                                }
                                if (OQLQueries.this.externalQueries.size() == 5) {
                                    OQLQueries.this.externalQueries.remove(OQLQueries.this.externalQueries.size() - 1);
                                }
                                OQLQueries.this.externalQueries.add(0, query);
                            }
                        });
                    }
                    catch (IOException ex) {
                        ProfilerDialogs.displayError((String)Bundle.OQLQueries_LoadFailed());
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }

    private void saveToFile(OQLSupport.Query query, String queryText, Handler handler) {
        String descr;
        File defaultFile;
        JFileChooser chooser = new JFileChooser();
        if (query == null) {
            String name = "query.oql";
            String descr2 = this.lastDirectory == null ? null : new File(this.lastDirectory, name).getPath();
            query = new OQLSupport.Query(queryText, name, descr2);
        }
        File file = defaultFile = (descr = query.getDescription()) == null ? null : new File(descr);
        if (defaultFile != null && defaultFile.isFile()) {
            chooser.setSelectedFile(defaultFile);
        } else {
            defaultFile = this.lastDirectory == null ? new File(query.getName()) : new File(this.lastDirectory, query.getName());
            if (this.lastDirectory != null) {
                chooser.setCurrentDirectory(this.lastDirectory);
            }
            chooser.setSelectedFile(defaultFile);
        }
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(Bundle.OQLQueries_SaveExternalCaption());
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fname = f.getName().toLowerCase(Locale.ENGLISH);
                return fname.endsWith(".oql") || fname.endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return Bundle.OQLQueries_OQLFileFilter("*.oql, *.txt");
            }
        });
        if (chooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            File file2 = chooser.getSelectedFile();
            this.lastDirectory = file2.getParentFile();
            String fname = file2.getName().toLowerCase(Locale.ENGLISH);
            if (!fname.endsWith(".oql") && !fname.endsWith(".txt")) {
                file2 = new File(file2.getParentFile(), file2.getName() + ".oql");
            }
            String script = query.getScript();
            String name = file2.getName();
            String description = file2.getAbsolutePath();
            this.saveToQuery(new OQLSupport.Query(script, name, description), handler);
        }
    }

    private void saveToQuery(final OQLSupport.Query query, final Handler handler) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(query.getDescription());
                    if (file.isFile() && !file.canWrite()) {
                        ProfilerDialogs.displayError((String)Bundle.OQLQueries_InvalidScript());
                        return;
                    }
                    Files.write(file.toPath(), query.getScript().getBytes(), new OpenOption[0]);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (handler != null) {
                                handler.querySelected(query);
                            }
                            if (OQLQueries.this.externalQueries == null) {
                                OQLQueries.this.externalQueries = new ArrayList(5);
                            }
                            if (OQLQueries.containsQuery(OQLQueries.this.externalQueries, query)) {
                                return;
                            }
                            if (OQLQueries.this.externalQueries.size() == 5) {
                                OQLQueries.this.externalQueries.remove(OQLQueries.this.externalQueries.size() - 1);
                            }
                            OQLQueries.this.externalQueries.add(0, query);
                        }
                    });
                }
                catch (IOException ex) {
                    ProfilerDialogs.displayError((String)Bundle.OQLQueries_SaveFailed());
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private static boolean sameQuery(OQLSupport.Query query1, OQLSupport.Query query2) {
        if (query1 == null || query2 == null) {
            return false;
        }
        return query1.getName().equals(query2.getName());
    }

    private static boolean containsQuery(List<OQLSupport.Query> queries, OQLSupport.Query query) {
        for (OQLSupport.Query q : queries) {
            if (!OQLQueries.sameQuery(q, query)) continue;
            return true;
        }
        return false;
    }

    private OQLQueries() {
        this.loadAllQueries();
    }

    private static class QueryMenuItem
    extends JMenuItem {
        private final OQLSupport.Query query;
        private final Icon icon;
        private final Handler handler;

        QueryMenuItem(OQLSupport.Query query, OQLSupport.Query current, Icon icon, JMenu owner, Handler handler) {
            super(QueryMenuItem.getName(query, current, owner), ICON_EMPTY);
            this.query = query;
            this.icon = icon;
            this.handler = handler;
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            super.fireActionPerformed(e);
            if (this.handler != null) {
                this.handler.querySelected(this.query);
            }
        }

        @Override
        protected void fireStateChanged() {
            boolean active = this.isSelected() || this.isArmed();
            this.setIcon(active ? this.icon : ICON_EMPTY);
            StatusDisplayer.getDefault().setStatusText(active ? this.query.getDescription() : null);
            super.fireStateChanged();
        }

        private static String getName(OQLSupport.Query query, OQLSupport.Query current, JMenu owner) {
            String name = query.getName();
            if (OQLQueries.sameQuery(query, current)) {
                name = "<html><b>" + name + "</b>&nbsp;<span style='color: gray;'>" + Bundle.OQLQueries_CurrentScriptFlag() + "</span></html>";
                if (owner != null) {
                    owner.setText("<html><b>" + owner.getText() + "</b></html>");
                }
            }
            return name;
        }
    }

    private static class PopupSeparator
    extends JPanel {
        public PopupSeparator(String text) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            JLabel l = new JLabel(text);
            l.setBorder(BorderFactory.createEmptyBorder(5, 5, 3, 3));
            if (UIUtils.isWindowsLookAndFeel()) {
                l.setOpaque(true);
            }
            l.setFont(l.getFont().deriveFont(1, l.getFont().getSize2D() - 1.0f));
            if (UIUtils.isWindowsLookAndFeel()) {
                l.setForeground(UIUtils.getDisabledLineColor());
            }
            this.add((Component)l, "West");
            if (UIUtils.isGTKLookAndFeel()) {
                this.add((Component)UIUtils.createHorizontalSeparator(), "Center");
            } else {
                JPopupMenu.Separator sep = new JPopupMenu.Separator();
                this.add((Component)sep, "Center");
                if (UIUtils.isOracleLookAndFeel()) {
                    this.setOpaque(true);
                    this.setBackground(sep.getBackground());
                    l.setForeground(sep.getForeground());
                }
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Component c = this.getComponent(1);
            int h = c.getPreferredSize().height;
            Rectangle b = c.getBounds();
            b.y = (b.height - h) / 2 + 1;
            b.height = h;
            c.setBounds(b);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = this.getComponent(0).getPreferredSize();
            d.width += 75;
            return d;
        }
    }

    private static class PopupSpacer
    extends JPanel {
        private final int size;

        PopupSpacer(int size) {
            this.size = size;
            this.setOpaque(false);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, this.size);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }

    static class Handler {
        Handler() {
        }

        protected void querySelected(OQLSupport.Query query) {
        }
    }
}

