/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.ui;

import java.awt.BorderLayout;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;

public abstract class HeapViewPlugin
extends HeapView {
    private boolean showing;
    private boolean updatePending;
    private HeapViewerNode pendingNode;
    private boolean pendingAdjusting;
    private JComponent component;

    public HeapViewPlugin(String name, String description, Icon icon) {
        super(name, description, icon);
    }

    protected boolean acceptsAdjustingSelection() {
        return false;
    }

    protected abstract JComponent createComponent();

    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
    }

    @Override
    public final JComponent getComponent() {
        if (this.component == null) {
            this.component = new JPanel(new BorderLayout());
            this.component.setOpaque(false);
            this.component.add(this.createComponent());
            this.component.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L) {
                        HeapViewPlugin.this.showing = HeapViewPlugin.this.component.isShowing();
                        if (HeapViewPlugin.this.showing && HeapViewPlugin.this.updatePending) {
                            HeapViewPlugin.this.doNodeSelectedImpl(HeapViewPlugin.this.pendingNode, HeapViewPlugin.this.pendingAdjusting);
                        }
                    }
                }
            });
        }
        return this.component;
    }

    @Override
    public final ProfilerToolbar getToolbar() {
        return null;
    }

    void doNodeSelected(HeapViewerNode node, boolean adjusting) {
        if (this.showing) {
            this.doNodeSelectedImpl(node, adjusting);
        } else {
            this.updatePending = true;
            this.pendingNode = node;
            this.pendingAdjusting = adjusting;
        }
    }

    private void doNodeSelectedImpl(HeapViewerNode node, boolean adjusting) {
        this.updatePending = false;
        this.pendingNode = null;
        if (!adjusting || this.acceptsAdjustingSelection()) {
            this.nodeSelected(node, adjusting);
        }
    }

    public static abstract class Provider {
        public abstract HeapViewPlugin createPlugin(HeapContext var1, HeapViewerActions var2, String var3);
    }
}

