/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.coverage.impl;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.coverage.CoverageTracker;
import com.oracle.truffle.tools.coverage.impl.CoverageCLI;
import com.oracle.truffle.tools.coverage.impl.CoverageInstrumentOptionDescriptors;
import com.oracle.truffle.tools.coverage.impl.JSONPrinter;
import com.oracle.truffle.tools.coverage.impl.LCOVPrinter;
import com.oracle.truffle.tools.coverage.impl.WildcardHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.function.Function;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;

@TruffleInstrument.Registration(id="coverage", name="Code Coverage", version="0.1.0", services={CoverageTracker.class})
public class CoverageInstrument
extends TruffleInstrument {
    public static final String ID = "coverage";
    static final String VERSION = "0.1.0";
    static final OptionType<Output> CLI_OUTPUT_TYPE = new OptionType("Output", (Function)new Function<String, Output>(){

        @Override
        public Output apply(String s) {
            try {
                return Output.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                StringBuilder message = new StringBuilder("Output can be one of: ");
                for (Output output : Output.values()) {
                    message.append(output.toString().toLowerCase());
                    message.append(" ");
                }
                throw new IllegalArgumentException(message.toString());
            }
        }
    });
    @Option(name="", help="Enable Coverage (default: false).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> ENABLED = new OptionKey((Object)false);
    @Option(help="Keep count of each element's coverage (default: false).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> Count = new OptionKey((Object)false);
    @Option(name="Output", help="Can be: human readable 'histogram' (per file coverage summary) or 'detailed' (per line coverage summary), machine readable 'json', tool compliant 'lcov'. (default: histogram)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Output> OUTPUT = new OptionKey((Object)Output.HISTOGRAM, CLI_OUTPUT_TYPE);
    @Option(name="FilterRootName", help="Wildcard filter for program roots. (eg. Math.*, default:*).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Object[]> FILTER_ROOT = new OptionKey((Object)new Object[0], WildcardHandler.WILDCARD_FILTER_TYPE);
    @Option(name="FilterFile", help="Wildcard filter for source file paths. (eg. *program*.sl, default:*).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Object[]> FILTER_FILE = new OptionKey((Object)new Object[0], WildcardHandler.WILDCARD_FILTER_TYPE);
    @Option(name="FilterMimeType", help="Only track languages with mime-type. (eg. +, default:no filter).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> FILTER_MIME_TYPE = new OptionKey((Object)"");
    @Option(name="FilterLanguage", help="Only track languages with given ID. (eg. js, default:no filter).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> FILTER_LANGUAGE = new OptionKey((Object)"");
    @Option(name="TrackInternal", help="Track internal elements (default:false).", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TRACK_INTERNAL = new OptionKey((Object)false);
    @Option(name="OutputFile", help="Save output to the given file. Output is printed to standard output stream by default.", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> OUTPUT_FILE = new OptionKey((Object)"");
    @Option(help="Consider a source code line covered only if covered in it's entirety. (default: true)", category=OptionCategory.USER, stability=OptionStability.EXPERIMENTAL)
    static final OptionKey<Boolean> StrictLines = new OptionKey((Object)true);
    private static Function<TruffleInstrument.Env, CoverageTracker> factory;
    private CoverageTracker tracker;
    private Boolean enabled;

    public static CoverageTracker getTracker(Engine engine) {
        Instrument instrument = (Instrument)engine.getInstruments().get(ID);
        if (instrument == null) {
            throw new IllegalStateException("Tracker is not installed.");
        }
        return (CoverageTracker)instrument.lookup(CoverageTracker.class);
    }

    public static void setFactory(Function<TruffleInstrument.Env, CoverageTracker> factory) {
        if (factory == null || !factory.getClass().getName().startsWith("com.oracle.truffle.tools.coverage")) {
            throw new IllegalArgumentException("Wrong factory: " + factory);
        }
        CoverageInstrument.factory = factory;
    }

    private static PrintStream chooseOutputStream(TruffleInstrument.Env env, OptionKey<String> option) {
        try {
            if (option.hasBeenSet(env.getOptions())) {
                String outputPath = (String)option.getValue(env.getOptions());
                File file = new File(outputPath);
                if (file.exists()) {
                    throw new IllegalArgumentException("Cannot redirect output to an existing file!");
                }
                return new PrintStream(new FileOutputStream(file));
            }
            return new PrintStream(env.out());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Cannot redirect output to a directory");
        }
    }

    private static SourceSectionFilter getSourceSectionFilter(OptionValues options) {
        Object[] filterFile = (Object[])FILTER_FILE.getValue(options);
        String filterMimeType = (String)FILTER_MIME_TYPE.getValue(options);
        String filterLanguage = (String)FILTER_LANGUAGE.getValue(options);
        Boolean internals = (Boolean)TRACK_INTERNAL.getValue(options);
        SourceSectionFilter.Builder builder = SourceSectionFilter.newBuilder();
        builder.sourceIs(source -> {
            boolean internal = internals != false || !source.isInternal();
            boolean file = WildcardHandler.testWildcardExpressions(source.getPath(), filterFile);
            boolean mimeType = filterMimeType.equals("") || filterMimeType.equals(source.getMimeType());
            boolean languageId = filterLanguage.equals("") || filterMimeType.equals(source.getLanguage());
            return internal && file && mimeType && languageId;
        });
        Object[] filterRootName = (Object[])FILTER_ROOT.getValue(options);
        builder.rootNameIs(s -> WildcardHandler.testWildcardExpressions(s, filterRootName));
        return builder.build();
    }

    protected void onCreate(TruffleInstrument.Env env) {
        this.tracker = factory.apply(env);
        env.registerService((Object)this.tracker);
        OptionValues options = env.getOptions();
        this.enabled = (Boolean)ENABLED.getValue(options);
        if (this.enabled.booleanValue()) {
            this.tracker.start(new CoverageTracker.Config(CoverageInstrument.getSourceSectionFilter(options), (Boolean)Count.getValue(options)));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onDispose(TruffleInstrument.Env env) {
        if (this.enabled.booleanValue()) {
            coverage = this.tracker.getCoverage();
            options = env.getOptions();
            strictLines = (Boolean)CoverageInstrument.StrictLines.getValue(options);
            out = CoverageInstrument.chooseOutputStream(env, CoverageInstrument.OUTPUT_FILE);
            var6_6 = null;
            try {
                switch (2.$SwitchMap$com$oracle$truffle$tools$coverage$impl$CoverageInstrument$Output[((Output)CoverageInstrument.OUTPUT.getValue(options)).ordinal()]) {
                    case 1: {
                        new CoverageCLI(out, coverage, strictLines).printHistogramOutput();
                        ** break;
lbl12:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        new CoverageCLI(out, coverage, strictLines).printLinesOutput();
                        ** break;
lbl16:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        new JSONPrinter(out, coverage).print();
                        ** break;
lbl20:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        new LCOVPrinter(out, coverage, strictLines).print();
                        break;
                    }
                    ** default:
lbl25:
                    // 1 sources

                    break;
                }
            }
            catch (Throwable var7_8) {
                var6_6 = var7_8;
                throw var7_8;
            }
            finally {
                if (out != null) {
                    if (var6_6 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable var7_7) {
                            var6_6.addSuppressed(var7_7);
                        }
                    } else {
                        out.close();
                    }
                }
            }
            this.tracker.close();
        }
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new CoverageInstrumentOptionDescriptors();
    }

    static {
        try {
            Class.forName(CoverageTracker.class.getName(), true, CoverageTracker.class.getClassLoader());
        }
        catch (ClassNotFoundException cannotHappen) {
            throw new AssertionError();
        }
    }

    static enum Output {
        HISTOGRAM,
        DETAILED,
        JSON,
        LCOV;

    }
}

