/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.coverage.impl;

import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.coverage.RootCoverage;
import com.oracle.truffle.tools.coverage.SectionCoverage;
import com.oracle.truffle.tools.coverage.SourceCoverage;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.PrintStream;

final class JSONPrinter {
    private final PrintStream out;
    private final SourceCoverage[] sourceCoverages;

    JSONPrinter(PrintStream out, SourceCoverage[] sourceCoverages) {
        this.out = out;
        this.sourceCoverages = sourceCoverages;
    }

    private static JSONObject sourceSectionJson(SourceSection section) {
        JSONObject sourceSection = new JSONObject();
        sourceSection.put("characters", section.getCharacters());
        sourceSection.put("start_line", section.getStartLine());
        sourceSection.put("end_line", section.getEndLine());
        sourceSection.put("start_column", section.getStartColumn());
        sourceSection.put("end_column", section.getEndColumn());
        sourceSection.put("char_index", section.getCharIndex());
        sourceSection.put("char_end_index", section.getCharEndIndex());
        sourceSection.put("char_length", section.getCharLength());
        return sourceSection;
    }

    private static JSONObject sourceJSON(SourceCoverage coverage) {
        JSONObject sourceJson = new JSONObject();
        sourceJson.put("path", coverage.getSource().getPath());
        sourceJson.put("roots", JSONPrinter.rootsJson(coverage.getRoots()));
        return sourceJson;
    }

    private static JSONArray rootsJson(RootCoverage[] coverages) {
        JSONArray rootsJson = new JSONArray();
        for (RootCoverage coverage : coverages) {
            rootsJson.put(JSONPrinter.rootJSON(coverage));
        }
        return rootsJson;
    }

    private static JSONObject rootJSON(RootCoverage coverage) {
        JSONObject rootJson = new JSONObject();
        rootJson.put("covered", coverage.isCovered());
        rootJson.put("source_section", JSONPrinter.sourceSectionJson(coverage.getSourceSection()));
        rootJson.put("name", coverage.getName());
        rootJson.put("sections", JSONPrinter.sectionsJson(coverage.getSectionCoverage()));
        if (coverage.getCount() != -1L) {
            rootJson.put("count", coverage.getCount());
        }
        return rootJson;
    }

    private static JSONArray sectionsJson(SectionCoverage[] coverages) {
        JSONArray sectionsJSON = new JSONArray();
        for (SectionCoverage coverage : coverages) {
            sectionsJSON.put(JSONPrinter.sectionJson(coverage));
        }
        return sectionsJSON;
    }

    private static JSONObject sectionJson(SectionCoverage coverage) {
        JSONObject sectionJson = new JSONObject();
        sectionJson.put("covered", coverage.isCovered());
        if (coverage.getCount() != -1L) {
            sectionJson.put("count", coverage.getCount());
        }
        sectionJson.put("source_section", JSONPrinter.sourceSectionJson(coverage.getSourceSection()));
        return sectionJson;
    }

    void print() {
        JSONArray output = new JSONArray();
        for (SourceCoverage sourceCoverage : this.sourceCoverages) {
            output.put(JSONPrinter.sourceJSON(sourceCoverage));
        }
        this.out.println(output.toString());
    }
}

