/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.ValueKind;

public final class StackSlot
extends AllocatableValue {
    private final int offset;
    private final boolean addFrameSize;

    public static StackSlot get(ValueKind<?> kind, int offset, boolean addFrameSize) {
        assert (addFrameSize || offset >= 0);
        return new StackSlot(kind, offset, addFrameSize);
    }

    private StackSlot(ValueKind<?> kind, int offset, boolean addFrameSize) {
        super(kind);
        this.offset = offset;
        this.addFrameSize = addFrameSize;
    }

    public int getOffset(int totalFrameSize) {
        assert (totalFrameSize > 0 || !this.addFrameSize);
        int result = this.offset + (this.addFrameSize ? totalFrameSize : 0);
        assert (result >= 0);
        return result;
    }

    public boolean isInCallerFrame() {
        return this.addFrameSize && this.offset >= 0;
    }

    public int getRawOffset() {
        return this.offset;
    }

    public boolean getRawAddFrameSize() {
        return this.addFrameSize;
    }

    public String toString() {
        if (!this.addFrameSize) {
            return "out:" + this.offset + this.getKindSuffix();
        }
        if (this.offset >= 0) {
            return "in:" + this.offset + this.getKindSuffix();
        }
        return "stack:" + -this.offset + this.getKindSuffix();
    }

    public StackSlot asOutArg() {
        assert (this.offset >= 0);
        if (this.addFrameSize) {
            return StackSlot.get(this.getValueKind(), this.offset, false);
        }
        return this;
    }

    public StackSlot asInArg() {
        assert (this.offset >= 0);
        if (!this.addFrameSize) {
            return StackSlot.get(this.getValueKind(), this.offset, true);
        }
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 37;
        int result = super.hashCode();
        result = 37 * result + (this.addFrameSize ? 1231 : 1237);
        result = 37 * result + this.offset;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StackSlot) {
            StackSlot other = (StackSlot)obj;
            return super.equals(obj) && this.addFrameSize == other.addFrameSize && this.offset == other.offset;
        }
        return false;
    }
}

