/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaUtil;

public class TargetDescription {
    public final Architecture arch;
    public final boolean isMP;
    public final boolean inlineObjects;
    public final int wordSize;
    public final JavaKind wordJavaKind;
    public final int stackAlignment;
    public final int implicitNullCheckLimit;

    public TargetDescription(Architecture arch, boolean isMP, int stackAlignment, int implicitNullCheckLimit, boolean inlineObjects) {
        this.arch = arch;
        this.isMP = isMP;
        this.wordSize = arch.getWordSize();
        this.wordJavaKind = JavaKind.fromWordSize(this.wordSize);
        this.stackAlignment = stackAlignment;
        this.implicitNullCheckLimit = implicitNullCheckLimit;
        this.inlineObjects = inlineObjects;
        assert (arch.getPlatformKind(this.wordJavaKind).equals(arch.getWordKind()));
    }

    public final int hashCode() {
        throw new UnsupportedOperationException();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TargetDescription) {
            TargetDescription that = (TargetDescription)obj;
            if (this.implicitNullCheckLimit == that.implicitNullCheckLimit && this.inlineObjects == that.inlineObjects && this.isMP == that.isMP && this.stackAlignment == that.stackAlignment && this.wordJavaKind.equals((Object)that.wordJavaKind) && this.wordSize == that.wordSize && this.arch.equals(that.arch)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return MetaUtil.identityHashCodeString(this);
    }
}

