/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.SuppressFBWarnings;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class VirtualObject
implements JavaValue {
    private final ResolvedJavaType type;
    private JavaValue baseObject;
    private JavaValue[] values;
    private JavaKind[] slotKinds;
    private final int id;
    private final boolean isAutoBox;
    @NativeImageReinitialize
    private static boolean boxCachesInitialized;

    public static VirtualObject get(ResolvedJavaType type, int id) {
        return new VirtualObject(type, null, id, false);
    }

    public static VirtualObject get(ResolvedJavaType type, int id, boolean isAutoBox) {
        return new VirtualObject(type, null, id, isAutoBox);
    }

    public static VirtualObject get(ResolvedJavaType type, JavaValue baseObject, int id, boolean isAutoBox) {
        return new VirtualObject(type, baseObject, id, isAutoBox);
    }

    private VirtualObject(ResolvedJavaType type, JavaValue baseObject, int id, boolean isAutoBox) {
        this.type = type;
        this.baseObject = baseObject;
        this.id = id;
        this.isAutoBox = isAutoBox;
        if (isAutoBox && !boxCachesInitialized) {
            Boolean.valueOf(false);
            Short.valueOf((short)0);
            Character.valueOf('\u0000');
            Integer.valueOf(0);
            Long.valueOf(0L);
            boxCachesInitialized = true;
        }
    }

    private static StringBuilder appendValue(StringBuilder buf, JavaValue value, Set<VirtualObject> visited) {
        if (value instanceof VirtualObject) {
            VirtualObject vo = (VirtualObject)value;
            buf.append("vobject:").append(vo.type.toJavaName(false)).append(':').append(vo.id);
            if (!visited.contains(vo)) {
                visited.add(vo);
                if (vo.isAutoBox) {
                    buf.append("[auto_box]");
                }
                buf.append('{');
                if (vo.values == null) {
                    buf.append("<uninitialized>");
                } else if (vo.type.isArray()) {
                    for (int i = 0; i < vo.values.length; ++i) {
                        if (i != 0) {
                            buf.append(',');
                        }
                        buf.append(i).append('=');
                        VirtualObject.appendValue(buf, vo.values[i], visited);
                    }
                } else {
                    ResolvedJavaField[] fields = vo.type.getInstanceFields(true);
                    int fieldIndex = 0;
                    int i = 0;
                    while (i < vo.values.length) {
                        if (i != 0) {
                            buf.append(',');
                        }
                        if (fieldIndex >= fields.length) {
                            buf.append("<missing field>");
                        } else {
                            ResolvedJavaField field = fields[fieldIndex];
                            buf.append(field.getName());
                            if (vo.slotKinds[i].getSlotCount() == 2 && field.getType().getJavaKind().getSlotCount() == 1) {
                                if (fieldIndex + 1 >= fields.length) {
                                    buf.append("/<missing field>");
                                } else {
                                    ResolvedJavaField field2 = fields[++fieldIndex];
                                    buf.append('/').append(field2.getName());
                                }
                            }
                        }
                        buf.append('=');
                        VirtualObject.appendValue(buf, vo.values[i], visited);
                        ++i;
                        ++fieldIndex;
                    }
                    while (fieldIndex < fields.length) {
                        buf.append(fields[fieldIndex].getName()).append("=<missing value>");
                        ++fieldIndex;
                    }
                }
                buf.append('}');
            }
        } else {
            buf.append(value);
        }
        return buf;
    }

    public void verifyLayout(LayoutVerifier verifier) {
        if (!this.type.isArray()) {
            ResolvedJavaField[] fields = this.type.getInstanceFields(true);
            int fieldIndex = 0;
            int i = 0;
            while (i < this.values.length) {
                JavaKind slotKind = this.slotKinds[i];
                if (fieldIndex >= fields.length) {
                    throw new JVMCIError("Not enough fields for the values provided for %s", this.toString());
                }
                ResolvedJavaField field = fields[fieldIndex];
                JavaKind fieldKind = verifier.getStorageKind(field);
                if (slotKind.getSlotCount() == 2 && fieldKind == JavaKind.Int) {
                    int offset = verifier.getOffset(field);
                    if (offset % 8 != 0) {
                        throw new JVMCIError("Double word value stored across two ints must be aligned %s (unaligned offset: %d)", this.toString(), offset);
                    }
                    if (fieldIndex + 1 >= fields.length) {
                        throw new JVMCIError("Missing second field for double word value stored in two ints %s", this.toString());
                    }
                    ResolvedJavaField field2 = fields[fieldIndex + 1];
                    if (field2.getType().getJavaKind() != JavaKind.Int) {
                        throw new JVMCIError("Second field for double word value stored in two ints must be int but got %s in %s", new Object[]{field2.getType().getJavaKind(), this.toString()});
                    }
                    int offset2 = verifier.getOffset(field2);
                    if (offset + 4 != offset2) {
                        throw new JVMCIError("Double word value stored across two ints must be sequential %s", this.toString());
                    }
                    ++fieldIndex;
                } else if (fieldKind.getStackKind() != slotKind.getStackKind()) {
                    throw new JVMCIError("Expected value of kind %s but got %s for field %s in %s", new Object[]{fieldKind, slotKind, field, this.toString()});
                }
                ++i;
                ++fieldIndex;
            }
            if (fieldIndex < fields.length) {
                throw new JVMCIError("Not enough values provided for fields in %s", this);
            }
        } else if (this.type.getComponentType().getJavaKind() == JavaKind.Byte) {
            int i = 0;
            while (i < this.values.length) {
                JavaKind slotkind = this.slotKinds[i];
                if (slotkind != JavaKind.Byte) {
                    if (!slotkind.isPrimitive()) {
                        throw new JVMCIError("Storing a non-primitive in a byte array %s", this.toString());
                    }
                    int byteCount = 1;
                    while (++i < this.values.length && this.slotKinds[i] == JavaKind.Illegal) {
                        ++byteCount;
                    }
                    if (!CodeUtil.isPowerOf2(byteCount) || slotkind.getStackKind() != JavaKind.Int && byteCount != slotkind.getByteCount() || byteCount > JavaKind.Long.getByteCount()) {
                        throw new JVMCIError("Invalid number of illegals to reconstruct a byte array: %s in %s", byteCount, this.toString());
                    }
                    i += byteCount;
                    continue;
                }
                ++i;
            }
        }
    }

    public String toString() {
        Set<VirtualObject> visited = Collections.newSetFromMap(new IdentityHashMap());
        return VirtualObject.appendValue(new StringBuilder(), this, visited).toString();
    }

    public ResolvedJavaType getType() {
        return this.type;
    }

    public JavaValue getBaseObject() {
        return this.baseObject;
    }

    public void setBaseObject(JavaValue baseObject) {
        this.baseObject = baseObject;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="`values` is intentional mutable")
    public JavaValue[] getValues() {
        return this.values;
    }

    public JavaKind getSlotKind(int index) {
        return this.slotKinds[index];
    }

    public int getId() {
        return this.id;
    }

    public boolean isAutoBox() {
        return this.isAutoBox;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="caller transfers ownership of `slotKinds`")
    public void setValues(JavaValue[] values, JavaKind[] slotKinds) {
        assert (values.length == slotKinds.length);
        this.values = values;
        this.slotKinds = slotKinds;
    }

    public int hashCode() {
        return 42 + this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VirtualObject) {
            VirtualObject l = (VirtualObject)o;
            if (!l.type.equals(this.type) || l.values.length != this.values.length) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (VirtualObject.same(this.values[i], l.values[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean same(Object o1, Object o2) {
        return o1 == o2;
    }

    public static interface LayoutVerifier {
        public int getOffset(ResolvedJavaField var1);

        default public JavaKind getStorageKind(ResolvedJavaField field) {
            return field.getType().getJavaKind();
        }
    }
}

