/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.common;

import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.common.SuppressFBWarnings;
import jdk.vm.ci.services.Services;

public final class InitTimer
implements AutoCloseable {
    private final String name;
    private final long start;
    @NativeImageReinitialize
    private static Boolean enabledPropertyValue;
    private static AtomicInteger nesting;
    private static final String SPACES = "                                            ";
    static Thread initializingThread;

    private InitTimer(String name) {
        int n = nesting.getAndIncrement();
        if (n == 0) {
            initializingThread = Thread.currentThread();
            System.out.println("INITIALIZING THREAD: " + initializingThread);
        } else assert (Thread.currentThread() == initializingThread) : Thread.currentThread() + " != " + initializingThread;
        this.name = name;
        this.start = System.currentTimeMillis();
        System.out.println("START: " + SPACES.substring(0, n * 2) + name);
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="only the initializing thread accesses this field")
    public void close() {
        long end = System.currentTimeMillis();
        int n = nesting.decrementAndGet();
        System.out.println(" DONE: " + SPACES.substring(0, n * 2) + this.name + " [" + (end - this.start) + " ms]");
        if (n == 0) {
            initializingThread = null;
        }
    }

    public static InitTimer timer(String name) {
        return InitTimer.isEnabled() ? new InitTimer(name) : null;
    }

    public static InitTimer timer(String name, Object suffix) {
        return InitTimer.isEnabled() ? new InitTimer(name + suffix) : null;
    }

    private static boolean isEnabled() {
        if (enabledPropertyValue == null) {
            enabledPropertyValue = Boolean.parseBoolean(Services.getSavedProperty((String)"jvmci.InitTimer"));
            nesting = new AtomicInteger();
        }
        return enabledPropertyValue;
    }
}

