/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

public abstract class AbstractProfiledItem<T>
implements Comparable<AbstractProfiledItem<?>> {
    protected final T item;
    protected final double probability;

    public AbstractProfiledItem(T item, double probability) {
        assert (item != null);
        assert (probability >= 0.0 && probability <= 1.0);
        this.item = item;
        this.probability = probability;
    }

    protected T getItem() {
        return this.item;
    }

    public double getProbability() {
        return this.probability;
    }

    @Override
    public int compareTo(AbstractProfiledItem<?> o) {
        return Double.compare(o.getProbability(), this.getProbability());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.probability);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.item.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProfiledItem other = (AbstractProfiledItem)obj;
        if (Double.doubleToLongBits(this.probability) != Double.doubleToLongBits(other.probability)) {
            return false;
        }
        return this.item.equals(other.item);
    }

    public abstract String toString();
}

