/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import java.util.Arrays;
import java.util.function.Supplier;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;

public class EncodedSpeculationReason
implements SpeculationLog.SpeculationReason {
    final int groupId;
    final String groupName;
    final Object[] context;
    private SpeculationLog.SpeculationReasonEncoding encoding;

    public EncodedSpeculationReason(int groupId, String groupName, Object[] context) {
        this.groupId = groupId;
        this.groupName = groupName;
        this.context = context;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EncodedSpeculationReason) {
            if (obj instanceof EncodedSpeculationReason) {
                EncodedSpeculationReason that = (EncodedSpeculationReason)obj;
                return this.groupId == that.groupId && Arrays.equals(this.context, that.context);
            }
            return false;
        }
        return false;
    }

    @Override
    public SpeculationLog.SpeculationReasonEncoding encode(Supplier<SpeculationLog.SpeculationReasonEncoding> encodingSupplier) {
        if (this.encoding == null) {
            this.encoding = encodingSupplier.get();
            this.encoding.addInt(this.groupId);
            for (Object o : this.context) {
                if (o == null) {
                    this.encoding.addInt(0);
                    continue;
                }
                EncodedSpeculationReason.addNonNullObject(this.encoding, o);
            }
        }
        return this.encoding;
    }

    static void addNonNullObject(SpeculationLog.SpeculationReasonEncoding encoding, Object o) {
        Class<?> c = o.getClass();
        if (c == String.class) {
            encoding.addString((String)o);
        } else if (c == Byte.class) {
            encoding.addByte(((Byte)o).byteValue());
        } else if (c == Short.class) {
            encoding.addShort(((Short)o).shortValue());
        } else if (c == Character.class) {
            encoding.addShort(((Character)o).charValue());
        } else if (c == Integer.class) {
            encoding.addInt((Integer)o);
        } else if (c == Long.class) {
            encoding.addLong((Long)o);
        } else if (c == Float.class) {
            encoding.addInt(Float.floatToRawIntBits(((Float)o).floatValue()));
        } else if (c == Double.class) {
            encoding.addLong(Double.doubleToRawLongBits((Double)o));
        } else if (o instanceof Enum) {
            encoding.addInt(((Enum)o).ordinal());
        } else if (o instanceof ResolvedJavaMethod) {
            encoding.addMethod((ResolvedJavaMethod)o);
        } else if (o instanceof ResolvedJavaType) {
            encoding.addType((ResolvedJavaType)o);
        } else if (o instanceof ResolvedJavaField) {
            encoding.addField((ResolvedJavaField)o);
        } else {
            throw new IllegalArgumentException("Unsupported type for encoding: " + c.getName());
        }
    }

    public int hashCode() {
        return this.groupId + Arrays.hashCode(this.context);
    }

    public String toString() {
        return String.format("%s@%d%s", this.groupName, this.groupId, Arrays.toString(this.context));
    }
}

