/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.NullConstant;
import jdk.vm.ci.meta.PrimitiveConstant;

public interface JavaConstant
extends Constant,
JavaValue {
    public static final JavaConstant NULL_POINTER;
    public static final PrimitiveConstant INT_MINUS_1;
    public static final PrimitiveConstant INT_0;
    public static final PrimitiveConstant INT_1;
    public static final PrimitiveConstant INT_2;
    public static final PrimitiveConstant LONG_0;
    public static final PrimitiveConstant LONG_1;
    public static final PrimitiveConstant FLOAT_0;
    public static final PrimitiveConstant FLOAT_1;
    public static final PrimitiveConstant DOUBLE_0;
    public static final PrimitiveConstant DOUBLE_1;
    public static final PrimitiveConstant TRUE;
    public static final PrimitiveConstant FALSE;

    public JavaKind getJavaKind();

    public boolean isNull();

    public static boolean isNull(Constant c) {
        if (c instanceof JavaConstant) {
            return ((JavaConstant)c).isNull();
        }
        return false;
    }

    default public boolean isNonNull() {
        return !this.isNull();
    }

    @Override
    public boolean isDefaultForKind();

    public Object asBoxedPrimitive();

    public int asInt();

    public boolean asBoolean();

    public long asLong();

    public float asFloat();

    public double asDouble();

    @Override
    default public String toValueString() {
        if (this.getJavaKind() == JavaKind.Illegal) {
            return "illegal";
        }
        return this.getJavaKind().format(this.asBoxedPrimitive());
    }

    public static String toString(JavaConstant constant) {
        if (constant.getJavaKind() == JavaKind.Illegal) {
            return "illegal";
        }
        return constant.getJavaKind().getJavaName() + "[" + constant.toValueString() + "]";
    }

    public static PrimitiveConstant forDouble(double d) {
        if (Double.compare(0.0, d) == 0) {
            return DOUBLE_0;
        }
        if (Double.compare(d, 1.0) == 0) {
            return DOUBLE_1;
        }
        return new PrimitiveConstant(JavaKind.Double, Double.doubleToRawLongBits(d));
    }

    public static PrimitiveConstant forFloat(float f) {
        if (Float.compare(f, 0.0f) == 0) {
            return FLOAT_0;
        }
        if (Float.compare(f, 1.0f) == 0) {
            return FLOAT_1;
        }
        return new PrimitiveConstant(JavaKind.Float, Float.floatToRawIntBits(f));
    }

    public static PrimitiveConstant forLong(long i) {
        if (i == 0L) {
            return LONG_0;
        }
        if (i == 1L) {
            return LONG_1;
        }
        return new PrimitiveConstant(JavaKind.Long, i);
    }

    public static PrimitiveConstant forInt(int i) {
        switch (i) {
            case -1: {
                return INT_MINUS_1;
            }
            case 0: {
                return INT_0;
            }
            case 1: {
                return INT_1;
            }
            case 2: {
                return INT_2;
            }
        }
        return new PrimitiveConstant(JavaKind.Int, i);
    }

    public static PrimitiveConstant forByte(byte i) {
        return new PrimitiveConstant(JavaKind.Byte, i);
    }

    public static PrimitiveConstant forBoolean(boolean i) {
        return i ? TRUE : FALSE;
    }

    public static PrimitiveConstant forChar(char i) {
        return new PrimitiveConstant(JavaKind.Char, i);
    }

    public static PrimitiveConstant forShort(short i) {
        return new PrimitiveConstant(JavaKind.Short, i);
    }

    public static PrimitiveConstant forIntegerKind(JavaKind kind, long i) {
        switch (kind) {
            case Boolean: {
                return JavaConstant.forBoolean(i != 0L);
            }
            case Byte: {
                return JavaConstant.forByte((byte)i);
            }
            case Short: {
                return JavaConstant.forShort((short)i);
            }
            case Char: {
                return JavaConstant.forChar((char)i);
            }
            case Int: {
                return JavaConstant.forInt((int)i);
            }
            case Long: {
                return JavaConstant.forLong(i);
            }
        }
        throw new IllegalArgumentException("not an integer kind: " + (Object)((Object)kind));
    }

    public static PrimitiveConstant forPrimitiveInt(int bits, long i) {
        if (!2.$assertionsDisabled && bits > 64) {
            throw new AssertionError();
        }
        switch (bits) {
            case 1: {
                return JavaConstant.forBoolean(i != 0L);
            }
            case 8: {
                return JavaConstant.forByte((byte)i);
            }
            case 16: {
                return JavaConstant.forShort((short)i);
            }
            case 32: {
                return JavaConstant.forInt((int)i);
            }
            case 64: {
                return JavaConstant.forLong(i);
            }
        }
        throw new IllegalArgumentException("unsupported integer width: " + bits);
    }

    public static PrimitiveConstant forBoxedPrimitive(Object value) {
        if (value instanceof Boolean) {
            return JavaConstant.forBoolean((Boolean)value);
        }
        if (value instanceof Byte) {
            return JavaConstant.forByte((Byte)value);
        }
        if (value instanceof Character) {
            return JavaConstant.forChar(((Character)value).charValue());
        }
        if (value instanceof Short) {
            return JavaConstant.forShort((Short)value);
        }
        if (value instanceof Integer) {
            return JavaConstant.forInt((Integer)value);
        }
        if (value instanceof Long) {
            return JavaConstant.forLong((Long)value);
        }
        if (value instanceof Float) {
            return JavaConstant.forFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return JavaConstant.forDouble((Double)value);
        }
        return null;
    }

    public static PrimitiveConstant forIllegal() {
        return new PrimitiveConstant(JavaKind.Illegal, 0L);
    }

    public static JavaConstant defaultForKind(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return FALSE;
            }
            case Byte: {
                return JavaConstant.forByte((byte)0);
            }
            case Char: {
                return JavaConstant.forChar('\u0000');
            }
            case Short: {
                return JavaConstant.forShort((short)0);
            }
            case Int: {
                return INT_0;
            }
            case Double: {
                return DOUBLE_0;
            }
            case Float: {
                return FLOAT_0;
            }
            case Long: {
                return LONG_0;
            }
            case Object: {
                return NULL_POINTER;
            }
        }
        throw new IllegalArgumentException(kind.toString());
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        NULL_POINTER = new NullConstant();
        INT_MINUS_1 = new PrimitiveConstant(JavaKind.Int, -1L);
        INT_0 = new PrimitiveConstant(JavaKind.Int, 0L);
        INT_1 = new PrimitiveConstant(JavaKind.Int, 1L);
        INT_2 = new PrimitiveConstant(JavaKind.Int, 2L);
        LONG_0 = new PrimitiveConstant(JavaKind.Long, 0L);
        LONG_1 = new PrimitiveConstant(JavaKind.Long, 1L);
        FLOAT_0 = new PrimitiveConstant(JavaKind.Float, Float.floatToRawIntBits(0.0f));
        FLOAT_1 = new PrimitiveConstant(JavaKind.Float, Float.floatToRawIntBits(1.0f));
        DOUBLE_0 = new PrimitiveConstant(JavaKind.Double, Double.doubleToRawLongBits(0.0));
        DOUBLE_1 = new PrimitiveConstant(JavaKind.Double, Double.doubleToRawLongBits(1.0));
        TRUE = new PrimitiveConstant(JavaKind.Boolean, 1L);
        FALSE = new PrimitiveConstant(JavaKind.Boolean, 0L);
    }
}

