/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import java.util.IllegalFormatException;
import java.util.UnknownFormatConversionException;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;

public interface JavaMethod {
    public String getName();

    public JavaType getDeclaringClass();

    public Signature getSignature();

    default public String format(String format) throws IllegalFormatException {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        Signature sig = null;
        block8: while (index < format.length()) {
            char ch;
            if ((ch = format.charAt(index++)) == '%') {
                if (index >= format.length()) {
                    throw new UnknownFormatConversionException("An unquoted '%' character cannot terminate a method format specification");
                }
                char specifier = format.charAt(index++);
                switch (specifier) {
                    case 'R': 
                    case 'r': {
                        if (sig == null) {
                            sig = this.getSignature();
                        }
                        sb.append(sig.getReturnType(null).toJavaName(specifier == 'R'));
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        sb.append(this.getDeclaringClass().toJavaName(specifier == 'H'));
                        break;
                    }
                    case 'n': {
                        sb.append(this.getName());
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        if (sig == null) {
                            sig = this.getSignature();
                        }
                        for (int i = 0; i < sig.getParameterCount(false); ++i) {
                            if (i != 0) {
                                sb.append(", ");
                            }
                            sb.append(sig.getParameterType(i, null).toJavaName(specifier == 'P'));
                        }
                        continue block8;
                    }
                    case 'f': {
                        sb.append(!(this instanceof ResolvedJavaMethod) ? "unresolved" : (((ResolvedJavaMethod)this).isStatic() ? "static" : "virtual"));
                        break;
                    }
                    case '%': {
                        sb.append('%');
                        break;
                    }
                    default: {
                        throw new UnknownFormatConversionException(String.valueOf(specifier));
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

