/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import jdk.vm.ci.meta.AbstractJavaProfile;
import jdk.vm.ci.meta.AbstractProfiledItem;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class MetaUtil {
    public static String getSimpleName(Class<?> clazz, boolean withEnclosingClass) {
        String simpleName = MetaUtil.safeSimpleName(clazz);
        if (simpleName.length() != 0) {
            if (withEnclosingClass) {
                String prefix = "";
                Class<?> enclosingClass = clazz;
                while ((enclosingClass = enclosingClass.getEnclosingClass()) != null) {
                    prefix = MetaUtil.safeSimpleName(enclosingClass) + "." + prefix;
                }
                return prefix + simpleName;
            }
            return simpleName;
        }
        String name = clazz.getName();
        int index = name.indexOf(36);
        if (index == -1) {
            return name;
        }
        if ((index = name.lastIndexOf(46, index)) == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    private static String safeSimpleName(Class<?> clazz) {
        try {
            return clazz.getSimpleName();
        }
        catch (InternalError e) {
            Class<?> enclosingClass = clazz.getEnclosingClass();
            String fqn = clazz.getName();
            if (enclosingClass == null) {
                return fqn;
            }
            String enclosingFQN = enclosingClass.getName();
            int length = fqn.length();
            if (enclosingFQN.length() >= length) {
                return fqn;
            }
            return fqn.substring(enclosingFQN.length());
        }
    }

    private static String replacePackageSeparatorsWithDot(String name) {
        int length = name.length();
        StringBuilder buf = new StringBuilder(length);
        for (int i = 0; i < length - 1; ++i) {
            char ch = name.charAt(i);
            if (ch == '/' && Character.isJavaIdentifierStart(name.charAt(i + 1))) {
                buf.append('.');
                continue;
            }
            buf.append(ch);
        }
        buf.append(name.charAt(length - 1));
        return buf.toString();
    }

    public static String internalNameToJava(String name, boolean qualified, boolean classForNameCompatible) {
        switch (name.charAt(0)) {
            case 'L': {
                int lastDot;
                String result = MetaUtil.replacePackageSeparatorsWithDot(name.substring(1, name.length() - 1));
                if (!qualified && (lastDot = result.lastIndexOf(46)) != -1) {
                    result = result.substring(lastDot + 1);
                }
                return result;
            }
            case '[': {
                return classForNameCompatible ? MetaUtil.replacePackageSeparatorsWithDot(name) : MetaUtil.internalNameToJava(name.substring(1), qualified, classForNameCompatible) + "[]";
            }
        }
        if (name.length() != 1) {
            throw new IllegalArgumentException("Illegal internal name: " + name);
        }
        return JavaKind.fromPrimitiveOrVoidTypeChar(name.charAt(0)).getJavaName();
    }

    public static String toLocation(ResolvedJavaMethod method, int bci) {
        return MetaUtil.appendLocation(new StringBuilder(), method, bci).toString();
    }

    public static StringBuilder appendLocation(StringBuilder sb, ResolvedJavaMethod method, int bci) {
        if (method != null) {
            StackTraceElement ste = method.asStackTraceElement(bci);
            if (ste.getFileName() != null && ste.getLineNumber() > 0) {
                sb.append(ste);
            } else {
                sb.append(method.format("%H.%n(%p)"));
            }
        } else {
            sb.append("Null method");
        }
        return sb.append(" [bci: ").append(bci).append(']');
    }

    static void appendProfile(StringBuilder buf, AbstractJavaProfile<?, ?> profile, int bci, String type, String sep) {
        AbstractProfiledItem[] pitems;
        if (profile != null && (pitems = profile.getItems()) != null) {
            buf.append(String.format("%s@%d:", type, bci));
            for (int j = 0; j < pitems.length; ++j) {
                AbstractProfiledItem pitem = pitems[j];
                buf.append(String.format(" %.6f (%s)%s", pitem.getProbability(), pitem.getItem(), sep));
            }
            if (profile.getNotRecordedProbability() != 0.0) {
                buf.append(String.format(" %.6f <other %s>%s", profile.getNotRecordedProbability(), type, sep));
            } else {
                buf.append(String.format(" <no other %s>%s", type, sep));
            }
        }
    }

    public static String toInternalName(String className) {
        if (className.startsWith("[")) {
            return className.replace('.', '/');
        }
        StringBuilder result = new StringBuilder();
        String base = className;
        while (base.endsWith("[]")) {
            result.append("[");
            base = base.substring(0, base.length() - 2);
        }
        switch (base) {
            case "boolean": {
                result.append("Z");
                break;
            }
            case "byte": {
                result.append("B");
                break;
            }
            case "short": {
                result.append("S");
                break;
            }
            case "char": {
                result.append("C");
                break;
            }
            case "int": {
                result.append("I");
                break;
            }
            case "float": {
                result.append("F");
                break;
            }
            case "long": {
                result.append("J");
                break;
            }
            case "double": {
                result.append("D");
                break;
            }
            case "void": {
                result.append("V");
                break;
            }
            default: {
                result.append("L").append(base.replace('.', '/')).append(";");
            }
        }
        return result.toString();
    }

    public static String identityHashCodeString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + "@" + System.identityHashCode(obj);
    }
}

