/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import java.nio.ByteBuffer;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.SerializableConstant;

public class PrimitiveConstant
implements JavaConstant,
SerializableConstant {
    private final JavaKind kind;
    private final long primitive;

    protected PrimitiveConstant(JavaKind kind, long primitive) {
        this.primitive = primitive;
        this.kind = kind;
        assert (kind.isPrimitive() || kind == JavaKind.Illegal);
    }

    static PrimitiveConstant forTypeChar(char kind, long i) {
        return JavaConstant.forIntegerKind(JavaKind.fromPrimitiveOrVoidTypeChar(kind), i);
    }

    @Override
    public JavaKind getJavaKind() {
        return this.kind;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isDefaultForKind() {
        return this.primitive == 0L;
    }

    @Override
    public boolean asBoolean() {
        assert (this.getJavaKind() == JavaKind.Boolean);
        return this.primitive != 0L;
    }

    @Override
    public int asInt() {
        assert (this.getJavaKind().getStackKind() == JavaKind.Int) : this.getJavaKind().getStackKind();
        return (int)this.primitive;
    }

    @Override
    public long asLong() {
        assert (this.getJavaKind().isNumericInteger());
        return this.primitive;
    }

    @Override
    public float asFloat() {
        assert (this.getJavaKind() == JavaKind.Float);
        return Float.intBitsToFloat((int)this.primitive);
    }

    @Override
    public double asDouble() {
        assert (this.getJavaKind() == JavaKind.Double);
        return Double.longBitsToDouble(this.primitive);
    }

    @Override
    public Object asBoxedPrimitive() {
        switch (this.getJavaKind()) {
            case Byte: {
                return (byte)this.primitive;
            }
            case Boolean: {
                return this.asBoolean();
            }
            case Short: {
                return (short)this.primitive;
            }
            case Char: {
                return Character.valueOf((char)this.primitive);
            }
            case Int: {
                return this.asInt();
            }
            case Long: {
                return this.asLong();
            }
            case Float: {
                return Float.valueOf(this.asFloat());
            }
            case Double: {
                return this.asDouble();
            }
        }
        throw new IllegalArgumentException("unexpected kind " + (Object)((Object)this.getJavaKind()));
    }

    @Override
    public int getSerializedSize() {
        return this.getJavaKind().getByteCount();
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        switch (this.getJavaKind()) {
            case Byte: 
            case Boolean: {
                buffer.put((byte)this.primitive);
                break;
            }
            case Short: {
                buffer.putShort((short)this.primitive);
                break;
            }
            case Char: {
                buffer.putChar((char)this.primitive);
                break;
            }
            case Int: {
                buffer.putInt(this.asInt());
                break;
            }
            case Long: {
                buffer.putLong(this.asLong());
                break;
            }
            case Float: {
                buffer.putFloat(this.asFloat());
                break;
            }
            case Double: {
                buffer.putDouble(this.asDouble());
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected kind " + (Object)((Object)this.getJavaKind()));
            }
        }
    }

    public int hashCode() {
        return (int)(this.primitive ^ this.primitive >>> 32) * (this.getJavaKind().ordinal() + 31);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimitiveConstant)) {
            return false;
        }
        PrimitiveConstant other = (PrimitiveConstant)o;
        return this.kind.equals((Object)other.kind) && this.primitive == other.primitive;
    }

    public String toString() {
        if (this.getJavaKind() == JavaKind.Illegal) {
            return "illegal";
        }
        return this.getJavaKind().getJavaName() + "[" + this.asBoxedPrimitive() + "|0x" + Long.toHexString(this.primitive) + "]";
    }
}

