/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.TriState;

public interface ProfilingInfo {
    public int getCodeSize();

    public double getBranchTakenProbability(int var1);

    public double[] getSwitchProbabilities(int var1);

    public JavaTypeProfile getTypeProfile(int var1);

    public JavaMethodProfile getMethodProfile(int var1);

    public TriState getExceptionSeen(int var1);

    public TriState getNullSeen(int var1);

    public int getExecutionCount(int var1);

    public int getDeoptimizationCount(DeoptimizationReason var1);

    public boolean setCompilerIRSize(Class<?> var1, int var2);

    public int getCompilerIRSize(Class<?> var1);

    public boolean isMature();

    public void setMature();

    default public String toString(ResolvedJavaMethod method, String sep) {
        StringBuilder buf = new StringBuilder(100);
        if (method != null) {
            buf.append(String.format("canBeStaticallyBound: %b%s", method.canBeStaticallyBound(), sep));
        }
        for (int i = 0; i < this.getCodeSize(); ++i) {
            double[] dArray;
            if (this.getExecutionCount(i) != -1) {
                buf.append(String.format("executionCount@%d: %d%s", i, this.getExecutionCount(i), sep));
            }
            if (this.getBranchTakenProbability(i) != -1.0) {
                buf.append(String.format("branchProbability@%d: %.6f%s", i, this.getBranchTakenProbability(i), sep));
            }
            if ((dArray = this.getSwitchProbabilities(i)) != null) {
                buf.append(String.format("switchProbabilities@%d:", i));
                for (int j = 0; j < dArray.length; ++j) {
                    buf.append(String.format(" %.6f", dArray[j]));
                }
                buf.append(sep);
            }
            if (this.getExceptionSeen(i) != TriState.UNKNOWN) {
                buf.append(String.format("exceptionSeen@%d: %s%s", i, this.getExceptionSeen(i).name(), sep));
            }
            if (this.getNullSeen(i) != TriState.UNKNOWN) {
                buf.append(String.format("nullSeen@%d: %s%s", i, this.getNullSeen(i).name(), sep));
            }
            JavaTypeProfile typeProfile = this.getTypeProfile(i);
            MetaUtil.appendProfile(buf, typeProfile, i, "types", sep);
            JavaMethodProfile methodProfile = this.getMethodProfile(i);
            MetaUtil.appendProfile(buf, methodProfile, i, "methods", sep);
        }
        boolean firstDeoptReason = true;
        for (DeoptimizationReason reason : DeoptimizationReason.values()) {
            int count = this.getDeoptimizationCount(reason);
            if (count <= 0) continue;
            if (firstDeoptReason) {
                buf.append("deoptimization history").append(sep);
                firstDeoptReason = false;
            }
            buf.append(String.format(" %s: %d%s", reason.name(), count, sep));
        }
        if (buf.length() == 0) {
            return "";
        }
        String string = buf.toString();
        return string.substring(0, string.length() - sep.length());
    }
}

