/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import java.util.function.Supplier;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public interface SpeculationLog {
    public static final Speculation NO_SPECULATION = new Speculation(new NoSpeculationReason());

    public void collectFailedSpeculations();

    public boolean maySpeculate(SpeculationReason var1);

    public Speculation speculate(SpeculationReason var1);

    public boolean hasSpeculations();

    public Speculation lookupSpeculation(JavaConstant var1);

    public static class Speculation {
        private final SpeculationReason reason;

        public Speculation(SpeculationReason reason) {
            this.reason = reason;
        }

        public SpeculationReason getReason() {
            return this.reason;
        }

        public String toString() {
            return this.reason.toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Speculation) {
                Speculation other = (Speculation)obj;
                return this.reason.equals(other.reason);
            }
            return false;
        }

        public int hashCode() {
            return this.getReason().hashCode();
        }
    }

    public static final class NoSpeculationReason
    implements SpeculationReason {
    }

    public static interface SpeculationReasonEncoding {
        public void addByte(int var1);

        public void addShort(int var1);

        public void addInt(int var1);

        public void addLong(long var1);

        public void addMethod(ResolvedJavaMethod var1);

        public void addType(ResolvedJavaType var1);

        public void addString(String var1);

        default public void addField(ResolvedJavaField field) {
            this.addType(field.getDeclaringClass());
            this.addInt(field.getModifiers());
            this.addInt(field.getOffset());
        }
    }

    public static interface SpeculationReason {
        default public SpeculationReasonEncoding encode(Supplier<SpeculationReasonEncoding> encodingSupplier) {
            return null;
        }
    }
}

