/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class UnresolvedJavaType
implements JavaType {
    private final String name;

    @Override
    public String getName() {
        return this.name;
    }

    private UnresolvedJavaType(String name) {
        this.name = name;
        assert (name.length() == 1 && JavaKind.fromPrimitiveOrVoidTypeChar(name.charAt(0)) != null || name.charAt(0) == '[' || name.charAt(name.length() - 1) == ';') : name;
    }

    public static UnresolvedJavaType create(String name) {
        return new UnresolvedJavaType(name);
    }

    @Override
    public JavaType getComponentType() {
        if (this.getName().charAt(0) == '[') {
            return new UnresolvedJavaType(this.getName().substring(1));
        }
        return null;
    }

    @Override
    public JavaType getArrayClass() {
        return new UnresolvedJavaType('[' + this.getName());
    }

    @Override
    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof UnresolvedJavaType)) {
            return false;
        }
        UnresolvedJavaType that = (UnresolvedJavaType)obj;
        return this.getName().equals(that.getName());
    }

    public String toString() {
        return "UnresolvedJavaType<" + this.getName() + ">";
    }

    @Override
    public ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        return accessingClass.lookupType(this, true);
    }
}

