/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ValueKind;

public abstract class Value {
    public static final Value[] NO_VALUES = new Value[0];
    public static final AllocatableValue ILLEGAL = new IllegalValue();
    private final ValueKind<?> valueKind;

    protected Value(ValueKind<?> valueKind) {
        this.valueKind = valueKind;
    }

    protected final String getKindSuffix() {
        return "|" + this.valueKind.getKindSuffix();
    }

    public final ValueKind<?> getValueKind() {
        return this.valueKind;
    }

    public final <K extends ValueKind<K>> K getValueKind(Class<K> cls) {
        return (K)((ValueKind)cls.cast(this.valueKind));
    }

    public final PlatformKind getPlatformKind() {
        return this.valueKind.getPlatformKind();
    }

    public int hashCode() {
        return 41 + this.valueKind.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Value) {
            Value that = (Value)obj;
            return this.valueKind.equals(that.valueKind);
        }
        return false;
    }

    public final boolean identityEquals(Value other) {
        return this == other;
    }

    private static final class IllegalValue
    extends AllocatableValue {
        private IllegalValue() {
            super(ValueKind.Illegal);
        }

        public String toString() {
            return "-";
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof IllegalValue;
        }
    }
}

