/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.sparc;

import jdk.vm.ci.meta.PlatformKind;

public final class SPARCKind
extends Enum<SPARCKind>
implements PlatformKind {
    public static final /* enum */ SPARCKind BYTE = new SPARCKind(1);
    public static final /* enum */ SPARCKind HWORD = new SPARCKind(2);
    public static final /* enum */ SPARCKind WORD = new SPARCKind(4);
    public static final /* enum */ SPARCKind XWORD = new SPARCKind(8);
    public static final /* enum */ SPARCKind SINGLE = new SPARCKind(4);
    public static final /* enum */ SPARCKind DOUBLE = new SPARCKind(8);
    public static final /* enum */ SPARCKind QUAD = new SPARCKind(16);
    public static final /* enum */ SPARCKind V32_BYTE = new SPARCKind(4, BYTE);
    public static final /* enum */ SPARCKind V32_HWORD = new SPARCKind(4, HWORD);
    public static final /* enum */ SPARCKind V64_BYTE = new SPARCKind(8, BYTE);
    public static final /* enum */ SPARCKind V64_HWORD = new SPARCKind(8, HWORD);
    public static final /* enum */ SPARCKind V64_WORD = new SPARCKind(8, WORD);
    public static final /* enum */ SPARCKind V64_SINGLE = new SPARCKind(8, SINGLE);
    private final int size;
    private final int vectorLength;
    private final SPARCKind scalar;
    private final PlatformKind.EnumKey<SPARCKind> key = new PlatformKind.EnumKey<SPARCKind>(this);
    private static final /* synthetic */ SPARCKind[] $VALUES;

    public static SPARCKind[] values() {
        return (SPARCKind[])$VALUES.clone();
    }

    public static SPARCKind valueOf(String name) {
        return Enum.valueOf(SPARCKind.class, name);
    }

    private SPARCKind(int size) {
        this.size = size;
        this.scalar = this;
        this.vectorLength = 1;
    }

    private SPARCKind(int size, SPARCKind scalar) {
        this.size = size;
        this.scalar = scalar;
        assert (size % scalar.size == 0);
        this.vectorLength = size / scalar.size;
    }

    public SPARCKind getScalar() {
        return this.scalar;
    }

    @Override
    public int getSizeInBytes() {
        return this.size;
    }

    public int getSizeInBits() {
        return this.getSizeInBytes() * 8;
    }

    @Override
    public int getVectorLength() {
        return this.vectorLength;
    }

    @Override
    public PlatformKind.Key getKey() {
        return this.key;
    }

    public boolean isInteger() {
        switch (this) {
            case BYTE: 
            case HWORD: 
            case WORD: 
            case XWORD: {
                return true;
            }
        }
        return false;
    }

    public boolean isFloat() {
        return !this.isInteger();
    }

    @Override
    public char getTypeChar() {
        switch (this) {
            case BYTE: {
                return 'b';
            }
            case HWORD: {
                return 'h';
            }
            case WORD: {
                return 'w';
            }
            case XWORD: {
                return 'd';
            }
            case SINGLE: {
                return 'S';
            }
            case DOUBLE: 
            case V64_BYTE: 
            case V64_HWORD: 
            case V64_WORD: {
                return 'D';
            }
        }
        return '-';
    }

    static {
        $VALUES = new SPARCKind[]{BYTE, HWORD, WORD, XWORD, SINGLE, DOUBLE, QUAD, V32_BYTE, V32_HWORD, V64_BYTE, V64_HWORD, V64_WORD, V64_SINGLE};
    }
}

