/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.info;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.runtime.JSRealm;

public final class Script {
    private final int id;
    private final ScriptNode scriptNode;
    private final Object parseResult;
    private final JSRealm realm;
    private final boolean graalInternal;

    public Script(ScriptNode scriptNode, Object parseResult, JSRealm realm, int id) {
        this.scriptNode = scriptNode;
        this.parseResult = parseResult;
        this.realm = realm;
        this.id = id;
        this.graalInternal = Script.isGraalInternalScript(scriptNode.getRootNode().getSourceSection().getSource());
    }

    public ScriptNode getScriptNode() {
        return this.scriptNode;
    }

    public Object getParseResult() {
        return this.parseResult;
    }

    public JSRealm getRealm() {
        return this.realm;
    }

    public int getId() {
        return this.id;
    }

    public boolean isGraalInternal() {
        return this.graalInternal;
    }

    private static boolean isGraalInternalScript(Source source) {
        String name = source.getName();
        return name.startsWith("graal/") || name.startsWith("internal/graal/") || name.equals("internal/worker.js") || name.equals("inspector.js");
    }
}

