/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.threading;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.JSBuiltinLookup;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.threading.SharedMemMessagingBuiltins;

public final class SharedMemMessagingBindings
extends JSBuiltinObject {
    private static final SharedMemMessagingBindings INSTANCE = new SharedMemMessagingBindings();
    private static final JSBuiltinsContainer BUILTINS = new SharedMemMessagingBuiltins();
    private static final String CLASS_NAME = "SharedMemMessaging";
    private static final HiddenKey API = new HiddenKey("api");
    private static final Property API_PROPERTY;

    public static void setApiField(DynamicObject obj, Object api) {
        API_PROPERTY.setSafe(obj, api, null);
    }

    public static Object getApiField(DynamicObject obj) {
        return API_PROPERTY.get(obj, SharedMemMessagingBindings.isInstance((DynamicObject)obj, (JSClass)INSTANCE));
    }

    private SharedMemMessagingBindings() {
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject create(JSContext context, GraalJSAccess graalJSAccess) {
        DynamicObject obj = context.createEmptyShape().addProperty(API_PROPERTY).newInstance();
        ((JSBuiltinLookup)context.getFunctionLookup()).defineBuiltins(BUILTINS);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)context.getRealm(), (DynamicObject)obj, (String)BUILTINS.getName());
        SharedMemMessagingBindings.setApiField(obj, graalJSAccess);
        return obj;
    }

    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object createInitFunction(final GraalJSAccess graalJSAccess, final JSContext context) {
        JSRealm realm = context.getRealm();
        JavaScriptRootNode wrapperNode = new JavaScriptRootNode(){

            public Object execute(VirtualFrame frame) {
                return SharedMemMessagingBindings.create(context, graalJSAccess);
            }
        };
        JSFunctionData functionData = JSFunctionData.createCallOnly((JSContext)context, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)wrapperNode), (int)2, (String)"SharedMemMessagingInit");
        return JSFunction.create((JSRealm)realm, (JSFunctionData)functionData);
    }

    static {
        Shape.Allocator allocator = JSShape.makeAllocator((Layout)JSObject.LAYOUT);
        API_PROPERTY = JSObjectUtil.makeHiddenProperty((HiddenKey)API, (Location)allocator.locationForType(Object.class));
    }
}

