/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.util;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class LineSearch {
    private LineSearch() {
    }

    public static JSONArray matchLines(Source source, String query, boolean caseSensitive, boolean isRegex) throws PatternSyntaxException {
        JSONArray matchLines = new JSONArray();
        Pattern pattern = isRegex ? Pattern.compile(query, caseSensitive ? 0 : 66) : null;
        for (int lineNumber = 1; lineNumber <= source.getLineCount(); ++lineNumber) {
            String line = source.getCharacters(lineNumber).toString();
            if (isRegex) {
                assert (pattern != null);
                if (!pattern.matcher(line).find()) continue;
                LineSearch.addSearchMatch(matchLines, lineNumber, line);
                continue;
            }
            if ((!caseSensitive || !line.contains(query)) && (caseSensitive || !LineSearch.containsIgnoreCase(line, query))) continue;
            LineSearch.addSearchMatch(matchLines, lineNumber, line);
        }
        return matchLines;
    }

    private static void addSearchMatch(JSONArray matchLines, int lineNumber, String line) {
        JSONObject matchLine = new JSONObject();
        matchLine.put("lineNumber", lineNumber - 1);
        matchLine.put("lineContent", (Object)line);
        matchLines.put((Object)matchLine);
    }

    private static boolean containsIgnoreCase(String line, String query) {
        int ql;
        int ll = line.length();
        if (ll == (ql = query.length())) {
            return line.equalsIgnoreCase(query);
        }
        if (ll > ql) {
            for (int li = 0; li <= ll - ql; ++li) {
                int k = li;
                int qi = 0;
                while (qi < ql && LineSearch.compareIgnoreCase(line.charAt(k), query.charAt(qi))) {
                    ++qi;
                    ++k;
                }
                if (k != li + ql) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean compareIgnoreCase(char c1, char c2) {
        if (c1 == c2) {
            return true;
        }
        return Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }
}

