/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketAdapter;
import org.java_websocket.WebSocketImpl;

public abstract class AbstractWebSocket
extends WebSocketAdapter {
    private boolean tcpNoDelay;
    private boolean reuseAddr;
    private Timer connectionLostTimer;
    private TimerTask connectionLostTimerTask;
    private int connectionLostTimeout = 60;
    private boolean websocketRunning = false;

    public int getConnectionLostTimeout() {
        return this.connectionLostTimeout;
    }

    public void setConnectionLostTimeout(int connectionLostTimeout) {
        this.connectionLostTimeout = connectionLostTimeout;
        if (this.connectionLostTimeout <= 0) {
            if (WebSocketImpl.DEBUG) {
                System.out.println("Connection lost timer stopped");
            }
            this.cancelConnectionLostTimer();
            return;
        }
        if (this.websocketRunning) {
            block7: {
                if (WebSocketImpl.DEBUG) {
                    System.out.println("Connection lost timer restarted");
                }
                try {
                    ArrayList<WebSocket> connections = new ArrayList<WebSocket>(this.getConnections());
                    for (WebSocket conn : connections) {
                        if (!(conn instanceof WebSocketImpl)) continue;
                        WebSocketImpl webSocketImpl = (WebSocketImpl)conn;
                        webSocketImpl.updateLastPong();
                    }
                }
                catch (Exception e) {
                    if (!WebSocketImpl.DEBUG) break block7;
                    System.out.println("Exception during connection lost restart: " + e.getMessage());
                }
            }
            this.restartConnectionLostTimer();
        }
    }

    protected void stopConnectionLostTimer() {
        if (this.connectionLostTimer != null || this.connectionLostTimerTask != null) {
            this.websocketRunning = false;
            if (WebSocketImpl.DEBUG) {
                System.out.println("Connection lost timer stopped");
            }
            this.cancelConnectionLostTimer();
        }
    }

    protected void startConnectionLostTimer() {
        if (this.connectionLostTimeout <= 0) {
            if (WebSocketImpl.DEBUG) {
                System.out.println("Connection lost timer deactivated");
            }
            return;
        }
        if (WebSocketImpl.DEBUG) {
            System.out.println("Connection lost timer started");
        }
        this.websocketRunning = true;
        this.restartConnectionLostTimer();
    }

    private void restartConnectionLostTimer() {
        this.cancelConnectionLostTimer();
        this.connectionLostTimer = new Timer("WebSocketTimer");
        this.connectionLostTimerTask = new TimerTask(){
            private ArrayList<WebSocket> connections = new ArrayList();

            @Override
            public void run() {
                block6: {
                    this.connections.clear();
                    try {
                        this.connections.addAll(AbstractWebSocket.this.getConnections());
                        long current = System.currentTimeMillis() - (long)(AbstractWebSocket.this.connectionLostTimeout * 1500);
                        for (WebSocket conn : this.connections) {
                            if (!(conn instanceof WebSocketImpl)) continue;
                            WebSocketImpl webSocketImpl = (WebSocketImpl)conn;
                            if (webSocketImpl.getLastPong() < current) {
                                if (WebSocketImpl.DEBUG) {
                                    System.out.println("Closing connection due to no pong received: " + conn.toString());
                                }
                                webSocketImpl.closeConnection(1006, "The connection was closed because the other endpoint did not respond with a pong in time. For more information check: https://github.com/TooTallNate/Java-WebSocket/wiki/Lost-connection-detection");
                                continue;
                            }
                            if (webSocketImpl.isOpen()) {
                                webSocketImpl.sendPing();
                                continue;
                            }
                            if (!WebSocketImpl.DEBUG) continue;
                            System.out.println("Trying to ping a non open connection: " + conn.toString());
                        }
                    }
                    catch (Exception e) {
                        if (!WebSocketImpl.DEBUG) break block6;
                        System.out.println("Exception during connection lost ping: " + e.getMessage());
                    }
                }
                this.connections.clear();
            }
        };
        this.connectionLostTimer.scheduleAtFixedRate(this.connectionLostTimerTask, this.connectionLostTimeout * 1000, (long)(this.connectionLostTimeout * 1000));
    }

    protected abstract Collection<WebSocket> getConnections();

    private void cancelConnectionLostTimer() {
        if (this.connectionLostTimer != null) {
            this.connectionLostTimer.cancel();
            this.connectionLostTimer = null;
        }
        if (this.connectionLostTimerTask != null) {
            this.connectionLostTimerTask.cancel();
            this.connectionLostTimerTask = null;
        }
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isReuseAddr() {
        return this.reuseAddr;
    }

    public void setReuseAddr(boolean reuseAddr) {
        this.reuseAddr = reuseAddr;
    }
}

