/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import java.lang.ref.Reference;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;

public final class ReferenceDetailsProvider
extends DetailsProvider.Basic {
    public ReferenceDetailsProvider() {
        super(Reference.class.getName() + "+");
    }

    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        Object value = instance.getValueOfField("referent");
        if (value instanceof Instance) {
            Instance i = (Instance)value;
            String s = DetailsUtils.getInstanceString(i, heap);
            s = s == null ? "#" + i.getInstanceNumber() : ": " + s;
            return BrowserUtils.getSimpleType(i.getJavaClass().getName()) + s;
        }
        return null;
    }
}

