/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import java.io.Closeable;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.HotSpotToSVM;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.SVMToHotSpot;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSCompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilerListenerGen;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleInliningPlan;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.SVMObjectHandles;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.HotSpotToSVMScope;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;

final class HSTruffleCompilerListener
extends HSObject
implements TruffleCompilerListener {
    HSTruffleCompilerListener(HotSpotToSVMScope<HotSpotToSVM.Id> scope, JNI.JObject handle) {
        super(scope, handle);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.OnSuccess)
    public void onSuccess(CompilableTruffleAST compilable, TruffleInliningPlan inliningPlan, TruffleCompilerListener.GraphInfo graphInfo, TruffleCompilerListener.CompilationResultInfo compilationResultInfo) {
        JNI.JObject hsCompilable = ((HSCompilableTruffleAST)compilable).getHandle();
        JNI.JObject hsInliningPlan = ((HSTruffleInliningPlan)inliningPlan).getHandle();
        JNI.JNIEnv env = HotSpotToSVMScope.env();
        try (SVMObjectHandleScope graphInfoScope = SVMObjectHandleScope.forObject(graphInfo);
             SVMObjectHandleScope compilationResultInfoScope = SVMObjectHandleScope.forObject(compilationResultInfo);){
            HSTruffleCompilerListenerGen.callOnSuccess(env, this.getHandle(), hsCompilable, hsInliningPlan, graphInfoScope.getHandle(), compilationResultInfoScope.getHandle());
        }
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.OnTruffleTierFinished)
    public void onTruffleTierFinished(CompilableTruffleAST compilable, TruffleInliningPlan inliningPlan, TruffleCompilerListener.GraphInfo graph) {
        JNI.JObject hsCompilable = ((HSCompilableTruffleAST)compilable).getHandle();
        JNI.JObject hsInliningPlan = ((HSTruffleInliningPlan)inliningPlan).getHandle();
        JNI.JNIEnv env = HotSpotToSVMScope.env();
        try (SVMObjectHandleScope graphInfoScope = SVMObjectHandleScope.forObject(graph);){
            HSTruffleCompilerListenerGen.callOnTruffleTierFinished(env, this.getHandle(), hsCompilable, hsInliningPlan, graphInfoScope.getHandle());
        }
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.OnGraalTierFinished)
    public void onGraalTierFinished(CompilableTruffleAST compilable, TruffleCompilerListener.GraphInfo graph) {
        JNI.JObject hsCompilable = ((HSCompilableTruffleAST)compilable).getHandle();
        JNI.JNIEnv env = HotSpotToSVMScope.env();
        try (SVMObjectHandleScope graphInfoScope = SVMObjectHandleScope.forObject(graph);){
            HSTruffleCompilerListenerGen.callOnGraalTierFinished(env, this.getHandle(), hsCompilable, graphInfoScope.getHandle());
        }
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.OnFailure)
    public void onFailure(CompilableTruffleAST compilable, String reason, boolean bailout, boolean permanentBailout) {
        JNI.JObject hsCompilable = ((HSCompilableTruffleAST)compilable).getHandle();
        JNI.JNIEnv env = HotSpotToSVMScope.env();
        JNI.JString hsReason = JNIUtil.createHSString((JNI.JNIEnv)env, (String)reason);
        HSTruffleCompilerListenerGen.callOnFailure(env, this.getHandle(), hsCompilable, (JNI.JObject)hsReason, bailout, permanentBailout);
    }

    private static final class SVMObjectHandleScope
    implements Closeable {
        private long handle;

        private SVMObjectHandleScope(long handle) {
            this.handle = handle;
        }

        @Override
        public void close() {
            SVMObjectHandles.remove(this.handle);
            this.handle = 0L;
        }

        long getHandle() {
            if (this.handle == 0L) {
                throw new IllegalStateException("Reading handle from a closed scope.");
            }
            return this.handle;
        }

        static SVMObjectHandleScope forObject(Object object) {
            return new SVMObjectHandleScope(SVMObjectHandles.create(object));
        }
    }
}

