/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.asm.AbstractAddress;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;

public final class AArch64Address
extends AbstractAddress {
    public static final AArch64Address PLACEHOLDER = AArch64Address.createPcLiteralAddress(0);
    private final Register base;
    private final Register offset;
    private final int immediate;
    private final boolean scaled;
    private final AArch64Assembler.ExtendType extendType;
    private final AddressingMode addressingMode;

    public static AArch64Address createAddress(AddressingMode addressingMode, Register base, Register offset, int immediate, boolean isScaled, AArch64Assembler.ExtendType extendType) {
        return new AArch64Address(base, offset, immediate, isScaled, extendType, addressingMode);
    }

    public static AArch64Address createPostIndexedImmediateAddress(Register base, int imm9) {
        return new AArch64Address(base, AArch64.zr, imm9, false, null, AddressingMode.IMMEDIATE_POST_INDEXED);
    }

    public static AArch64Address createPreIndexedImmediateAddress(Register base, int imm9) {
        return new AArch64Address(base, AArch64.zr, imm9, false, null, AddressingMode.IMMEDIATE_PRE_INDEXED);
    }

    public static AArch64Address createScaledImmediateAddress(Register base, int imm12) {
        return new AArch64Address(base, AArch64.zr, imm12, true, null, AddressingMode.IMMEDIATE_SCALED);
    }

    public static AArch64Address createUnscaledImmediateAddress(Register base, int imm9) {
        return new AArch64Address(base, AArch64.zr, imm9, false, null, AddressingMode.IMMEDIATE_UNSCALED);
    }

    public static AArch64Address createBaseRegisterOnlyAddress(Register base) {
        return AArch64Address.createRegisterOffsetAddress(base, AArch64.zr, false);
    }

    public static AArch64Address createRegisterOffsetAddress(Register base, Register offset, boolean scaled) {
        return new AArch64Address(base, offset, 0, scaled, null, AddressingMode.REGISTER_OFFSET);
    }

    public static AArch64Address createPairUnscaledImmediateAddress(Register base, int imm7) {
        return new AArch64Address(base, AArch64.zr, imm7, false, null, AddressingMode.IMMEDIATE_UNSCALED);
    }

    public static AArch64Address createExtendedRegisterOffsetAddress(Register base, Register offset, boolean scaled, AArch64Assembler.ExtendType extendType) {
        return new AArch64Address(base, offset, 0, scaled, extendType, AddressingMode.EXTENDED_REGISTER_OFFSET);
    }

    public static AArch64Address createPcLiteralAddress(int imm21) {
        return new AArch64Address(AArch64.zr, AArch64.zr, imm21, false, null, AddressingMode.PC_LITERAL);
    }

    private AArch64Address(Register base, Register offset, int immediate, boolean scaled, AArch64Assembler.ExtendType extendType, AddressingMode addressingMode) {
        this.base = base;
        this.offset = offset;
        this.addressingMode = (addressingMode == AddressingMode.REGISTER_OFFSET || addressingMode == AddressingMode.EXTENDED_REGISTER_OFFSET) && offset.equals((Object)AArch64.zr) ? AddressingMode.BASE_REGISTER_ONLY : addressingMode;
        this.immediate = immediate;
        this.scaled = scaled;
        this.extendType = extendType;
        assert (this.verify());
    }

    private boolean verify() {
        assert (this.addressingMode != null);
        assert (this.base.getRegisterCategory().equals((Object)AArch64.CPU));
        assert (this.offset.getRegisterCategory().equals((Object)AArch64.CPU));
        switch (this.addressingMode) {
            case IMMEDIATE_SCALED: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (NumUtil.isUnsignedNbit(12, this.immediate));
                break;
            }
            case IMMEDIATE_UNSCALED: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (NumUtil.isSignedNbit(9, this.immediate));
                break;
            }
            case BASE_REGISTER_ONLY: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (this.immediate == 0);
                break;
            }
            case REGISTER_OFFSET: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.getRegisterCategory().equals((Object)AArch64.CPU));
                assert (this.extendType == null);
                assert (this.immediate == 0);
                break;
            }
            case EXTENDED_REGISTER_OFFSET: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.getRegisterCategory().equals((Object)AArch64.CPU));
                assert (this.extendType == AArch64Assembler.ExtendType.SXTW || this.extendType == AArch64Assembler.ExtendType.UXTW);
                assert (this.immediate == 0);
                break;
            }
            case PC_LITERAL: {
                assert (this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (NumUtil.isSignedNbit(21, this.immediate));
                assert ((this.immediate & 3) == 0);
                break;
            }
            case IMMEDIATE_POST_INDEXED: 
            case IMMEDIATE_PRE_INDEXED: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (NumUtil.isSignedNbit(9, this.immediate));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return true;
    }

    public Register getBase() {
        return this.base;
    }

    public Register getOffset() {
        return this.offset;
    }

    public int getImmediate() {
        switch (this.addressingMode) {
            case IMMEDIATE_UNSCALED: 
            case IMMEDIATE_POST_INDEXED: 
            case IMMEDIATE_PRE_INDEXED: {
                assert (NumUtil.isSignedNbit(9, this.immediate));
                return this.immediate & NumUtil.getNbitNumberInt(9);
            }
            case IMMEDIATE_SCALED: {
                assert (NumUtil.isUnsignedNbit(12, this.immediate));
                return this.immediate;
            }
            case PC_LITERAL: {
                assert (NumUtil.isSignedNbit(19, this.immediate >> 2));
                return this.immediate >> 2 & NumUtil.getNbitNumberInt(19);
            }
        }
        throw GraalError.shouldNotReachHere("Should only be called for addressing modes that use immediate values.");
    }

    public int getImmediateRaw() {
        switch (this.addressingMode) {
            case IMMEDIATE_SCALED: 
            case IMMEDIATE_UNSCALED: 
            case PC_LITERAL: 
            case IMMEDIATE_POST_INDEXED: 
            case IMMEDIATE_PRE_INDEXED: {
                return this.immediate;
            }
        }
        throw GraalError.shouldNotReachHere("Should only be called for addressing modes that use immediate values.");
    }

    public boolean isScaled() {
        return this.scaled;
    }

    public AArch64Assembler.ExtendType getExtendType() {
        return this.extendType;
    }

    public AddressingMode getAddressingMode() {
        return this.addressingMode;
    }

    public String toString(int log2TransferSize) {
        int shiftVal = this.scaled ? log2TransferSize : 0;
        switch (this.addressingMode) {
            case IMMEDIATE_SCALED: {
                return String.format("[X%d, %d]", this.base.encoding, this.immediate << log2TransferSize);
            }
            case IMMEDIATE_UNSCALED: {
                return String.format("[X%d, %d]", this.base.encoding, this.immediate);
            }
            case BASE_REGISTER_ONLY: {
                return String.format("[X%d]", this.base.encoding);
            }
            case EXTENDED_REGISTER_OFFSET: {
                if (shiftVal != 0) {
                    return String.format("[X%d, W%d, %s %d]", this.base.encoding, this.offset.encoding, this.extendType.name(), shiftVal);
                }
                return String.format("[X%d, W%d, %s]", this.base.encoding, this.offset.encoding, this.extendType.name());
            }
            case REGISTER_OFFSET: {
                if (shiftVal != 0) {
                    return String.format("[X%d, X%d, LSL %d]", this.base.encoding, this.offset.encoding, shiftVal);
                }
                return String.format("[X%d, X%d]", this.base.encoding, this.offset.encoding);
            }
            case PC_LITERAL: {
                return String.format(".%s%d", this.immediate >= 0 ? "+" : "", this.immediate);
            }
            case IMMEDIATE_POST_INDEXED: {
                return String.format("[X%d],%d", this.base.encoding, this.immediate);
            }
            case IMMEDIATE_PRE_INDEXED: {
                return String.format("[X%d,%d]!", this.base.encoding, this.immediate);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public void lea(AArch64MacroAssembler masm, Register r) {
        switch (this.addressingMode) {
            case IMMEDIATE_UNSCALED: {
                if (this.immediate == 0 && this.base.equals((Object)r)) break;
                masm.add(64, r, this.base, this.immediate);
                break;
            }
            case REGISTER_OFFSET: {
                masm.add(64, r, this.base, this.offset);
                break;
            }
            case PC_LITERAL: {
                masm.mov(r, this.getImmediate());
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    public static enum AddressingMode {
        IMMEDIATE_SCALED,
        IMMEDIATE_UNSCALED,
        BASE_REGISTER_ONLY,
        REGISTER_OFFSET,
        EXTENDED_REGISTER_OFFSET,
        PC_LITERAL,
        IMMEDIATE_POST_INDEXED,
        IMMEDIATE_PRE_INDEXED;

    }
}

