/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.NumUtil;

public class AMD64MacroAssembler
extends AMD64Assembler {
    public AMD64MacroAssembler(TargetDescription target) {
        super(target);
    }

    public final void decrementq(Register reg, int value) {
        if (value == Integer.MIN_VALUE) {
            this.subq(reg, value);
            return;
        }
        if (value < 0) {
            this.incrementq(reg, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.decq(reg);
        } else {
            this.subq(reg, value);
        }
    }

    public final void decrementq(AMD64Address dst, int value) {
        if (value == Integer.MIN_VALUE) {
            this.subq(dst, value);
            return;
        }
        if (value < 0) {
            this.incrementq(dst, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.decq(dst);
        } else {
            this.subq(dst, value);
        }
    }

    public void incrementq(Register reg, int value) {
        if (value == Integer.MIN_VALUE) {
            this.addq(reg, value);
            return;
        }
        if (value < 0) {
            this.decrementq(reg, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.incq(reg);
        } else {
            this.addq(reg, value);
        }
    }

    public final void incrementq(AMD64Address dst, int value) {
        if (value == Integer.MIN_VALUE) {
            this.addq(dst, value);
            return;
        }
        if (value < 0) {
            this.decrementq(dst, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.incq(dst);
        } else {
            this.addq(dst, value);
        }
    }

    public final void movptr(Register dst, AMD64Address src) {
        this.movq(dst, src);
    }

    public final void movptr(AMD64Address dst, Register src) {
        this.movq(dst, src);
    }

    public final void movptr(AMD64Address dst, int src) {
        this.movslq(dst, src);
    }

    public final void cmpptr(Register src1, Register src2) {
        this.cmpq(src1, src2);
    }

    public final void cmpptr(Register src1, AMD64Address src2) {
        this.cmpq(src1, src2);
    }

    public final void decrementl(Register reg) {
        this.decrementl(reg, 1);
    }

    public final void decrementl(Register reg, int value) {
        if (value == Integer.MIN_VALUE) {
            this.subl(reg, value);
            return;
        }
        if (value < 0) {
            this.incrementl(reg, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.decl(reg);
        } else {
            this.subl(reg, value);
        }
    }

    public final void decrementl(AMD64Address dst, int value) {
        if (value == Integer.MIN_VALUE) {
            this.subl(dst, value);
            return;
        }
        if (value < 0) {
            this.incrementl(dst, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.decl(dst);
        } else {
            this.subl(dst, value);
        }
    }

    public final void incrementl(Register reg, int value) {
        if (value == Integer.MIN_VALUE) {
            this.addl(reg, value);
            return;
        }
        if (value < 0) {
            this.decrementl(reg, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.incl(reg);
        } else {
            this.addl(reg, value);
        }
    }

    public final void incrementl(AMD64Address dst, int value) {
        if (value == Integer.MIN_VALUE) {
            this.addl(dst, value);
            return;
        }
        if (value < 0) {
            this.decrementl(dst, -value);
            return;
        }
        if (value == 0) {
            return;
        }
        if (value == 1) {
            this.incl(dst);
        } else {
            this.addl(dst, value);
        }
    }

    public void movflt(Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AMD64.XMM) && src.getRegisterCategory().equals((Object)AMD64.XMM));
        if (AMD64MacroAssembler.isAVX512Register(dst) || AMD64MacroAssembler.isAVX512Register(src)) {
            AMD64Assembler.VexMoveOp.VMOVAPS.emit((AMD64Assembler)this, AVXKind.AVXSize.XMM, dst, src);
        } else {
            this.movaps(dst, src);
        }
    }

    public void movflt(Register dst, AMD64Address src) {
        assert (dst.getRegisterCategory().equals((Object)AMD64.XMM));
        if (AMD64MacroAssembler.isAVX512Register(dst)) {
            AMD64Assembler.VexMoveOp.VMOVSS.emit((AMD64Assembler)this, AVXKind.AVXSize.XMM, dst, src);
        } else {
            this.movss(dst, src);
        }
    }

    public void movflt(AMD64Address dst, Register src) {
        assert (src.getRegisterCategory().equals((Object)AMD64.XMM));
        if (AMD64MacroAssembler.isAVX512Register(src)) {
            AMD64Assembler.VexMoveOp.VMOVSS.emit((AMD64Assembler)this, AVXKind.AVXSize.XMM, dst, src);
        } else {
            this.movss(dst, src);
        }
    }

    public void movdbl(Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AMD64.XMM) && src.getRegisterCategory().equals((Object)AMD64.XMM));
        if (AMD64MacroAssembler.isAVX512Register(dst) || AMD64MacroAssembler.isAVX512Register(src)) {
            AMD64Assembler.VexMoveOp.VMOVAPD.emit((AMD64Assembler)this, AVXKind.AVXSize.XMM, dst, src);
        } else {
            this.movapd(dst, src);
        }
    }

    public void movdbl(Register dst, AMD64Address src) {
        assert (dst.getRegisterCategory().equals((Object)AMD64.XMM));
        if (AMD64MacroAssembler.isAVX512Register(dst)) {
            AMD64Assembler.VexMoveOp.VMOVSD.emit((AMD64Assembler)this, AVXKind.AVXSize.XMM, dst, src);
        } else {
            this.movsd(dst, src);
        }
    }

    public void movdbl(AMD64Address dst, Register src) {
        assert (src.getRegisterCategory().equals((Object)AMD64.XMM));
        if (AMD64MacroAssembler.isAVX512Register(src)) {
            AMD64Assembler.VexMoveOp.VMOVSD.emit((AMD64Assembler)this, AVXKind.AVXSize.XMM, dst, src);
        } else {
            this.movsd(dst, src);
        }
    }

    public final void movlong(AMD64Address dst, long src) {
        if (NumUtil.isInt(src)) {
            AMD64Assembler.AMD64MIOp.MOV.emit((AMD64Assembler)this, AMD64BaseAssembler.OperandSize.QWORD, dst, (int)src);
        } else {
            AMD64Address high = new AMD64Address(dst.getBase(), dst.getIndex(), dst.getScale(), dst.getDisplacement() + 4);
            this.movl(dst, (int)(src & 0xFFFFFFFFFFFFFFFFL));
            this.movl(high, (int)(src >> 32));
        }
    }

    public final void setl(AMD64Assembler.ConditionFlag cc, Register dst) {
        this.setb(cc, dst);
        this.movzbl(dst, dst);
    }

    public final void setq(AMD64Assembler.ConditionFlag cc, Register dst) {
        this.setb(cc, dst);
        this.movzbq(dst, dst);
    }

    public final void flog(Register dest, Register value, boolean base10) {
        if (base10) {
            this.fldlg2();
        } else {
            this.fldln2();
        }
        AMD64Address tmp = this.trigPrologue(value);
        this.fyl2x();
        this.trigEpilogue(dest, tmp);
    }

    public final void fsin(Register dest, Register value) {
        AMD64Address tmp = this.trigPrologue(value);
        this.fsin();
        this.trigEpilogue(dest, tmp);
    }

    public final void fcos(Register dest, Register value) {
        AMD64Address tmp = this.trigPrologue(value);
        this.fcos();
        this.trigEpilogue(dest, tmp);
    }

    public final void ftan(Register dest, Register value) {
        AMD64Address tmp = this.trigPrologue(value);
        this.fptan();
        this.fstp(0);
        this.trigEpilogue(dest, tmp);
    }

    public final void fpop() {
        this.ffree(0);
        this.fincstp();
    }

    private AMD64Address trigPrologue(Register value) {
        assert (value.getRegisterCategory().equals((Object)AMD64.XMM));
        AMD64Address tmp = new AMD64Address(AMD64.rsp);
        this.subq(AMD64.rsp, AMD64Kind.DOUBLE.getSizeInBytes());
        this.movdbl(tmp, value);
        this.fldd(tmp);
        return tmp;
    }

    private void trigEpilogue(Register dest, AMD64Address tmp) {
        assert (dest.getRegisterCategory().equals((Object)AMD64.XMM));
        this.fstpd(tmp);
        this.movdbl(dest, tmp);
        this.addq(AMD64.rsp, AMD64Kind.DOUBLE.getSizeInBytes());
    }
}

