/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.sparc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.sparc.SPARC;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.BranchTargetOutOfBoundsException;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCInstructionCounter;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;

public abstract class SPARCAssembler
extends Assembler {
    public static final int INSTRUCTION_SIZE = 4;
    public static final int BLOCK_ZERO_LENGTH = 64;
    public static final int CCR_ICC_SHIFT = 0;
    public static final int CCR_XCC_SHIFT = 4;
    public static final int CCR_V_SHIFT = 1;
    public static final int MEMBAR_LOAD_LOAD = 1;
    public static final int MEMBAR_STORE_LOAD = 2;
    public static final int MEMBAR_LOAD_STORE = 3;
    public static final int MEMBAR_STORE_STORE = 4;
    private static final Ops[] OPS;
    private static final Op2s[] OP2S;
    private static final Op3s[][] OP3S;
    private ArrayList<Integer> delaySlotOptimizationPoints = new ArrayList(5);
    private static final int COMMUTATIVE = 1;
    private static final int BINARY = 2;
    private static final int UNARY = 4;
    private static final int VOID_IN = 8;
    public static final Bpcc BPCC;
    public static final Bpcc FBPCC;
    public static final CBCond CBCOND;
    public static final Bpr BPR;
    public static final Br BR;
    public static final Sethi SETHI;
    public static final FMOVcc FMOVSCC;
    public static final FMOVcc FMOVDCC;
    public static final MOVicc MOVICC;
    public static final OpfOp OPF;
    public static final Op3Op OP3;
    public static final SPARCOp LDST;
    public static final SPARCOp BRANCH;
    public static final SPARCOp CALL;
    private static final BitKeyIndex INDEX;
    public static final int PC_RETURN_OFFSET = 8;

    public SPARCAssembler(TargetDescription target) {
        super(target);
    }

    public static SPARCOp getSPARCOp(int inst) {
        return INDEX.find(inst);
    }

    public static boolean isCPURegister(Register ... regs) {
        for (Register reg : regs) {
            if (SPARCAssembler.isCPURegister(reg)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCPURegister(Register r) {
        return r.getRegisterCategory().equals((Object)SPARC.CPU);
    }

    public static boolean isGlobalRegister(Register r) {
        return SPARCAssembler.isCPURegister(r) && SPARC.g0.number <= r.number && r.number <= SPARC.g7.number;
    }

    public static boolean isSingleFloatRegister(Register r) {
        return r.getRegisterCategory().equals((Object)SPARC.FPUs);
    }

    public static boolean isDoubleFloatRegister(Register r) {
        return r.getRegisterCategory().equals((Object)SPARC.FPUd);
    }

    public boolean hasFeature(SPARC.CPUFeature feature) {
        return ((SPARC)this.target.arch).features.contains(feature);
    }

    public static final int simm(int x, int nbits) {
        return x & (1 << nbits) - 1;
    }

    public static final boolean isImm(int x, int nbits) {
        return SPARCAssembler.simm(x, nbits) == x;
    }

    public static long minSimm(long nbits) {
        return -(1L << (int)(nbits - 1L));
    }

    public static long maxSimm(long nbits) {
        return (1L << (int)(nbits - 1L)) - 1L;
    }

    public static boolean isSimm(long imm, int nbits) {
        return SPARCAssembler.minSimm(nbits) <= imm && imm <= SPARCAssembler.maxSimm(nbits);
    }

    public static boolean isSimm10(long imm) {
        return SPARCAssembler.isSimm(imm, 10);
    }

    public static boolean isSimm11(long imm) {
        return SPARCAssembler.isSimm(imm, 11);
    }

    public static boolean isSimm11(JavaConstant constant) {
        return constant.isNull() || SPARCAssembler.isSimm11(constant.asLong());
    }

    public static boolean isSimm5(JavaConstant constant) {
        return constant.isNull() || SPARCAssembler.isSimm(constant.asLong(), 5);
    }

    public static boolean isSimm5(long imm) {
        return SPARCAssembler.isSimm(imm, 5);
    }

    public static boolean isSimm13(int imm) {
        return SPARCAssembler.isSimm(imm, 13);
    }

    public static boolean isSimm13(JavaConstant constant) {
        long bits;
        switch (constant.getJavaKind()) {
            case Double: {
                bits = Double.doubleToRawLongBits(constant.asDouble());
                break;
            }
            case Float: {
                bits = Float.floatToRawIntBits(constant.asFloat());
                break;
            }
            case Object: {
                return constant.isNull();
            }
            default: {
                bits = constant.asLong();
            }
        }
        return constant.isNull() || SPARCAssembler.isSimm13(bits);
    }

    public static boolean isSimm13(long imm) {
        return NumUtil.isInt(imm) && SPARCAssembler.isSimm(imm, 13);
    }

    public static boolean isWordDisp30(long imm) {
        return SPARCAssembler.isSimm(imm, 32);
    }

    public static final int hi22(int x) {
        return x >>> 10;
    }

    public static final int lo10(int x) {
        return x & 0x3FF;
    }

    protected void fmt00(int a, int op2, int b) {
        assert (SPARCAssembler.isImm(a, 5) && SPARCAssembler.isImm(op2, 3) && SPARCAssembler.isImm(b, 22)) : String.format("a: 0x%x op2: 0x%x b: 0x%x", a, op2, b);
        int word = 0;
        BitSpec.op.setBits(word, 0);
        BitSpec.rd.setBits(word, a);
        BitSpec.op2.setBits(word, op2);
        BitSpec.imm22.setBits(word, b);
        this.emitInt(a << 25 | op2 << 22 | b);
    }

    private void op3(Op3s op3, Opfs opf, Register rs1, Register rs2, Register rd) {
        int b = opf.value << 5 | (rs2 == null ? 0 : rs2.encoding);
        this.fmt(op3.op.value, rd.encoding, op3.value, rs1 == null ? 0 : rs1.encoding, b);
    }

    protected void op3(Op3s op3, Register rs1, Register rs2, Register rd) {
        int b = rs2 == null ? 0 : rs2.encoding;
        int xBit = SPARCAssembler.getXBit(op3);
        this.fmt(op3.op.value, rd.encoding, op3.value, rs1 == null ? 0 : rs1.encoding, b | xBit);
    }

    protected void op3(Op3s op3, Register rs1, int simm13, Register rd) {
        assert (SPARCAssembler.isSimm13(simm13)) : simm13;
        int i = 8192;
        int simm13WithX = simm13 | SPARCAssembler.getXBit(op3);
        this.fmt(op3.op.value, rd.encoding, op3.value, rs1.encoding, i | simm13WithX & 0x1FFF);
    }

    public void insertNopAfterCBCond() {
        int pos = this.position() - 4;
        if (pos == 0) {
            return;
        }
        int inst = this.getInt(pos);
        if (CBCOND.match(inst)) {
            this.nop();
        }
    }

    protected int patchUnbound(Label label) {
        label.addPatchAt(this.position(), this);
        return 0;
    }

    public void nop() {
        this.emitInt(0x1000000);
    }

    public void sethi(int imm22, Register dst) {
        this.fmt00(dst.encoding, Op2s.Sethi.value, imm22);
    }

    public int call(int disp30) {
        assert (SPARCAssembler.isImm(disp30, 30));
        this.insertNopAfterCBCond();
        int before = this.position();
        int instr = 0x40000000;
        this.emitInt(instr |= disp30);
        return before;
    }

    public void add(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Add, rs1, rs2, rd);
    }

    public void add(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Add, rs1, simm13, rd);
    }

    public void addc(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Addc, rs1, rs2, rd);
    }

    public void addc(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Addc, rs1, simm13, rd);
    }

    public void addcc(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Addcc, rs1, rs2, rd);
    }

    public void addcc(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Addcc, rs1, simm13, rd);
    }

    public void and(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.And, rs1, rs2, rd);
    }

    public void and(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.And, rs1, simm13, rd);
    }

    public void andcc(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Andcc, rs1, rs2, rd);
    }

    public void andcc(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Andcc, rs1, simm13, rd);
    }

    public void andn(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Andn, rs1, rs2, rd);
    }

    public void andn(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Andn, rs1, simm13, rd);
    }

    public void andncc(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Andncc, rs1, rs2, rd);
    }

    public void andncc(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Andncc, rs1, simm13, rd);
    }

    public void movwtos(Register rs2, Register rd) {
        assert (SPARCAssembler.isSingleFloatRegister(rd) && SPARCAssembler.isCPURegister(rs2)) : String.format("%s %s", rs2, rd);
        this.op3(Op3s.Impdep1, Opfs.Movwtos, null, rs2, rd);
    }

    public void umulxhi(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Impdep1, Opfs.UMulxhi, rs1, rs2, rd);
    }

    public void fdtos(Register rs2, Register rd) {
        assert (SPARCAssembler.isSingleFloatRegister(rd) && SPARCAssembler.isDoubleFloatRegister(rs2)) : String.format("%s %s", rs2, rd);
        this.op3(Op3s.Fpop1, Opfs.Fdtos, null, rs2, rd);
    }

    public void movstouw(Register rs2, Register rd) {
        assert (SPARCAssembler.isSingleFloatRegister(rs2) && SPARCAssembler.isCPURegister(rd)) : String.format("%s %s", rs2, rd);
        this.op3(Op3s.Impdep1, Opfs.Movstosw, null, rs2, rd);
    }

    public void movstosw(Register rs2, Register rd) {
        assert (SPARCAssembler.isSingleFloatRegister(rs2) && SPARCAssembler.isCPURegister(rd)) : String.format("%s %s", rs2, rd);
        this.op3(Op3s.Impdep1, Opfs.Movstosw, null, rs2, rd);
    }

    public void movdtox(Register rs2, Register rd) {
        assert (SPARCAssembler.isDoubleFloatRegister(rs2) && SPARCAssembler.isCPURegister(rd)) : String.format("%s %s", rs2, rd);
        this.op3(Op3s.Impdep1, Opfs.Movdtox, null, rs2, rd);
    }

    public void movxtod(Register rs2, Register rd) {
        assert (SPARCAssembler.isCPURegister(rs2) && SPARCAssembler.isDoubleFloatRegister(rd)) : String.format("%s %s", rs2, rd);
        this.op3(Op3s.Impdep1, Opfs.Movxtod, null, rs2, rd);
    }

    public void fadds(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fadds, rs1, rs2, rd);
    }

    public void faddd(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Faddd, rs1, rs2, rd);
    }

    public void fdivs(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fdivs, rs1, rs2, rd);
    }

    public void fdivd(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fdivd, rs1, rs2, rd);
    }

    public void fmovs(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fmovs, null, rs2, rd);
    }

    public void fmovd(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fmovd, null, rs2, rd);
    }

    public void fsrc2s(Register rs2, Register rd) {
        this.op3(Op3s.Impdep1, Opfs.Fsrc2s, null, rs2, rd);
    }

    public void fsrc2d(Register rs2, Register rd) {
        this.op3(Op3s.Impdep1, Opfs.Fsrc2d, null, rs2, rd);
    }

    public void fmuls(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fmuls, rs1, rs2, rd);
    }

    public void fsmuld(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fsmuld, rs1, rs2, rd);
    }

    public void fmuld(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fmuld, rs1, rs2, rd);
    }

    public void fnegs(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fnegs, null, rs2, rd);
    }

    public void fnegd(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fnegd, null, rs2, rd);
    }

    private static int getXBit(Op3s op3) {
        switch (op3) {
            case Sllx: 
            case Srlx: 
            case Srax: {
                return 4096;
            }
        }
        return 0;
    }

    public void fstoi(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fstoi, null, rs2, rd);
    }

    public void fstox(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fstox, null, rs2, rd);
    }

    public void fdtox(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fdtox, null, rs2, rd);
    }

    public void fstod(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fstod, null, rs2, rd);
    }

    public void fdtoi(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fdtoi, null, rs2, rd);
    }

    public void fitos(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fitos, null, rs2, rd);
    }

    public void fitod(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fitod, null, rs2, rd);
    }

    public void fxtos(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fxtos, null, rs2, rd);
    }

    public void fxtod(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fxtod, null, rs2, rd);
    }

    public void fzeros(Register rd) {
        this.op3(Op3s.Impdep1, Opfs.Fzeros, null, null, rd);
    }

    public void fzerod(Register rd) {
        this.op3(Op3s.Impdep1, Opfs.Fzerod, null, null, rd);
    }

    public void flushw() {
        this.op3(Op3s.Flushw, SPARC.g0, SPARC.g0, SPARC.g0);
    }

    public void fsqrtd(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fsqrtd, null, rs2, rd);
    }

    public void fsqrts(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fsqrts, null, rs2, rd);
    }

    public void fabss(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fabss, null, rs2, rd);
    }

    public void fabsd(Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fabsd, null, rs2, rd);
    }

    public void fsubs(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fsubs, rs1, rs2, rd);
    }

    public void fsubd(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Fpop1, Opfs.Fsubd, rs1, rs2, rd);
    }

    public void fcmp(CC cc, Opfs opf, Register rs1, Register rs2) {
        int a = cc.value;
        int b = opf.value << 5 | rs2.encoding;
        this.delaySlotOptimizationPoints.add(this.position());
        this.fmt10(a, Op3s.Fpop2.value, rs1.encoding, b);
    }

    protected void fmt10(int rd, int op3, int rs1, int b) {
        this.fmt(2, rd, op3, rs1, b);
    }

    protected void fmt(int op, int rd, int op3, int rs1, int b) {
        assert (SPARCAssembler.isImm(rd, 5) && SPARCAssembler.isImm(op3, 6) && SPARCAssembler.isImm(b, 14)) : String.format("rd: 0x%x op3: 0x%x b: 0x%x", rd, op3, b);
        int instr = op << 30 | rd << 25 | op3 << 19 | rs1 << 14 | b;
        this.emitInt(instr);
    }

    public void illtrap(int const22) {
        this.fmt00(0, Op2s.Illtrap.value, const22);
    }

    public void jmpl(Register rs1, Register rs2, Register rd) {
        this.insertNopAfterCBCond();
        this.op3(Op3s.Jmpl, rs1, rs2, rd);
    }

    public int jmpl(Register rs1, int simm13, Register rd) {
        this.insertNopAfterCBCond();
        int before = this.position();
        this.op3(Op3s.Jmpl, rs1, simm13, rd);
        return before;
    }

    public void fmovdcc(ConditionFlag cond, CC cc, Register rs2, Register rd) {
        this.fmovcc(cond, cc, rs2, rd, OpfLow.Fmovdcc.value);
    }

    public void fmovscc(ConditionFlag cond, CC cc, Register rs2, Register rd) {
        this.fmovcc(cond, cc, rs2, rd, OpfLow.Fmovscc.value);
    }

    private void fmovcc(ConditionFlag cond, CC cc, Register rs2, Register rd, int opfLow) {
        int opfCC = cc.value;
        int a = opfCC << 11 | opfLow << 5 | rs2.encoding;
        this.fmt10(rd.encoding, Op3s.Fpop2.value, cond.value, a);
    }

    public void movcc(ConditionFlag conditionFlag, CC cc, Register rs2, Register rd) {
        this.movcc(conditionFlag, cc, 0, rs2.encoding, rd);
    }

    public void movcc(ConditionFlag conditionFlag, CC cc, int simm11, Register rd) {
        assert (SPARCAssembler.isSimm11(simm11));
        this.movcc(conditionFlag, cc, 1, simm11 & 0x7FF, rd);
    }

    private void movcc(ConditionFlag conditionFlag, CC cc, int i, int imm, Register rd) {
        int cc01 = 3 & cc.value;
        int cc2 = cc.isFloat ? 0 : 1;
        int a = cc2 << 4 | conditionFlag.value;
        int b = cc01 << 11 | i << 13 | imm;
        this.fmt10(rd.encoding, Op3s.Movcc.value, a, b);
    }

    public void mulx(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Mulx, rs1, rs2, rd);
    }

    public void mulx(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Mulx, rs1, simm13, rd);
    }

    public void or(Register rs1, Register rs2, Register rd) {
        assert (SPARCAssembler.isCPURegister(rs1, rs2, rd)) : String.format("%s %s %s", rs1, rs2, rd);
        this.op3(Op3s.Or, rs1, rs2, rd);
    }

    public void or(Register rs1, int simm13, Register rd) {
        assert (SPARCAssembler.isCPURegister(rs1, rd)) : String.format("%s %s", rs1, rd);
        this.op3(Op3s.Or, rs1, simm13, rd);
    }

    public void popc(Register rs2, Register rd) {
        this.op3(Op3s.Popc, SPARC.g0, rs2, rd);
    }

    public void popc(int simm13, Register rd) {
        this.op3(Op3s.Popc, SPARC.g0, simm13, rd);
    }

    public void prefetch(SPARCAddress addr, Fcn fcn) {
        Register rs1 = addr.getBase();
        if (addr.getIndex().equals((Object)Register.None)) {
            int dis = addr.getDisplacement();
            assert (SPARCAssembler.isSimm13(dis));
            this.fmt(Op3s.Prefetch.op.value, fcn.value, Op3s.Prefetch.value, rs1.encoding, 0x2000 | dis & 0x1FFF);
        } else {
            Register rs2 = addr.getIndex();
            this.fmt(Op3s.Prefetch.op.value, fcn.value, Op3s.Prefetch.value, rs1.encoding, rs2.encoding);
        }
    }

    public void rdpc(Register rd) {
        this.op3(Op3s.Rd, SPARC.g5, SPARC.g0, rd);
    }

    public void restore(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Restore, rs1, rs2, rd);
    }

    public void save(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Save, rs1, rs2, rd);
    }

    public void save(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Save, rs1, simm13, rd);
    }

    public void sdivx(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Sdivx, rs1, rs2, rd);
    }

    public void sdivx(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Sdivx, rs1, simm13, rd);
    }

    public void udivx(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Udivx, rs1, rs2, rd);
    }

    public void udivx(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Udivx, rs1, simm13, rd);
    }

    public void sll(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Sll, rs1, rs2, rd);
    }

    public void sll(Register rs1, int shcnt32, Register rd) {
        assert (SPARCAssembler.isImm(shcnt32, 5));
        this.op3(Op3s.Sll, rs1, shcnt32, rd);
    }

    public void sllx(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Sllx, rs1, rs2, rd);
    }

    public void sllx(Register rs1, int shcnt64, Register rd) {
        assert (SPARCAssembler.isImm(shcnt64, 6));
        this.op3(Op3s.Sllx, rs1, shcnt64, rd);
    }

    public void sra(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Sra, rs1, rs2, rd);
    }

    public void sra(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Sra, rs1, simm13, rd);
    }

    public void srax(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Srax, rs1, rs2, rd);
    }

    public void srax(Register rs1, int shcnt64, Register rd) {
        assert (SPARCAssembler.isImm(shcnt64, 6));
        this.op3(Op3s.Srax, rs1, shcnt64, rd);
    }

    public void srl(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Srl, rs1, rs2, rd);
    }

    public void srl(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Srl, rs1, simm13, rd);
    }

    public void srlx(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Srlx, rs1, rs2, rd);
    }

    public void srlx(Register rs1, int shcnt64, Register rd) {
        assert (SPARCAssembler.isImm(shcnt64, 6));
        this.op3(Op3s.Srlx, rs1, shcnt64, rd);
    }

    public void sub(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Sub, rs1, rs2, rd);
    }

    public void sub(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Sub, rs1, simm13, rd);
    }

    public void subcc(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Subcc, rs1, rs2, rd);
    }

    public void subcc(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Subcc, rs1, simm13, rd);
    }

    public void ta(int trap) {
        this.tcc(CC.Icc, ConditionFlag.Always, trap);
    }

    public void pause() {
        GraalError.unimplemented("The SPARC pause instruction is not yet implemented.");
    }

    public void tcc(CC cc, ConditionFlag flag, int trap) {
        assert (SPARCAssembler.isImm(trap, 8));
        int b = cc.value << 11;
        b |= 0x2000;
        this.fmt10(flag.value, Op3s.Tcc.getValue(), 0, b |= trap);
    }

    public void wrccr(Register rs1, Register rs2) {
        this.op3(Op3s.Wr, rs1, rs2, SPARC.g2);
    }

    public void wrccr(Register rs1, int simm13) {
        this.op3(Op3s.Wr, rs1, simm13, SPARC.g2);
    }

    public void xor(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Xor, rs1, rs2, rd);
    }

    public void xor(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Xor, rs1, simm13, rd);
    }

    public void xorcc(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Xorcc, rs1, rs2, rd);
    }

    public void xorcc(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Xorcc, rs1, simm13, rd);
    }

    public void xnor(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Xnor, rs1, rs2, rd);
    }

    public void xnor(Register rs1, int simm13, Register rd) {
        this.op3(Op3s.Xnor, rs1, simm13, rd);
    }

    protected void ld(Op3s op3, SPARCAddress addr, Register rd, Asi asi) {
        Register rs1 = addr.getBase();
        if (!addr.getIndex().equals((Object)Register.None)) {
            Register rs2 = addr.getIndex();
            if (asi != null) {
                int b = rs2.encoding;
                this.fmt(op3.op.value, rd.encoding, op3.value, rs1.encoding, b |= asi.value << 5);
            } else {
                this.op3(op3, rs1, rs2, rd);
            }
        } else {
            int imm = addr.getDisplacement();
            this.op3(op3, rs1, imm, rd);
        }
    }

    protected void ld(Op3s op3, SPARCAddress addr, Register rd) {
        this.ld(op3, addr, rd, null);
    }

    public void lddf(SPARCAddress src, Register dst) {
        assert (SPARCAssembler.isDoubleFloatRegister(dst)) : dst;
        this.ld(Op3s.Lddf, src, dst);
    }

    public void ldf(SPARCAddress src, Register dst) {
        assert (SPARCAssembler.isSingleFloatRegister(dst)) : dst;
        this.ld(Op3s.Ldf, src, dst);
    }

    public void lduh(SPARCAddress src, Register dst) {
        assert (SPARCAssembler.isCPURegister(dst)) : dst;
        this.ld(Op3s.Lduh, src, dst);
    }

    public void ldsh(SPARCAddress src, Register dst) {
        assert (SPARCAssembler.isCPURegister(dst)) : dst;
        this.ld(Op3s.Ldsh, src, dst);
    }

    public void ld(SPARCAddress src, Register dst, int bytes, boolean signExtend) {
        block20: {
            block18: {
                block19: {
                    if (!SPARCAssembler.isCPURegister(dst)) break block18;
                    if (!signExtend) break block19;
                    switch (bytes) {
                        case 1: {
                            this.ld(Op3s.Ldsb, src, dst);
                            break block20;
                        }
                        case 2: {
                            this.ld(Op3s.Ldsh, src, dst);
                            break block20;
                        }
                        case 4: {
                            this.ld(Op3s.Ldsw, src, dst);
                            break block20;
                        }
                        case 8: {
                            this.ld(Op3s.Ldx, src, dst);
                            break block20;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                switch (bytes) {
                    case 1: {
                        this.ld(Op3s.Ldub, src, dst);
                        break block20;
                    }
                    case 2: {
                        this.ld(Op3s.Lduh, src, dst);
                        break block20;
                    }
                    case 4: {
                        this.ld(Op3s.Lduw, src, dst);
                        break block20;
                    }
                    case 8: {
                        this.ld(Op3s.Ldx, src, dst);
                        break block20;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            if (SPARCAssembler.isDoubleFloatRegister(dst) && bytes == 8) {
                assert (!signExtend);
                this.ld(Op3s.Lddf, src, dst);
            } else if (SPARCAssembler.isSingleFloatRegister(dst) && bytes == 4) {
                assert (!signExtend);
                this.ld(Op3s.Ldf, src, dst);
            } else {
                throw new InternalError(String.format("src: %s dst: %s bytes: %d signExtend: %b", src, dst, bytes, signExtend));
            }
        }
    }

    public void st(Register src, SPARCAddress dst, int bytes) {
        block11: {
            block10: {
                if (!SPARCAssembler.isCPURegister(src)) break block10;
                switch (bytes) {
                    case 1: {
                        this.st(Op3s.Stb, src, dst);
                        break block11;
                    }
                    case 2: {
                        this.st(Op3s.Sth, src, dst);
                        break block11;
                    }
                    case 4: {
                        this.st(Op3s.Stw, src, dst);
                        break block11;
                    }
                    case 8: {
                        this.st(Op3s.Stx, src, dst);
                        break block11;
                    }
                    default: {
                        throw new InternalError(Integer.toString(bytes));
                    }
                }
            }
            if (SPARCAssembler.isDoubleFloatRegister(src) && bytes == 8) {
                this.st(Op3s.Stdf, src, dst);
            } else if (SPARCAssembler.isSingleFloatRegister(src) && bytes == 4) {
                this.st(Op3s.Stf, src, dst);
            } else {
                throw new InternalError(String.format("src: %s dst: %s bytes: %d", src, dst, bytes));
            }
        }
    }

    public void ldub(SPARCAddress src, Register dst) {
        assert (SPARCAssembler.isCPURegister(dst)) : dst;
        this.ld(Op3s.Ldub, src, dst);
    }

    public void ldsb(SPARCAddress src, Register dst) {
        assert (SPARCAssembler.isCPURegister(dst)) : dst;
        this.ld(Op3s.Ldsb, src, dst);
    }

    public void lduw(SPARCAddress src, Register dst) {
        assert (SPARCAssembler.isCPURegister(dst)) : dst;
        this.ld(Op3s.Lduw, src, dst);
    }

    public void ldsw(SPARCAddress src, Register dst) {
        assert (SPARCAssembler.isCPURegister(dst)) : dst;
        this.ld(Op3s.Ldsw, src, dst);
    }

    public void ldx(SPARCAddress src, Register dst) {
        assert (SPARCAssembler.isCPURegister(dst)) : dst;
        this.ld(Op3s.Ldx, src, dst);
    }

    public void ldxa(Register rs1, Register rs2, Register rd, Asi asi) {
        assert (SPARCAssembler.isCPURegister(rs1, rs2, rd)) : String.format("%s %s %s", rs1, rs2, rd);
        this.ld(Op3s.Ldxa, new SPARCAddress(rs1, rs2), rd, asi);
    }

    public void lduwa(Register rs1, Register rs2, Register rd, Asi asi) {
        assert (SPARCAssembler.isCPURegister(rs1, rs2, rd)) : String.format("%s %s %s", rs1, rs2, rd);
        this.ld(Op3s.Lduwa, new SPARCAddress(rs1, rs2), rd, asi);
    }

    public void stxa(Register rd, Register rs1, Register rs2, Asi asi) {
        assert (SPARCAssembler.isCPURegister(rs1, rs2, rd)) : String.format("%s %s %s", rs1, rs2, rd);
        this.ld(Op3s.Stxa, new SPARCAddress(rs1, rs2), rd, asi);
    }

    protected void st(Op3s op3, Register rs1, SPARCAddress dest) {
        this.ld(op3, dest, rs1);
    }

    public void stdf(Register rd, SPARCAddress addr) {
        assert (SPARCAssembler.isDoubleFloatRegister(rd)) : rd;
        this.st(Op3s.Stdf, rd, addr);
    }

    public void stf(Register rd, SPARCAddress addr) {
        assert (SPARCAssembler.isSingleFloatRegister(rd)) : rd;
        this.st(Op3s.Stf, rd, addr);
    }

    public void stb(Register rd, SPARCAddress addr) {
        assert (SPARCAssembler.isCPURegister(rd)) : rd;
        this.st(Op3s.Stb, rd, addr);
    }

    public void sth(Register rd, SPARCAddress addr) {
        assert (SPARCAssembler.isCPURegister(rd)) : rd;
        this.st(Op3s.Sth, rd, addr);
    }

    public void stw(Register rd, SPARCAddress addr) {
        assert (SPARCAssembler.isCPURegister(rd)) : rd;
        this.st(Op3s.Stw, rd, addr);
    }

    public void stx(Register rd, SPARCAddress addr) {
        assert (SPARCAssembler.isCPURegister(rd)) : rd;
        this.st(Op3s.Stx, rd, addr);
    }

    public void membar(int barriers) {
        this.op3(Op3s.Membar, SPARC.o7, barriers, SPARC.g0);
    }

    public void casa(Register rs1, Register rs2, Register rd, Asi asi) {
        this.ld(Op3s.Casa, new SPARCAddress(rs1, rs2), rd, asi);
    }

    public void casxa(Register rs1, Register rs2, Register rd, Asi asi) {
        this.ld(Op3s.Casxa, new SPARCAddress(rs1, rs2), rd, asi);
    }

    @Override
    public Assembler.InstructionCounter getInstructionCounter() {
        return new SPARCInstructionCounter(this);
    }

    public void patchAddImmediate(int position, int simm13) {
        int inst = this.getInt(position);
        assert (SPARCAssembler.isSimm13(simm13)) : simm13;
        assert (inst >>> 30 == 2) : String.format("0x%x", inst);
        assert ((inst >>> 18 & 0x3F) == 0) : String.format("0x%x", inst);
        assert ((inst & 0x2000) != 0) : String.format("0x%x", inst);
        inst &= 0xFFFFE000;
        this.emitInt(inst |= simm13 & 0xFFF, position);
    }

    public void fpadd32(Register rs1, Register rs2, Register rd) {
        this.op3(Op3s.Impdep1, Opfs.Fpadd32, rs1, rs2, rd);
    }

    public void peephole() {
        for (int i : this.delaySlotOptimizationPoints) {
            this.optimizeDelaySlot(i);
        }
    }

    private void optimizeDelaySlot(int i) {
        int inst;
        SPARCOp op;
        int delaySlotAbsolute = i + 4;
        int nextInst = this.getInt(delaySlotAbsolute);
        SPARCOp nextOp = SPARCAssembler.getSPARCOp(nextInst);
        if (nextOp instanceof Sethi && Sethi.isNop(nextInst) && (op = SPARCAssembler.getSPARCOp(inst = this.getInt(i))) instanceof ControlTransferOp && ((ControlTransferOp)op).hasDelaySlot() && ((ControlTransferOp)op).isAnnulable(inst)) {
            ControlTransferOp branchTargetOpBranch;
            int btDisp;
            int newDisp;
            ControlTransferOp ctOp = (ControlTransferOp)op;
            int disp = ctOp.getDisp(inst);
            int branchTargetAbsolute = i + disp * 4;
            int branchTargetInst = this.getInt(branchTargetAbsolute);
            SPARCOp branchTargetOp = SPARCAssembler.getSPARCOp(branchTargetInst);
            if (branchTargetOp instanceof Op3Op) {
                Op3s op3 = ((Op3Op)branchTargetOp).getOp3(branchTargetInst);
                if (!op3.throwsException()) {
                    inst = ctOp.setDisp(inst, disp + 1);
                    inst = ctOp.setAnnul(inst, true);
                    this.emitInt(inst, i);
                    this.emitInt(branchTargetInst, delaySlotAbsolute);
                }
            } else if (branchTargetOp instanceof ControlTransferOp && !((ControlTransferOp)branchTargetOp).isConditional(branchTargetInst) && ctOp.isValidDisp(newDisp = disp + (btDisp = (branchTargetOpBranch = (ControlTransferOp)branchTargetOp).getDisp(branchTargetInst)))) {
                int instAfter = ctOp.setDisp(inst, newDisp);
                instAfter = ctOp.setAnnul(instAfter, true);
                branchTargetInst = this.getInt(branchTargetAbsolute + 4);
                branchTargetOp = SPARCAssembler.getSPARCOp(branchTargetInst);
                if (branchTargetOp instanceof Op3Op && !((Op3Op)branchTargetOp).getOp3(branchTargetInst).throwsException()) {
                    this.emitInt(instAfter, i);
                    this.emitInt(branchTargetInst, delaySlotAbsolute);
                }
            }
        }
    }

    static {
        int n;
        Ops[] ops = Ops.values();
        OPS = new Ops[ops.length];
        Ops[] opsArray = ops;
        int n2 = opsArray.length;
        for (n = 0; n < n2; ++n) {
            Ops op;
            SPARCAssembler.OPS[((Ops)op).value] = op = opsArray[n];
        }
        Op2s[] op2s = Op2s.values();
        OP2S = new Op2s[op2s.length];
        Enum[] enumArray = op2s;
        n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Op2s op2s2;
            SPARCAssembler.OP2S[((Op2s)op2s2).value] = op2s2 = enumArray[i];
        }
        OP3S = new Op3s[2][64];
        for (Enum enum_ : Op3s.values()) {
            if (((Op3s)enum_).value >= 64) {
                throw new RuntimeException("Error " + enum_ + " " + ((Op3s)enum_).value);
            }
            SPARCAssembler.OP3S[((Ops)((Op3s)enum_).op).value & 1][((Op3s)enum_).value] = enum_;
        }
        BPCC = new Bpcc(Op2s.Bp);
        FBPCC = new Bpcc(Op2s.Fbp);
        CBCOND = new CBCond();
        BPR = new Bpr();
        BR = new Br();
        SETHI = new Sethi();
        FMOVSCC = new FMOVcc(OpfLow.Fmovscc);
        FMOVDCC = new FMOVcc(OpfLow.Fmovdcc);
        MOVICC = new MOVicc();
        OPF = new OpfOp();
        OP3 = new Op3Op();
        LDST = new SPARCOp(Ops.LdstOp);
        BRANCH = new SPARCOp(Ops.BranchOp);
        CALL = new SPARCOp(Ops.CallOp);
        INDEX = new BitKeyIndex(BitSpec.op);
        for (SPARCOp op : SPARCOp.OPS) {
            SPARCAssembler.INDEX.addOp(op.getKeys(), op);
        }
    }

    public static final class OpfOp
    extends SPARCOp {
        private BitKey[] op3Keys;

        public OpfOp(BitKey ... op3Keys) {
            super(Ops.ArithOp);
            this.op3Keys = op3Keys;
        }

        public OpfOp() {
            this(new BitKey(BitSpec.op3, Op3s.Fpop1.value), new BitKey(BitSpec.op3, Op3s.Fpop2.value), new BitKey(BitSpec.op3, Op3s.Impdep1.value), new BitKey(BitSpec.op3, Op3s.Impdep2.value));
        }

        public static void emit(SPARCMacroAssembler masm, Opfs opf, Register rs1, Register rs2, Register rd) {
            int instruction = OpfOp.setBits(0, opf, rs1, rs2);
            instruction = BitSpec.rd.setBits(instruction, rd.encoding);
            instruction = BitSpec.i.setBits(instruction, 0);
            masm.emitInt(instruction);
        }

        public static void emitFcmp(SPARCMacroAssembler masm, Opfs opf, CC cc, Register rs1, Register rs2) {
            assert (opf.equals((Object)Opfs.Fcmpd) || opf.equals((Object)Opfs.Fcmps)) : opf;
            int instruction = OpfOp.setBits(0, opf, rs1, rs2);
            instruction = BitSpec.fcc.setBits(instruction, cc.value);
            masm.emitInt(instruction);
        }

        private static int setBits(int instruction, Opfs opf, Register rs1, Register rs2) {
            int tmp = BitSpec.op.setBits(instruction, opf.op3.op.value);
            tmp = BitSpec.op3.setBits(tmp, opf.op3.value);
            tmp = BitSpec.opf.setBits(tmp, opf.value);
            tmp = BitSpec.rs1.setBits(tmp, rs1.encoding);
            return BitSpec.rs2.setBits(tmp, rs2.encoding);
        }

        @Override
        protected List<BitKey[]> getKeys() {
            List<BitKey[]> keys = super.getKeys();
            keys.add(this.op3Keys);
            return keys;
        }
    }

    public static final class FMOVcc
    extends SPARCOp
    implements CMOV {
        private OpfLow opfLow;

        public FMOVcc(OpfLow opfLow) {
            super(Ops.ArithOp);
            this.opfLow = opfLow;
        }

        @Override
        public void emit(SPARCMacroAssembler masm, ConditionFlag condition, CC cc, Register rs2, Register rd) {
            int inst = this.setBits(0);
            inst = BitSpec.rd.setBits(inst, rd.encoding());
            inst = BitSpec.op3.setBits(inst, this.opfLow.op3.value);
            inst = BitSpec.opfCond.setBits(inst, condition.value);
            inst = BitSpec.opfCC.setBits(inst, cc.value);
            inst = BitSpec.opfLow.setBits(inst, this.opfLow.value);
            inst = BitSpec.rs2.setBits(inst, rs2.encoding());
            masm.emitInt(inst);
        }

        @Override
        public void emit(SPARCMacroAssembler masm, ConditionFlag condition, CC cc, int simm11, Register rd) {
            throw new IllegalArgumentException("FMOVCC cannot be used with immediate value");
        }

        @Override
        protected List<BitKey[]> getKeys() {
            List<BitKey[]> keys = super.getKeys();
            keys.add(new BitKey[]{new BitKey(BitSpec.op3, this.opfLow.op3.value)});
            keys.add(new BitKey[]{new BitKey(BitSpec.opfLow, this.opfLow.value)});
            return keys;
        }
    }

    public static final class MOVicc
    extends SPARCOp
    implements CMOV {
        private static final Op3s op3 = Op3s.Movcc;

        public MOVicc() {
            super(Ops.ArithOp);
        }

        @Override
        public void emit(SPARCMacroAssembler masm, ConditionFlag condition, CC cc, Register rs2, Register rd) {
            int inst = this.setBits(0, condition, cc, rd);
            inst = BitSpec.rs2.setBits(inst, rs2.encoding());
            masm.emitInt(inst);
        }

        @Override
        public void emit(SPARCMacroAssembler masm, ConditionFlag condition, CC cc, int simm11, Register rd) {
            int inst = this.setBits(0, condition, cc, rd);
            inst = BitSpec.i.setBits(inst, 1);
            inst = BitSpec.simm11.setBits(inst, simm11);
            masm.emitInt(inst);
        }

        protected int setBits(int word, ConditionFlag condition, CC cc, Register rd) {
            int inst = super.setBits(word);
            inst = BitSpec.rd.setBits(inst, rd.encoding());
            inst = BitSpec.op3.setBits(inst, op3.value);
            inst = BitSpec.movccCond.setBits(inst, condition.value);
            inst = BitSpec.movccLo.setBits(inst, cc.value);
            return BitSpec.movccHi.setBits(inst, cc.isFloat ? 0 : 1);
        }

        @Override
        protected List<BitKey[]> getKeys() {
            List<BitKey[]> keys = super.getKeys();
            keys.add(new BitKey[]{new BitKey(BitSpec.op3, op3.value)});
            return keys;
        }
    }

    public static interface CMOV {
        public void emit(SPARCMacroAssembler var1, ConditionFlag var2, CC var3, Register var4, Register var5);

        public void emit(SPARCMacroAssembler var1, ConditionFlag var2, CC var3, int var4, Register var5);
    }

    public static final class Op3Op
    extends SPARCOp {
        public Op3Op() {
            super(Ops.ArithOp);
        }

        public Op3s getOp3(int inst) {
            assert (this.match(inst));
            return OP3S[Ops.ArithOp.value & 1][BitSpec.op3.getBits(inst)];
        }

        public static void emit(SPARCMacroAssembler masm, Op3s opcode, Register rs1, Register rs2, Register rd) {
            int instruction = Op3Op.setBits(0, opcode, rs1, rd);
            instruction = BitSpec.rs2.setBits(instruction, rs2.encoding);
            instruction = BitSpec.i.setBits(instruction, 0);
            masm.emitInt(instruction);
        }

        public static void emit(SPARCMacroAssembler masm, Op3s opcode, Register rs1, int simm13, Register rd) {
            BitSpec immediateSpec;
            int instruction = Op3Op.setBits(0, opcode, rs1, rd);
            instruction = BitSpec.i.setBits(instruction, 1);
            switch (opcode) {
                case Sllx: 
                case Srlx: 
                case Srax: {
                    immediateSpec = BitSpec.shcnt64;
                    break;
                }
                case Sll: 
                case Srl: 
                case Sra: {
                    immediateSpec = BitSpec.shcnt32;
                    break;
                }
                default: {
                    immediateSpec = BitSpec.simm13;
                }
            }
            instruction = immediateSpec.setBits(instruction, simm13);
            masm.emitInt(instruction);
        }

        private static int setBits(int instruction, Op3s op3, Register rs1, Register rd) {
            assert (op3.op.equals((Object)Ops.ArithOp));
            int tmp = BitSpec.op3.setBits(instruction, op3.value);
            switch (op3) {
                case Sllx: 
                case Srlx: 
                case Srax: {
                    tmp = BitSpec.x.setBits(tmp, 1);
                }
            }
            tmp = BitSpec.op.setBits(tmp, op3.op.value);
            tmp = BitSpec.rd.setBits(tmp, rd.encoding);
            return BitSpec.rs1.setBits(tmp, rs1.encoding);
        }
    }

    public static final class Sethi
    extends Op2Op {
        public Sethi() {
            super(Ops.BranchOp, Op2s.Sethi);
        }

        public static Register getRS1(int word) {
            int regNum = BitSpec.rs1.getBits(word);
            return SPARC.cpuRegisters.get(regNum);
        }

        public static int getImm22(int word) {
            return BitSpec.imm22.getBits(word);
        }

        public static boolean isNop(int inst) {
            return Sethi.getRS1(inst).equals((Object)SPARC.g0) && Sethi.getImm22(inst) == 0;
        }
    }

    public static class Op2Op
    extends SPARCOp {
        private final Op2s op2;
        private final BitKey op2Key;

        public Op2Op(Ops op, Op2s op2) {
            super(op);
            this.op2 = op2;
            this.op2Key = new BitKey(BitSpec.op2, op2.value);
        }

        @Override
        protected int setBits(int word) {
            int result = super.setBits(word);
            return BitSpec.op2.setBits(result, this.op2.value);
        }

        @Override
        protected List<BitKey[]> getKeys() {
            List<BitKey[]> keys = super.getKeys();
            keys.add(new BitKey[]{this.op2Key});
            return keys;
        }
    }

    public static final class CBCond
    extends ControlTransferOp {
        private static final BitKey CBCOND_KEY = new BitKey(BitSpec.access$2200(), 1);

        private CBCond() {
            super(Ops.BranchOp, Op2s.Bpr, false, BitSpec.d10);
        }

        @Override
        protected List<BitKey[]> getKeys() {
            List<BitKey[]> keys = super.getKeys();
            keys.add(new BitKey[]{CBCOND_KEY});
            return keys;
        }

        public void emit(SPARCMacroAssembler masm, ConditionFlag cf, boolean cc2, Register rs1, Register rs2, Label lab) {
            int inst = this.setBits(0, cf, cc2, rs1);
            inst = BitSpec.rs2.setBits(inst, rs2.encoding);
            inst = BitSpec.i.setBits(inst, 0);
            masm.insertNopAfterCBCond();
            this.emit(masm, lab, inst);
        }

        public void emit(SPARCMacroAssembler masm, ConditionFlag cf, boolean cc2, Register rs1, int simm5, Label lab) {
            int inst = this.setBits(0, cf, cc2, rs1);
            inst = BitSpec.simm5.setBits(inst, simm5);
            inst = BitSpec.i.setBits(inst, 1);
            this.emit(masm, lab, inst);
        }

        private void emit(SPARCMacroAssembler masm, Label lab, int baseInst) {
            int inst = baseInst;
            masm.insertNopAfterCBCond();
            masm.emitInt(this.setDisp(inst, masm, lab));
        }

        private int setBits(int base, ConditionFlag cf, boolean cc2, Register rs1) {
            int inst = super.setBits(base);
            inst = BitSpec.rs1.setBits(inst, rs1.encoding);
            inst = BitSpec.cc2.setBits(inst, cc2 ? 1 : 0);
            inst = BitSpec.c.setBits(inst, cf.value);
            return BitSpec.cbcond.setBits(inst, 1);
        }

        @Override
        public boolean isAnnulable(int inst) {
            return false;
        }

        @Override
        public boolean isConditional(int inst) {
            return true;
        }
    }

    public static final class Bpr
    extends ControlTransferOp {
        private static final BitKey CBCOND_KEY = new BitKey(BitSpec.access$2200(), 0);

        public Bpr() {
            super(Ops.BranchOp, Op2s.Bpr, true, BitSpec.d16);
        }

        public void emit(SPARCMacroAssembler masm, RCondition rcond, Annul a, BranchPredict p, Register rs1, Label lab) {
            int inst = this.setBits(0);
            inst = BitSpec.rcond.setBits(inst, rcond.value);
            inst = BitSpec.a.setBits(inst, a.flag);
            inst = BitSpec.p.setBits(inst, p.flag);
            inst = BitSpec.rs1.setBits(inst, rs1.encoding);
            masm.insertNopAfterCBCond();
            masm.emitInt(this.setDisp(inst, masm, lab));
        }

        @Override
        protected List<BitKey[]> getKeys() {
            List<BitKey[]> keys = super.getKeys();
            keys.add(new BitKey[]{CBCOND_KEY});
            return keys;
        }

        @Override
        public boolean isAnnulable(int inst) {
            return this.isConditional(inst);
        }

        @Override
        public boolean isConditional(int inst) {
            int cond = BitSpec.cond.getBits(inst);
            return cond != ConditionFlag.Always.value && cond != ConditionFlag.Never.value;
        }
    }

    public static final class Br
    extends ControlTransferOp {
        public Br() {
            super(Ops.BranchOp, Op2s.Br, true, BitSpec.disp22);
        }

        @Override
        public boolean isAnnulable(int inst) {
            return this.isConditional(inst);
        }

        @Override
        public boolean isConditional(int inst) {
            int cond = BitSpec.cond.getBits(inst);
            return cond != ConditionFlag.Always.value && cond != ConditionFlag.Never.value;
        }

        public void emit(SPARCMacroAssembler masm, ConditionFlag cond, Annul a, Label lab) {
            int inst = this.setBits(0);
            inst = BitSpec.cond.setBits(inst, cond.value);
            inst = BitSpec.a.setBits(inst, a.flag);
            masm.insertNopAfterCBCond();
            masm.emitInt(this.setDisp(inst, masm, lab));
        }
    }

    public static final class Bpcc
    extends ControlTransferOp {
        public Bpcc(Op2s op2) {
            super(Ops.BranchOp, op2, true, BitSpec.disp19);
        }

        public void emit(SPARCMacroAssembler masm, CC cc, ConditionFlag cf, Annul annul, BranchPredict p, Label lab) {
            int inst = this.setBits(0);
            inst = BitSpec.a.setBits(inst, annul.flag);
            inst = BitSpec.cond.setBits(inst, cf.value);
            inst = BitSpec.cc.setBits(inst, cc.value);
            inst = BitSpec.p.setBits(inst, p.flag);
            masm.insertNopAfterCBCond();
            masm.emitInt(this.setDisp(inst, masm, lab));
        }

        @Override
        public boolean isAnnulable(int inst) {
            return this.isConditional(inst);
        }

        @Override
        public boolean isConditional(int inst) {
            int cond = BitSpec.cond.getBits(inst);
            return cond != ConditionFlag.Always.value && cond != ConditionFlag.Never.value;
        }
    }

    public static abstract class ControlTransferOp
    extends SPARCOp {
        private final Op2s op2;
        private final boolean delaySlot;
        private final BitSpec disp;
        private final BitKey[] op2Key;

        private ControlTransferOp(Ops op, Op2s op2, boolean delaySlot, BitSpec disp) {
            super(op);
            this.op2 = op2;
            this.delaySlot = delaySlot;
            this.disp = disp;
            this.op2Key = new BitKey[]{new BitKey(BitSpec.op2, op2.value)};
        }

        public boolean hasDelaySlot() {
            return this.delaySlot;
        }

        @Override
        protected int setBits(int word) {
            return BitSpec.op2.setBits(super.setBits(word), this.op2.value);
        }

        protected int setDisp(int inst, SPARCMacroAssembler masm, Label lab) {
            if (lab.isBound()) {
                int d = (lab.position() - masm.position()) / 4;
                return this.setDisp(inst, d);
            }
            masm.patchUnbound(lab);
            return inst;
        }

        public int setDisp(int inst, int d) {
            assert (this.match(inst));
            if (!this.isValidDisp(d)) {
                throw new BranchTargetOutOfBoundsException(true, "Too large displacement 0x%x in field %s in instruction %s", d, this.disp, this);
            }
            return this.disp.setBits(inst, d);
        }

        public boolean isValidDisp(int d) {
            return this.disp.valueFits(d);
        }

        public int setAnnul(int inst, boolean a) {
            return BitSpec.a.setBits(inst, a ? 1 : 0);
        }

        @Override
        protected List<BitKey[]> getKeys() {
            List<BitKey[]> keys = super.getKeys();
            keys.add(this.op2Key);
            return keys;
        }

        public int getDisp(int inst) {
            return this.disp.getBits(inst);
        }

        public abstract boolean isAnnulable(int var1);

        public abstract boolean isConditional(int var1);
    }

    public static class SPARCOp {
        private final Ops op;
        private final BitKey opKey;
        private List<BitKey[]> keyFields;
        private static final List<SPARCOp> OPS = new ArrayList<SPARCOp>();

        public SPARCOp(Ops op) {
            this.op = op;
            this.opKey = new BitKey(BitSpec.op, op.value);
            OPS.add(this);
        }

        protected int setBits(int word) {
            return BitSpec.op.setBits(word, this.op.value);
        }

        public boolean match(int inst) {
            for (BitKey[] keys : this.keyFields) {
                for (BitKey k : keys) {
                    if (k.spec.getBits(inst) == k.value) continue;
                    return false;
                }
            }
            return true;
        }

        protected List<BitKey[]> getKeys() {
            if (this.keyFields == null) {
                this.keyFields = new ArrayList<BitKey[]>(4);
                this.keyFields.add(new BitKey[]{this.opKey});
            }
            return this.keyFields;
        }

        public Ops getOp(int inst) {
            return OPS[BitSpec.op.getBits(inst)];
        }

        public String toString() {
            String name = this.getClass().getName();
            name = name.substring(name.lastIndexOf(".") + 1);
            return name + "[op: " + (Object)((Object)this.op) + "]";
        }
    }

    public static final class BitKeyIndex {
        private final BitSpec spec;
        private final Map<Integer, BitKeyIndex> nodes;
        private SPARCOp op;

        public BitKeyIndex(SPARCOp op) {
            assert (op != null);
            this.op = op;
            this.nodes = null;
            this.spec = null;
        }

        public BitKeyIndex(BitSpec spec) {
            assert (spec != null);
            this.op = null;
            this.nodes = new HashMap<Integer, BitKeyIndex>(4);
            this.spec = spec;
        }

        private void addOp(List<BitKey[]> keys, SPARCOp operation) {
            BitKey[] firstKeys;
            assert (keys.size() > 0);
            for (BitKey first : firstKeys = keys.get(0)) {
                BitKeyIndex node;
                assert (first.spec.equals(this.spec)) : BitKey.access$500(first) + " " + this.spec;
                if (keys.size() == 1) {
                    if (this.nodes.containsKey(first.value)) {
                        node = this.nodes.get(first.value);
                        assert (node.op == null) : node + " " + keys;
                        node.op = operation;
                    } else {
                        assert (!this.nodes.containsKey(first.value)) : "Index must be unique. Existing key: " + this.nodes.get(BitKey.access$600(first));
                        node = new BitKeyIndex(operation);
                    }
                } else {
                    node = this.nodes.get(first.value);
                    BitKey[] next = keys.get(1);
                    if (node == null) {
                        for (int i = 1; i < next.length; ++i) {
                            assert (next[i - 1].spec.equals(next[i].spec)) : "All spec on this node must equal";
                        }
                        node = new BitKeyIndex(next[0].spec);
                    }
                    node.addOp(keys.subList(1, keys.size()), operation);
                }
                this.nodes.put(first.value, node);
            }
        }

        public SPARCOp find(int inst) {
            if (this.nodes != null) {
                int key = this.spec.getBits(inst);
                BitKeyIndex sub = this.nodes.get(key);
                if (sub == null) {
                    if (this.op != null) {
                        return this.op;
                    }
                    throw new RuntimeException(String.format("%s 0x%x, 0x%x %s", this.spec, inst, key, this.nodes));
                }
                return sub.find(inst);
            }
            return this.op;
        }

        public String toString() {
            return this.op == null ? this.spec + ": " + this.nodes : this.op.toString();
        }
    }

    public static class BitKey {
        private final BitSpec spec;
        private final int value;

        public BitKey(BitSpec spec, int value) {
            this.spec = spec;
            this.value = value;
        }

        public String toString() {
            return String.format("BitKey %s=%s", this.spec, this.value);
        }
    }

    public static final class CompositeBitSpec
    extends BitSpec {
        private final BitSpec left;
        private final int leftWidth;
        private final BitSpec right;
        private final int rightWidth;
        private final int width;

        public CompositeBitSpec(BitSpec left, BitSpec right) {
            super(left.isSignExtend());
            assert (!right.isSignExtend()) : String.format("Right field %s must not be sign extended", right);
            this.left = left;
            this.leftWidth = left.getWidth();
            this.right = right;
            this.rightWidth = right.getWidth();
            this.width = this.leftWidth + this.rightWidth;
        }

        @Override
        public int getBits(int word) {
            int l = this.left.getBits(word);
            int r = this.right.getBits(word);
            return l << this.rightWidth | r;
        }

        @Override
        public int setBits(int word, int value) {
            int l = this.leftBits(value);
            int r = this.rightBits(value);
            return this.left.setBits(this.right.setBits(word, r), l);
        }

        private int leftBits(int value) {
            return CompositeBitSpec.getBits(value, this.width - 1, this.rightWidth, this.signExtend);
        }

        private int rightBits(int value) {
            return CompositeBitSpec.getBits(value, this.rightWidth - 1, 0, false);
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        public String toString() {
            return String.format("CompositeBitSpec[%s, %s]", this.left, this.right);
        }

        @Override
        public boolean valueFits(int value) {
            int l = this.leftBits(value);
            int r = this.rightBits(value);
            return this.left.valueFits(l) && this.right.valueFits(r);
        }

        private static int getBits(int inst, int hiBit, int lowBit, boolean signExtended) {
            int shifted = inst >> lowBit;
            if (signExtended) {
                return shifted;
            }
            return shifted & (1 << hiBit - lowBit + 1) - 1;
        }
    }

    public static final class ContinousBitSpec
    extends BitSpec {
        private final int hiBit;
        private final int lowBit;
        private final int width;
        private final int mask;
        private final String name;

        public ContinousBitSpec(int hiBit, int lowBit, String name) {
            this(hiBit, lowBit, false, name);
        }

        public ContinousBitSpec(int hiBit, int lowBit, boolean signExt, String name) {
            super(signExt);
            this.hiBit = hiBit;
            this.lowBit = lowBit;
            this.width = hiBit - lowBit + 1;
            this.mask = (1 << this.width) - 1 << lowBit;
            this.name = name;
        }

        @Override
        public int setBits(int word, int value) {
            assert (this.valueFits(value)) : String.format("Value 0x%x for field %s does not fit.", value, this);
            return word & ~this.mask | value << this.lowBit & this.mask;
        }

        @Override
        public int getBits(int word) {
            if (this.signExtend) {
                return (word & this.mask) << 31 - this.hiBit >> 32 - this.width;
            }
            return (word & this.mask) >>> this.lowBit;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        public String toString() {
            return String.format("%s [%d:%d]", this.name, this.hiBit, this.lowBit);
        }

        @Override
        public boolean valueFits(int value) {
            if (this.signExtend) {
                return SPARCAssembler.isSimm(value, this.getWidth());
            }
            return SPARCAssembler.isImm(value, this.getWidth());
        }
    }

    public static abstract class BitSpec {
        private static final BitSpec op = new ContinousBitSpec(31, 30, "op");
        private static final BitSpec op2 = new ContinousBitSpec(24, 22, "op2");
        private static final BitSpec op3 = new ContinousBitSpec(24, 19, "op3");
        private static final BitSpec opf = new ContinousBitSpec(13, 5, "opf");
        private static final BitSpec opfLow = new ContinousBitSpec(10, 5, "opfLow");
        private static final BitSpec opfCC = new ContinousBitSpec(13, 11, "opfCC");
        private static final BitSpec opfCond = new ContinousBitSpec(17, 14, "opfCond");
        private static final BitSpec rd = new ContinousBitSpec(29, 25, "rd");
        private static final BitSpec rs1 = new ContinousBitSpec(18, 14, "rs1");
        private static final BitSpec rs2 = new ContinousBitSpec(4, 0, "rs2");
        private static final BitSpec simm13 = new ContinousBitSpec(12, 0, true, "simm13");
        private static final BitSpec shcnt32 = new ContinousBitSpec(4, 0, "shcnt32");
        private static final BitSpec shcnt64 = new ContinousBitSpec(5, 0, "shcnt64");
        private static final BitSpec imm22 = new ContinousBitSpec(21, 0, "imm22");
        private static final BitSpec immAsi = new ContinousBitSpec(12, 5, "immASI");
        private static final BitSpec i = new ContinousBitSpec(13, 13, "i");
        private static final BitSpec disp19 = new ContinousBitSpec(18, 0, true, "disp19");
        private static final BitSpec disp22 = new ContinousBitSpec(21, 0, true, "disp22");
        private static final BitSpec disp30 = new ContinousBitSpec(29, 0, true, "disp30");
        private static final BitSpec a = new ContinousBitSpec(29, 29, "a");
        private static final BitSpec p = new ContinousBitSpec(19, 19, "p");
        private static final BitSpec x = new ContinousBitSpec(12, 12, "x");
        private static final BitSpec cond = new ContinousBitSpec(28, 25, "cond");
        private static final BitSpec rcond = new ContinousBitSpec(27, 25, "rcond");
        private static final BitSpec cc = new ContinousBitSpec(21, 20, "cc");
        private static final BitSpec fcc = new ContinousBitSpec(26, 25, "cc");
        private static final BitSpec d16lo = new ContinousBitSpec(13, 0, "d16lo");
        private static final BitSpec d16hi = new ContinousBitSpec(21, 20, true, "d16hi");
        private static final BitSpec d16 = new CompositeBitSpec(d16hi, d16lo);
        private static final BitSpec movccLo = new ContinousBitSpec(12, 11, "cc_lo");
        private static final BitSpec movccHi = new ContinousBitSpec(18, 18, "cc_hi");
        private static final BitSpec movccCond = new ContinousBitSpec(17, 14, "cond");
        private static final BitSpec simm11 = new ContinousBitSpec(10, 0, true, "simm11");
        private static final BitSpec cLo = new ContinousBitSpec(27, 25, "cLo");
        private static final BitSpec cHi = new ContinousBitSpec(29, 29, "cHi");
        private static final BitSpec c = new CompositeBitSpec(cHi, cLo);
        private static final BitSpec cbcond = new ContinousBitSpec(28, 28, "cbcond");
        private static final BitSpec cc2 = new ContinousBitSpec(21, 21, "cc2");
        private static final BitSpec d10Lo = new ContinousBitSpec(12, 5, "d10Lo");
        private static final BitSpec d10Hi = new ContinousBitSpec(20, 19, true, "d10Hi");
        private static final BitSpec d10 = new CompositeBitSpec(d10Hi, d10Lo);
        private static final BitSpec simm5 = new ContinousBitSpec(4, 0, true, "simm5");
        protected final boolean signExtend;

        public BitSpec(boolean signExtend) {
            this.signExtend = signExtend;
        }

        public final boolean isSignExtend() {
            return this.signExtend;
        }

        public abstract int setBits(int var1, int var2);

        public abstract int getBits(int var1);

        public abstract int getWidth();

        public abstract boolean valueFits(int var1);
    }

    public static enum Fcn {
        SeveralWritesAndPossiblyReads(2),
        SeveralReadsWeak(0),
        OneRead(1),
        OneWrite(3),
        Page(4),
        NearestUnifiedCache(17),
        SeveralReadsStrong(20),
        OneReadStrong(21),
        SeveralWritesAndPossiblyReadsStrong(22),
        OneWriteStrong(23);

        private final int value;

        private Fcn(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Asi {
        INVALID(-1),
        ASI_PRIMARY(128),
        ASI_PRIMARY_NOFAULT(130),
        ASI_PRIMARY_LITTLE(136),
        ASI_ST_BLKINIT_PRIMARY(226),
        ASI_ST_BLKINIT_MRU_PRIMARY(242);

        private final int value;

        private Asi(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isValid() {
            return this.value != INVALID.getValue();
        }
    }

    public static enum RCondition {
        Rc_z(1, "rc_z"),
        Rc_lez(2, "rc_lez"),
        Rc_lz(3, "rc_lz"),
        Rc_nz(5, "rc_nz"),
        Rc_gz(6, "rc_gz"),
        Rc_gez(7, "rc_gez"),
        Rc_last(Rc_gez.getValue(), "rc_last");

        private final int value;
        private final String operator;

        private RCondition(int value, String op) {
            this.value = value;
            this.operator = op;
        }

        public int getValue() {
            return this.value;
        }

        public String getOperator() {
            return this.operator;
        }
    }

    public static enum ConditionFlag {
        F_Never(0, "f_never"),
        F_NotEqual(1, "f_notEqual"),
        F_LessOrGreater(2, "f_lessOrGreater"),
        F_UnorderedOrLess(3, "f_unorderedOrLess"),
        F_Less(4, "f_less"),
        F_UnorderedOrGreater(5, "f_unorderedOrGreater"),
        F_Greater(6, "f_greater"),
        F_Unordered(7, "f_unordered"),
        F_Always(8, "f_always"),
        F_Equal(9, "f_equal"),
        F_UnorderedOrEqual(10, "f_unorderedOrEqual"),
        F_GreaterOrEqual(11, "f_greaterOrEqual"),
        F_UnorderedGreaterOrEqual(12, "f_unorderedGreaterOrEqual"),
        F_LessOrEqual(13, "f_lessOrEqual"),
        F_UnorderedOrLessOrEqual(14, "f_unorderedOrLessOrEqual"),
        F_Ordered(15, "f_ordered"),
        Never(0, "never"),
        Equal(1, "equal", true),
        Zero(1, "zero"),
        LessEqual(2, "lessEqual", true),
        Less(3, "less", true),
        LessEqualUnsigned(4, "lessEqualUnsigned", true),
        LessUnsigned(5, "lessUnsigned", true),
        CarrySet(5, "carrySet"),
        Negative(6, "negative", true),
        OverflowSet(7, "overflowSet", true),
        Always(8, "always"),
        NotEqual(9, "notEqual", true),
        NotZero(9, "notZero"),
        Greater(10, "greater", true),
        GreaterEqual(11, "greaterEqual", true),
        GreaterUnsigned(12, "greaterUnsigned", true),
        GreaterEqualUnsigned(13, "greaterEqualUnsigned", true),
        CarryClear(13, "carryClear"),
        Positive(14, "positive", true),
        OverflowClear(15, "overflowClear", true);

        private final int value;
        private final String operator;
        private boolean forCBcond = false;

        private ConditionFlag(int value, String op) {
            this(value, op, false);
        }

        private ConditionFlag(int value, String op, boolean cbcond) {
            this.value = value;
            this.operator = op;
            this.forCBcond = cbcond;
        }

        public boolean isCBCond() {
            return this.forCBcond;
        }

        public int getValue() {
            return this.value;
        }

        public String getOperator() {
            return this.operator;
        }

        public ConditionFlag negate() {
            switch (this) {
                case F_Never: {
                    return F_Always;
                }
                case F_Always: {
                    return F_Never;
                }
                case F_NotEqual: {
                    return F_Equal;
                }
                case F_Equal: {
                    return F_NotEqual;
                }
                case F_LessOrGreater: {
                    return F_UnorderedOrEqual;
                }
                case F_UnorderedOrEqual: {
                    return F_LessOrGreater;
                }
                case F_Less: {
                    return F_UnorderedGreaterOrEqual;
                }
                case F_UnorderedGreaterOrEqual: {
                    return F_Less;
                }
                case F_LessOrEqual: {
                    return F_UnorderedOrGreater;
                }
                case F_UnorderedOrGreater: {
                    return F_LessOrEqual;
                }
                case F_Greater: {
                    return F_UnorderedOrLessOrEqual;
                }
                case F_UnorderedOrLessOrEqual: {
                    return F_Greater;
                }
                case F_GreaterOrEqual: {
                    return F_UnorderedOrLess;
                }
                case F_UnorderedOrLess: {
                    return F_GreaterOrEqual;
                }
                case F_Unordered: {
                    return F_Ordered;
                }
                case F_Ordered: {
                    return F_Unordered;
                }
                case Never: {
                    return Always;
                }
                case Always: {
                    return Never;
                }
                case Equal: {
                    return NotEqual;
                }
                case NotEqual: {
                    return Equal;
                }
                case Zero: {
                    return NotZero;
                }
                case NotZero: {
                    return Zero;
                }
                case LessEqual: {
                    return Greater;
                }
                case Greater: {
                    return LessEqual;
                }
                case Less: {
                    return GreaterEqual;
                }
                case GreaterEqual: {
                    return Less;
                }
                case LessEqualUnsigned: {
                    return GreaterUnsigned;
                }
                case GreaterUnsigned: {
                    return LessEqualUnsigned;
                }
                case LessUnsigned: {
                    return GreaterEqualUnsigned;
                }
                case GreaterEqualUnsigned: {
                    return LessUnsigned;
                }
                case CarrySet: {
                    return CarryClear;
                }
                case CarryClear: {
                    return CarrySet;
                }
                case Negative: {
                    return Positive;
                }
                case Positive: {
                    return Negative;
                }
                case OverflowSet: {
                    return OverflowClear;
                }
                case OverflowClear: {
                    return OverflowSet;
                }
            }
            throw new InternalError();
        }

        public ConditionFlag mirror() {
            switch (this) {
                case F_Less: {
                    return F_Greater;
                }
                case F_Greater: {
                    return F_Less;
                }
                case F_LessOrEqual: {
                    return F_GreaterOrEqual;
                }
                case F_UnorderedGreaterOrEqual: {
                    return F_UnorderedOrLessOrEqual;
                }
                case F_UnorderedOrGreater: {
                    return F_UnorderedOrLess;
                }
                case F_UnorderedOrLessOrEqual: {
                    return F_UnorderedGreaterOrEqual;
                }
                case F_GreaterOrEqual: {
                    return F_LessOrEqual;
                }
                case F_UnorderedOrLess: {
                    return F_UnorderedOrGreater;
                }
                case LessEqual: {
                    return GreaterEqual;
                }
                case Greater: {
                    return Less;
                }
                case Less: {
                    return Greater;
                }
                case GreaterEqual: {
                    return LessEqual;
                }
                case LessEqualUnsigned: {
                    return GreaterEqualUnsigned;
                }
                case GreaterUnsigned: {
                    return LessUnsigned;
                }
                case LessUnsigned: {
                    return GreaterUnsigned;
                }
                case GreaterEqualUnsigned: {
                    return LessEqualUnsigned;
                }
            }
            return this;
        }
    }

    public static enum CC {
        Icc(0, "icc", false),
        Xcc(2, "xcc", false),
        Fcc0(0, "fcc0", true),
        Fcc1(1, "fcc1", true),
        Fcc2(2, "fcc2", true),
        Fcc3(3, "fcc3", true);

        private final int value;
        private final String operator;
        private boolean isFloat;

        private CC(int value, String op, boolean isFloat) {
            this.value = value;
            this.operator = op;
            this.isFloat = isFloat;
        }

        public int getValue() {
            return this.value;
        }

        public String getOperator() {
            return this.operator;
        }

        public static CC forKind(PlatformKind kind) {
            if (kind.equals(SPARCKind.XWORD)) {
                return Xcc;
            }
            if (kind.equals(SPARCKind.WORD)) {
                return Icc;
            }
            if (kind.equals(SPARCKind.SINGLE) || kind.equals(SPARCKind.DOUBLE)) {
                return Fcc0;
            }
            throw new IllegalArgumentException("Unknown kind: " + kind);
        }
    }

    public static enum MembarMask {
        StoreStore(8, "storestore"),
        LoadStore(4, "loadstore"),
        StoreLoad(2, "storeload"),
        LoadLoad(1, "loadload"),
        Sync(64, "sync"),
        MemIssue(32, "memissue"),
        LookAside(16, "lookaside");

        private final int value;
        private final String operator;

        private MembarMask(int value, String op) {
            this.value = value;
            this.operator = op;
        }

        public int getValue() {
            return this.value | 0x2000;
        }

        public String getOperator() {
            return this.operator;
        }
    }

    public static enum BranchPredict {
        PREDICT_TAKEN(1),
        PREDICT_NOT_TAKEN(0);

        public final int flag;

        private BranchPredict(int flag) {
            this.flag = flag;
        }
    }

    public static enum Annul {
        ANNUL(1),
        NOT_ANNUL(0);

        public final int flag;

        private Annul(int flag) {
            this.flag = flag;
        }
    }

    public static enum OpfLow {
        Fmovscc(1, "fmovscc", Op3s.Fpop2),
        Fmovdcc(2, "fmovdcc", Op3s.Fpop2);

        private final int value;
        private final String operator;
        private final Op3s op3;

        private OpfLow(int value, String op, Op3s op3) {
            this.value = value;
            this.operator = op;
            this.op3 = op3;
        }

        public String toString() {
            return this.operator;
        }
    }

    public static enum Opfs {
        Fmovs(1, "fmovs", Op3s.Fpop1, 4),
        Fmovd(2, "fmovd", Op3s.Fpop1, 4),
        Fmovq(3, "fmovq", Op3s.Fpop1, 4),
        Fnegs(5, "fnegs", Op3s.Fpop1, 4),
        Fnegd(6, "fnegd", Op3s.Fpop1, 4),
        Fnegq(7, "fnegq", Op3s.Fpop1, 4),
        Fabss(9, "fabss", Op3s.Fpop1, 4),
        Fabsd(10, "fabsd", Op3s.Fpop1, 4),
        Fabsq(11, "fabsq", Op3s.Fpop1, 4),
        Fpadd32(82, "fpadd32", Op3s.Impdep1, 3),
        Fzerod(96, "fzerod", Op3s.Impdep1, 8),
        Fzeros(97, "fzeros", Op3s.Impdep1, 8),
        Fsrc2d(120, "fsrc2d", Op3s.Impdep1, 4),
        Fsrc2s(121, "fsrc2s", Op3s.Impdep1, 4),
        Movdtox(272, "movdtox", Op3s.Impdep1, 4),
        Movstouw(273, "movstouw", Op3s.Impdep1, 4),
        Movstosw(275, "movstosw", Op3s.Impdep1, 4),
        Movxtod(280, "movxtod", Op3s.Impdep1, 4),
        Movwtos(281, "movwtos", Op3s.Impdep1, 4),
        UMulxhi(22, "umulxhi", Op3s.Impdep1, 3),
        Fadds(65, "fadds", Op3s.Fpop1, 3),
        Faddd(66, "faddd", Op3s.Fpop1, 3),
        Fsubs(69, "fsubs", Op3s.Fpop1, 2),
        Fsubd(70, "fsubd", Op3s.Fpop1, 2),
        Fmuls(73, "fmuls", Op3s.Fpop1, 3),
        Fmuld(74, "fmuld", Op3s.Fpop1, 3),
        Fdivs(77, "fdivs", Op3s.Fpop1, 2),
        Fdivd(78, "fdivd", Op3s.Fpop1, 2),
        Fsqrts(41, "fsqrts", Op3s.Fpop1, 4),
        Fsqrtd(42, "fsqrtd", Op3s.Fpop1, 4),
        Fsmuld(105, "fsmuld", Op3s.Fpop1, 3),
        Fstoi(209, "fstoi", Op3s.Fpop1, 4),
        Fdtoi(210, "fdtoi", Op3s.Fpop1, 4),
        Fstox(129, "fstox", Op3s.Fpop1, 4),
        Fdtox(130, "fdtox", Op3s.Fpop1, 4),
        Fxtos(132, "fxtos", Op3s.Fpop1, 4),
        Fxtod(136, "fxtod", Op3s.Fpop1, 4),
        Fitos(196, "fitos", Op3s.Fpop1, 4),
        Fdtos(198, "fdtos", Op3s.Fpop1, 4),
        Fitod(200, "fitod", Op3s.Fpop1, 4),
        Fstod(201, "fstod", Op3s.Fpop1, 4),
        Fcmps(81, "fcmps", Op3s.Fpop2, 2),
        Fcmpd(82, "fcmpd", Op3s.Fpop2, 2);

        private final int value;
        private final String operator;
        private final Op3s op3;
        private final int flags;

        private Opfs(int value, String op, Op3s op3, int flags) {
            this.value = value;
            this.operator = op;
            this.op3 = op3;
            this.flags = flags;
        }

        public int getValue() {
            return this.value;
        }

        public String getOperator() {
            return this.operator;
        }

        public boolean isBinary() {
            return (this.flags & 2) != 0;
        }

        public boolean isUnary() {
            return (this.flags & 4) != 0;
        }

        public boolean isCommutative() {
            return (this.flags & 1) != 0;
        }
    }

    public static enum Op3s {
        Add(0, "add", Ops.ArithOp, 3),
        And(1, "and", Ops.ArithOp, 3),
        Or(2, "or", Ops.ArithOp, 3),
        Xor(3, "xor", Ops.ArithOp, 3),
        Sub(4, "sub", Ops.ArithOp, 2),
        Andn(5, "andn", Ops.ArithOp, 3),
        Orn(6, "orn", Ops.ArithOp, 3),
        Xnor(7, "xnor", Ops.ArithOp, 3),
        Addc(8, "addc", Ops.ArithOp, 3),
        Mulx(9, "mulx", Ops.ArithOp, 3),
        Umul(10, "umul", Ops.ArithOp, 3),
        Smul(11, "smul", Ops.ArithOp, 3),
        Subc(12, "subc", Ops.ArithOp, 2),
        Udivx(13, "udivx", Ops.ArithOp, 2),
        Udiv(14, "udiv", Ops.ArithOp, 2),
        Sdiv(15, "sdiv", Ops.ArithOp, 2),
        Addcc(16, "addcc", Ops.ArithOp, 3),
        Andcc(17, "andcc", Ops.ArithOp, 3),
        Orcc(18, "orcc", Ops.ArithOp, 3),
        Xorcc(19, "xorcc", Ops.ArithOp, 3),
        Subcc(20, "subcc", Ops.ArithOp, 2),
        Andncc(21, "andncc", Ops.ArithOp, 3),
        Orncc(22, "orncc", Ops.ArithOp, 3),
        Xnorcc(23, "xnorcc", Ops.ArithOp, 3),
        Addccc(24, "addccc", Ops.ArithOp, 3),
        Umulcc(26, "umulcc", Ops.ArithOp, 3),
        Smulcc(27, "smulcc", Ops.ArithOp, 3),
        Subccc(28, "subccc", Ops.ArithOp, 2),
        Udivcc(30, "udivcc", Ops.ArithOp, 2),
        Sdivcc(31, "sdivcc", Ops.ArithOp, 2),
        Mulscc(36, "mulscc", Ops.ArithOp, 3),
        Sll(37, "sll", Ops.ArithOp, 2),
        Sllx(37, "sllx", Ops.ArithOp, 2),
        Srl(38, "srl", Ops.ArithOp, 2),
        Srlx(38, "srlx", Ops.ArithOp, 2),
        Sra(39, "srax", Ops.ArithOp, 2),
        Srax(39, "srax", Ops.ArithOp, 2),
        Membar(40, "membar", Ops.ArithOp),
        Flushw(43, "flushw", Ops.ArithOp),
        Movcc(44, "movcc", Ops.ArithOp),
        Sdivx(45, "sdivx", Ops.ArithOp, 2),
        Popc(46, "popc", Ops.ArithOp, 4),
        Movr(47, "movr", Ops.ArithOp, 2),
        Fpop1(52, "fpop1", Ops.ArithOp),
        Fpop2(53, "fpop2", Ops.ArithOp),
        Impdep1(54, "impdep1", Ops.ArithOp),
        Impdep2(55, "impdep2", Ops.ArithOp),
        Jmpl(56, "jmpl", Ops.ArithOp),
        Rett(57, "rett", Ops.ArithOp),
        Trap(58, "trap", Ops.ArithOp),
        Flush(59, "flush", Ops.ArithOp),
        Save(60, "save", Ops.ArithOp),
        Restore(61, "restore", Ops.ArithOp),
        Retry(62, "retry", Ops.ArithOp),
        Casa(60, "casa", Ops.LdstOp),
        Casxa(62, "casxa", Ops.LdstOp),
        Prefetch(45, "prefetch", Ops.LdstOp),
        Prefetcha(61, "prefetcha", Ops.LdstOp),
        Lduw(0, "lduw", Ops.LdstOp),
        Ldub(1, "ldub", Ops.LdstOp),
        Lduh(2, "lduh", Ops.LdstOp),
        Stw(4, "stw", Ops.LdstOp),
        Stb(5, "stb", Ops.LdstOp),
        Sth(6, "sth", Ops.LdstOp),
        Ldsw(8, "ldsw", Ops.LdstOp),
        Ldsb(9, "ldsb", Ops.LdstOp),
        Ldsh(10, "ldsh", Ops.LdstOp),
        Ldx(11, "ldx", Ops.LdstOp),
        Stx(14, "stx", Ops.LdstOp),
        Ldf(32, "ldf", Ops.LdstOp),
        Ldfsr(33, "ldfsr", Ops.LdstOp),
        Ldaf(34, "ldaf", Ops.LdstOp),
        Lddf(35, "lddf", Ops.LdstOp),
        Stf(36, "stf", Ops.LdstOp),
        Stfsr(37, "stfsr", Ops.LdstOp),
        Staf(38, "staf", Ops.LdstOp),
        Stdf(39, "stdf", Ops.LdstOp),
        Stba(21, "stba", Ops.LdstOp),
        Stha(22, "stha", Ops.LdstOp),
        Stwa(20, "stwa", Ops.LdstOp),
        Stxa(30, "stxa", Ops.LdstOp),
        Ldsba(25, "ldsba", Ops.LdstOp),
        Ldsha(26, "ldsha", Ops.LdstOp),
        Ldswa(24, "ldswa", Ops.LdstOp),
        Lduba(17, "lduba", Ops.LdstOp),
        Lduha(18, "lduha", Ops.LdstOp),
        Lduwa(16, "lduwa", Ops.LdstOp),
        Ldxa(27, "ldxa", Ops.LdstOp),
        Rd(40, "rd", Ops.ArithOp),
        Wr(48, "wr", Ops.ArithOp),
        Tcc(58, "tcc", Ops.ArithOp);

        private final int value;
        private final String operator;
        private final Ops op;
        private final int flags;

        private Op3s(int value, String name, Ops op) {
            this(value, name, op, 0);
        }

        private Op3s(int value, String name, Ops op, int flags) {
            this.value = value;
            this.operator = name;
            this.op = op;
            this.flags = flags;
        }

        public int getValue() {
            return this.value;
        }

        public String getOperator() {
            return this.operator;
        }

        public boolean throwsException() {
            if (this.op == Ops.LdstOp) {
                return true;
            }
            switch (this) {
                case Udiv: 
                case Udivx: 
                case Sdiv: 
                case Sdivx: 
                case Udivcc: 
                case Sdivcc: {
                    return true;
                }
            }
            return false;
        }

        public boolean isBinary() {
            return (this.flags & 2) != 0;
        }

        public boolean isUnary() {
            return (this.flags & 4) != 0;
        }

        public boolean isCommutative() {
            return (this.flags & 1) != 0;
        }
    }

    public static enum Op2s {
        Illtrap(0),
        Bpr(3),
        Fb(6),
        Fbp(5),
        Br(2),
        Bp(1),
        Cb(7),
        Sethi(4);

        private final int value;

        private Op2s(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Op2s byValue(int value) {
            return OP2S[value];
        }
    }

    public static enum Ops {
        BranchOp(0),
        CallOp(1),
        ArithOp(2),
        LdstOp(3);

        private final int value;

        private Ops(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean appliesTo(int instructionWord) {
            int opShift = 30;
            return instructionWord >>> opShift == this.value;
        }
    }
}

