/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.sparc;

import java.util.TreeMap;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;

public class SPARCInstructionCounter
implements Assembler.InstructionCounter {
    private static final TreeMap<String, SPARCInstructionMatch> INSTRUCTION_MATCHER = new TreeMap();
    private final SPARCAssembler asm;

    public SPARCInstructionCounter(SPARCAssembler asm) {
        this.asm = asm;
    }

    @Override
    public int[] countInstructions(String[] instructionTypes, int beginPc, int endPc) {
        SPARCInstructionMatch[] matchers = new SPARCInstructionMatch[instructionTypes.length];
        for (int i = 0; i < instructionTypes.length; ++i) {
            String typeName = instructionTypes[i];
            matchers[i] = INSTRUCTION_MATCHER.get(typeName);
            if (matchers[i] != null) continue;
            throw new IllegalArgumentException(String.format("Unknown instruction class %s, supported types are: %s", typeName, INSTRUCTION_MATCHER.keySet()));
        }
        return this.countBetween(matchers, beginPc, endPc);
    }

    private int[] countBetween(SPARCInstructionMatch[] matchers, int startPc, int endPc) {
        int[] counts = new int[matchers.length];
        for (int p = startPc; p < endPc; p += 4) {
            int instr = this.asm.getInt(p);
            for (int i = 0; i < matchers.length; ++i) {
                SPARCInstructionMatch matcher = matchers[i];
                if (!matcher.matches(instr)) continue;
                int n = i;
                counts[n] = counts[n] + 1;
            }
        }
        return counts;
    }

    @Override
    public String[] getSupportedInstructionTypes() {
        return INSTRUCTION_MATCHER.keySet().toArray(new String[0]);
    }

    static {
        INSTRUCTION_MATCHER.put("nop", new SPARCInstructionMatch(-1, 0x1000000));
        INSTRUCTION_MATCHER.put("st", new OP3LowBitsMatcher(3, 4, 5, 6, 7, 14, 15));
        INSTRUCTION_MATCHER.put("ld", new OP3LowBitsMatcher(3, 0, 1, 2, 3, 8, 9, 10, 11, 12, 13));
        INSTRUCTION_MATCHER.put("all", new SPARCInstructionMatch(0, 0));
    }

    private static class SPARCInstructionMatch {
        private final int mask;
        private final int[] patterns;

        SPARCInstructionMatch(int mask, int ... patterns) {
            this.mask = mask;
            this.patterns = patterns;
        }

        public boolean matches(int instruction) {
            for (int pattern : this.patterns) {
                if ((instruction & this.mask) != pattern) continue;
                return true;
            }
            return false;
        }
    }

    private static class OP3LowBitsMatcher
    extends SPARCInstructionMatch {
        private final int[] op3b03;
        private final int op;

        OP3LowBitsMatcher(int op, int ... op3b03) {
            super(0, 0);
            this.op = op;
            this.op3b03 = op3b03;
        }

        @Override
        public boolean matches(int instruction) {
            if (instruction >>> 30 != this.op) {
                return false;
            }
            int op3lo = instruction >> 19 & 0xF;
            for (int op3Part : this.op3b03) {
                if (op3Part != op3lo) continue;
                return true;
            }
            return false;
        }
    }
}

