/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public final class AArch64FloatConvertOp
extends AArch64LIRInstruction {
    private static final LIRInstructionClass<AArch64FloatConvertOp> TYPE = LIRInstructionClass.create(AArch64FloatConvertOp.class);
    private final FloatConvert op;
    @LIRInstruction.Def
    protected AllocatableValue resultValue;
    @LIRInstruction.Use
    protected AllocatableValue inputValue;

    protected AArch64FloatConvertOp(FloatConvert op, AllocatableValue resultValue, AllocatableValue inputValue) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.op = op;
        this.resultValue = resultValue;
        this.inputValue = inputValue;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        int fromSize = this.inputValue.getPlatformKind().getSizeInBytes() * 8;
        int toSize = this.resultValue.getPlatformKind().getSizeInBytes() * 8;
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register input = ValueUtil.asRegister((Value)this.inputValue);
        switch (this.op) {
            case F2I: 
            case D2I: 
            case F2L: 
            case D2L: {
                masm.fcvtzs(toSize, fromSize, result, input);
                break;
            }
            case I2F: 
            case I2D: 
            case L2F: 
            case L2D: {
                masm.scvtf(toSize, fromSize, result, input);
                break;
            }
            case D2F: 
            case F2D: {
                masm.fcvt(fromSize, result, input);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }
}

