/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.core.aarch64.AArch64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.aarch64.AArch64LIRGenerator;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.ComplexMatchResult;
import org.graalvm.compiler.core.match.MatchRule;
import org.graalvm.compiler.core.match.MatchRules;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.aarch64.AArch64ArithmeticOp;
import org.graalvm.compiler.lir.aarch64.AArch64BitFieldOp;
import org.graalvm.compiler.lir.aarch64.AArch64ControlFlow;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.NotNode;
import org.graalvm.compiler.nodes.calc.OrNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.memory.Access;

public class AArch64NodeMatchRules
extends NodeMatchRules {
    private static final EconomicMap<Class<? extends Node>, AArch64ArithmeticOp> nodeOpMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)5);
    private static final EconomicMap<Class<? extends BinaryNode>, AArch64BitFieldOp.BitFieldOpCode> bitFieldOpMap;
    private static final EconomicMap<Class<? extends BinaryNode>, AArch64Assembler.ShiftType> shiftTypeMap;

    public AArch64NodeMatchRules(LIRGeneratorTool gen) {
        super(gen);
    }

    protected LIRFrameState getState(Access access) {
        if (access instanceof DeoptimizingNode) {
            return this.state((DeoptimizingNode)((Object)access));
        }
        return null;
    }

    protected AArch64Kind getMemoryKind(Access access) {
        return (AArch64Kind)this.gen.getLIRKind(access.asNode().stamp(NodeView.DEFAULT)).getPlatformKind();
    }

    private AllocatableValue moveSp(AllocatableValue value) {
        return this.getLIRGeneratorTool().moveSp(value);
    }

    private ComplexMatchResult emitBitField(AArch64BitFieldOp.BitFieldOpCode op, ValueNode value, int lsb, int width) {
        assert (op != null);
        assert (value.getStackKind().isNumericInteger());
        return builder -> {
            Value a = this.operand(value);
            Variable result = this.gen.newVariable(LIRKind.combine(a));
            AllocatableValue src = this.moveSp(this.gen.asAllocatable(a));
            this.gen.append(new AArch64BitFieldOp(op, result, src, lsb, width));
            return result;
        };
    }

    private ComplexMatchResult emitBinaryShift(AArch64ArithmeticOp op, ValueNode value, BinaryNode shift, boolean isShiftNot) {
        AArch64Assembler.ShiftType shiftType = (AArch64Assembler.ShiftType)((Object)shiftTypeMap.get(shift.getClass()));
        assert (shiftType != null);
        assert (value.getStackKind().isNumericInteger());
        assert (shift.getX().getStackKind().isNumericInteger());
        assert (shift.getY() instanceof ConstantNode);
        return builder -> {
            Value a = this.operand(value);
            Value b = this.operand(shift.getX());
            Variable result = this.gen.newVariable(LIRKind.combine(a, b));
            AllocatableValue x = this.moveSp(this.gen.asAllocatable(a));
            AllocatableValue y = this.moveSp(this.gen.asAllocatable(b));
            int shiftAmount = shift.getY().asJavaConstant().asInt();
            this.gen.append(new AArch64ArithmeticOp.BinaryShiftOp(op, result, x, y, shiftType, shiftAmount, isShiftNot));
            return result;
        };
    }

    private ComplexMatchResult emitBitTestAndBranch(FixedNode trueSuccessor, FixedNode falseSuccessor, ValueNode value, double trueProbability, int nbits) {
        return builder -> {
            LabelRef trueDestination = this.getLIRBlock(trueSuccessor);
            LabelRef falseDestination = this.getLIRBlock(falseSuccessor);
            AllocatableValue src = this.moveSp(this.gen.asAllocatable(this.operand(value)));
            this.gen.append(new AArch64ControlFlow.BitTestAndBranchOp(trueDestination, falseDestination, src, trueProbability, nbits));
            return null;
        };
    }

    @MatchRules(value={@MatchRule(value="(And (UnsignedRightShift=shift a Constant=b) Constant=c)"), @MatchRule(value="(LeftShift=shift (And a Constant=c) Constant=b)")})
    public ComplexMatchResult unsignedBitField(BinaryNode shift, ValueNode a, ConstantNode b, ConstantNode c) {
        int srcBits;
        JavaKind srcKind = a.getStackKind();
        assert (srcKind.isNumericInteger());
        AArch64BitFieldOp.BitFieldOpCode op = (AArch64BitFieldOp.BitFieldOpCode)((Object)bitFieldOpMap.get(shift.getClass()));
        assert (op != null);
        int distance = b.asJavaConstant().asInt();
        long mask = c.asJavaConstant().asLong();
        distance &= srcKind == JavaKind.Int ? 31 : 63;
        if (!CodeUtil.isPowerOf2((long)(mask + 1L))) {
            return null;
        }
        int width = CodeUtil.log2((long)(mask + 1L));
        if (width >= (srcBits = srcKind.getBitCount()) - 1) {
            return null;
        }
        if (width + distance > srcBits) {
            return null;
        }
        return this.emitBitField(op, a, distance, width);
    }

    @MatchRules(value={@MatchRule(value="(Add=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(Add=binary a (RightShift=shift b Constant))"), @MatchRule(value="(Add=binary a (UnsignedRightShift=shift b Constant))"), @MatchRule(value="(Sub=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(Sub=binary a (RightShift=shift b Constant))"), @MatchRule(value="(Sub=binary a (UnsignedRightShift=shift b Constant))")})
    public ComplexMatchResult addSubShift(BinaryNode binary, ValueNode a, BinaryNode shift) {
        AArch64ArithmeticOp op = (AArch64ArithmeticOp)((Object)nodeOpMap.get(binary.getClass()));
        assert (op != null);
        return this.emitBinaryShift(op, a, shift, false);
    }

    @MatchRules(value={@MatchRule(value="(And=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(And=binary a (RightShift=shift b Constant))"), @MatchRule(value="(And=binary a (UnsignedRightShift=shift b Constant))"), @MatchRule(value="(Or=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(Or=binary a (RightShift=shift b Constant))"), @MatchRule(value="(Or=binary a (UnsignedRightShift=shift b Constant))"), @MatchRule(value="(Xor=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(Xor=binary a (RightShift=shift b Constant))"), @MatchRule(value="(Xor=binary a (UnsignedRightShift=shift b Constant))"), @MatchRule(value="(And=binary a (Not (LeftShift=shift b Constant)))"), @MatchRule(value="(And=binary a (Not (RightShift=shift b Constant)))"), @MatchRule(value="(And=binary a (Not (UnsignedRightShift=shift b Constant)))"), @MatchRule(value="(Or=binary a (Not (LeftShift=shift b Constant)))"), @MatchRule(value="(Or=binary a (Not (RightShift=shift b Constant)))"), @MatchRule(value="(Or=binary a (Not (UnsignedRightShift=shift b Constant)))"), @MatchRule(value="(Xor=binary a (Not (LeftShift=shift b Constant)))"), @MatchRule(value="(Xor=binary a (Not (RightShift=shift b Constant)))"), @MatchRule(value="(Xor=binary a (Not (UnsignedRightShift=shift b Constant)))")})
    public ComplexMatchResult logicShift(BinaryNode binary, ValueNode a, BinaryNode shift) {
        AArch64ArithmeticOp op = (AArch64ArithmeticOp)((Object)nodeOpMap.get(binary.getClass()));
        assert (op != null);
        ValueNode operand = binary.getX() == a ? binary.getY() : binary.getX();
        boolean isShiftNot = operand instanceof NotNode;
        return this.emitBinaryShift(op, a, shift, isShiftNot);
    }

    @MatchRules(value={@MatchRule(value="(Add=binary (Mul (SignExtend a) (SignExtend b)) c)"), @MatchRule(value="(Sub=binary c (Mul (SignExtend a) (SignExtend b)))")})
    public ComplexMatchResult signedMultiplyAddSubLong(BinaryNode binary, ValueNode a, ValueNode b, ValueNode c) {
        assert (a.getStackKind() == JavaKind.Int && b.getStackKind() == JavaKind.Int && c.getStackKind() == JavaKind.Long);
        if (binary instanceof AddNode) {
            return builder -> this.getArithmeticLIRGenerator().emitIntegerMAdd(this.operand(a), this.operand(b), this.operand(c), true);
        }
        return builder -> this.getArithmeticLIRGenerator().emitIntegerMSub(this.operand(a), this.operand(b), this.operand(c), true);
    }

    @MatchRules(value={@MatchRule(value="(Negate (Mul=mul (SignExtend a) (SignExtend b)))"), @MatchRule(value="(Mul=mul (Negate (SignExtend a)) (SignExtend b))")})
    public ComplexMatchResult signedMultiplyNegLong(MulNode mul, ValueNode a, ValueNode b) {
        assert (a.getStackKind() == JavaKind.Int && b.getStackKind() == JavaKind.Int);
        LIRKind resultKind = LIRKind.fromJavaKind(this.gen.target().arch, mul.getStackKind());
        return builder -> this.getArithmeticLIRGenerator().emitBinary(resultKind, AArch64ArithmeticOp.SMNEGL, true, this.operand(a), this.operand(b));
    }

    @MatchRule(value="(Mul=mul (SignExtend a) (SignExtend b))")
    public ComplexMatchResult signedMultiplyLong(MulNode mul, ValueNode a, ValueNode b) {
        assert (a.getStackKind() == JavaKind.Int && b.getStackKind() == JavaKind.Int);
        LIRKind resultKind = LIRKind.fromJavaKind(this.gen.target().arch, mul.getStackKind());
        return builder -> this.getArithmeticLIRGenerator().emitBinary(resultKind, AArch64ArithmeticOp.SMULL, true, this.operand(a), this.operand(b));
    }

    @MatchRules(value={@MatchRule(value="(Mul (Negate a) b)"), @MatchRule(value="(Negate (Mul a b))")})
    public ComplexMatchResult multiplyNegate(ValueNode a, ValueNode b) {
        if (a.getStackKind().isNumericInteger() && b.getStackKind().isNumericInteger()) {
            return builder -> this.getArithmeticLIRGenerator().emitMNeg(this.operand(a), this.operand(b));
        }
        return null;
    }

    @MatchRules(value={@MatchRule(value="(Add=binary (Mul a b) c)"), @MatchRule(value="(Sub=binary c (Mul a b))")})
    public ComplexMatchResult multiplyAddSub(BinaryNode binary, ValueNode a, ValueNode b, ValueNode c) {
        JavaKind kindA = a.getStackKind();
        JavaKind kindB = b.getStackKind();
        JavaKind kindC = c.getStackKind();
        if (!(kindA.isNumericInteger() && kindB.isNumericInteger() && kindC.isNumericInteger())) {
            return null;
        }
        if (binary instanceof AddNode) {
            return builder -> this.getArithmeticLIRGenerator().emitIntegerMAdd(this.operand(a), this.operand(b), this.operand(c), false);
        }
        return builder -> this.getArithmeticLIRGenerator().emitIntegerMSub(this.operand(a), this.operand(b), this.operand(c), false);
    }

    @MatchRule(value="(If (IntegerTest value Constant=a))")
    public ComplexMatchResult testBitAndBranch(IfNode root, ValueNode value, ConstantNode a) {
        long constant;
        if (value.getStackKind().isNumericInteger() && Long.bitCount(constant = a.asJavaConstant().asLong()) == 1) {
            return this.emitBitTestAndBranch(root.trueSuccessor(), root.falseSuccessor(), value, root.getTrueSuccessorProbability(), Long.numberOfTrailingZeros(constant));
        }
        return null;
    }

    @MatchRule(value="(If (IntegerLessThan=lessNode x Constant=y))")
    public ComplexMatchResult checkNegativeAndBranch(IfNode root, IntegerLessThanNode lessNode, ValueNode x, ConstantNode y) {
        JavaKind xKind = x.getStackKind();
        assert (xKind.isNumericInteger());
        if (y.isJavaConstant() && 0L == y.asJavaConstant().asLong() && lessNode.condition().equals((Object)CanonicalCondition.LT)) {
            return this.emitBitTestAndBranch(root.falseSuccessor(), root.trueSuccessor(), x, 1.0 - root.getTrueSuccessorProbability(), xKind.getBitCount() - 1);
        }
        return null;
    }

    @Override
    public AArch64LIRGenerator getLIRGeneratorTool() {
        return (AArch64LIRGenerator)this.gen;
    }

    protected AArch64ArithmeticLIRGenerator getArithmeticLIRGenerator() {
        return (AArch64ArithmeticLIRGenerator)this.getLIRGeneratorTool().getArithmetic();
    }

    static {
        nodeOpMap.put(AddNode.class, (Object)AArch64ArithmeticOp.ADD);
        nodeOpMap.put(SubNode.class, (Object)AArch64ArithmeticOp.SUB);
        nodeOpMap.put(AndNode.class, (Object)AArch64ArithmeticOp.AND);
        nodeOpMap.put(OrNode.class, (Object)AArch64ArithmeticOp.OR);
        nodeOpMap.put(XorNode.class, (Object)AArch64ArithmeticOp.XOR);
        bitFieldOpMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)2);
        bitFieldOpMap.put(UnsignedRightShiftNode.class, (Object)AArch64BitFieldOp.BitFieldOpCode.UBFX);
        bitFieldOpMap.put(LeftShiftNode.class, (Object)AArch64BitFieldOp.BitFieldOpCode.UBFIZ);
        shiftTypeMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)3);
        shiftTypeMap.put(LeftShiftNode.class, (Object)AArch64Assembler.ShiftType.LSL);
        shiftTypeMap.put(RightShiftNode.class, (Object)AArch64Assembler.ShiftType.ASR);
        shiftTypeMap.put(UnsignedRightShiftNode.class, (Object)AArch64Assembler.ShiftType.LSR);
    }
}

