/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common;

import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;

public final class LIRKind
extends ValueKind<LIRKind> {
    private final int referenceMask;
    private final int referenceCompressionMask;
    private AllocatableValue derivedReferenceBase;
    private static final int UNKNOWN_REFERENCE = -1;
    public static final LIRKind Illegal = LIRKind.unknownReference(ValueKind.Illegal.getPlatformKind());

    private LIRKind(PlatformKind platformKind, int referenceMask, int referenceCompressionMask, AllocatableValue derivedReferenceBase) {
        super(platformKind);
        this.referenceMask = referenceMask;
        this.referenceCompressionMask = referenceCompressionMask;
        this.derivedReferenceBase = derivedReferenceBase;
        assert (this.referenceCompressionMask == 0 || this.referenceMask == this.referenceCompressionMask) : "mixing compressed and uncompressed references is unsupported";
        assert (derivedReferenceBase == null || !((LIRKind)derivedReferenceBase.getValueKind(LIRKind.class)).isDerivedReference()) : "derived reference can't have another derived reference as base";
    }

    public static LIRKind value(PlatformKind platformKind) {
        return new LIRKind(platformKind, 0, 0, null);
    }

    public static LIRKind reference(PlatformKind platformKind) {
        return LIRKind.derivedReference(platformKind, null, false);
    }

    public static LIRKind compressedReference(PlatformKind platformKind) {
        return LIRKind.derivedReference(platformKind, null, true);
    }

    public static LIRKind fromJavaKind(Architecture arch, JavaKind javaKind) {
        PlatformKind platformKind = arch.getPlatformKind(javaKind);
        if (javaKind.isObject()) {
            return LIRKind.reference(platformKind);
        }
        return LIRKind.value(platformKind);
    }

    public static LIRKind derivedReference(PlatformKind platformKind, AllocatableValue base, boolean compressed) {
        int length = platformKind.getVectorLength();
        assert (0 < length && length < 32) : "vector of " + length + " references not supported";
        int referenceMask = (1 << length) - 1;
        int referenceCompressionMask = compressed ? referenceMask : 0;
        return new LIRKind(platformKind, referenceMask, referenceCompressionMask, base);
    }

    public static LIRKind unknownReference(PlatformKind platformKind) {
        return new LIRKind(platformKind, -1, -1, null);
    }

    public LIRKind makeDerivedReference(AllocatableValue base) {
        assert (!this.isUnknownReference() && this.derivedReferenceBase == null);
        if (Value.ILLEGAL.equals((Object)base)) {
            return this.makeUnknownReference();
        }
        if (this.isValue()) {
            return LIRKind.derivedReference(this.getPlatformKind(), base, false);
        }
        return new LIRKind(this.getPlatformKind(), this.referenceMask, this.referenceCompressionMask, base);
    }

    public static LIRKind combine(Value ... inputs) {
        assert (inputs.length > 0);
        for (Value input : inputs) {
            LIRKind kind = (LIRKind)input.getValueKind(LIRKind.class);
            if (kind.isUnknownReference()) {
                return kind;
            }
            if (kind.isValue()) continue;
            return kind.makeUnknownReference();
        }
        return (LIRKind)inputs[0].getValueKind(LIRKind.class);
    }

    public static AllocatableValue derivedBaseFromValue(AllocatableValue value) {
        ValueKind valueKind = value.getValueKind();
        if (valueKind instanceof LIRKind) {
            LIRKind kind = (LIRKind)value.getValueKind(LIRKind.class);
            if (kind.isValue()) {
                return null;
            }
            if (kind.isDerivedReference()) {
                return kind.getDerivedReferenceBase();
            }
            if (kind.isUnknownReference()) {
                return Value.ILLEGAL;
            }
            return value;
        }
        return Value.ILLEGAL;
    }

    public static LIRKind combineDerived(LIRKind kind, AllocatableValue base1, AllocatableValue base2) {
        if (base1 == null && base2 == null) {
            return kind;
        }
        if (base1 == null) {
            return kind.makeDerivedReference(base2);
        }
        if (base2 == null) {
            return kind.makeDerivedReference(base1);
        }
        return kind.makeUnknownReference();
    }

    public static LIRKind mergeReferenceInformation(LIRKind mergeKind, LIRKind inputKind) {
        assert (mergeKind != null);
        assert (inputKind != null);
        if (mergeKind.isUnknownReference()) {
            return mergeKind;
        }
        if (mergeKind.isValue()) {
            if (!inputKind.isValue()) {
                return mergeKind.makeUnknownReference();
            }
            return mergeKind;
        }
        if (mergeKind.referenceMask != inputKind.referenceMask || mergeKind.referenceCompressionMask != inputKind.referenceCompressionMask) {
            return mergeKind.makeUnknownReference();
        }
        if (mergeKind.isDerivedReference()) {
            if (inputKind.isDerivedReference() && mergeKind.getDerivedReferenceBase().equals((Object)inputKind.getDerivedReferenceBase())) {
                return mergeKind;
            }
            return mergeKind.makeUnknownReference();
        }
        if (inputKind.isDerivedReference()) {
            return mergeKind.makeUnknownReference();
        }
        return mergeKind;
    }

    public LIRKind changeType(PlatformKind newPlatformKind) {
        if (newPlatformKind == this.getPlatformKind()) {
            return this;
        }
        if (this.isUnknownReference()) {
            return LIRKind.unknownReference(newPlatformKind);
        }
        if (this.referenceMask == 0) {
            return LIRKind.value(newPlatformKind);
        }
        int newLength = Math.min(32, newPlatformKind.getVectorLength());
        int lengthMask = -1 >>> 32 - newLength;
        int newReferenceMask = this.referenceMask & lengthMask;
        int newReferenceCompressionMask = this.referenceCompressionMask & lengthMask;
        assert (newReferenceMask != -1);
        return new LIRKind(newPlatformKind, newReferenceMask, newReferenceCompressionMask, this.derivedReferenceBase);
    }

    public LIRKind repeat(PlatformKind newPlatformKind) {
        if (this.isUnknownReference()) {
            return LIRKind.unknownReference(newPlatformKind);
        }
        if (this.referenceMask == 0) {
            return LIRKind.value(newPlatformKind);
        }
        int oldLength = this.getPlatformKind().getVectorLength();
        int newLength = newPlatformKind.getVectorLength();
        assert (oldLength <= newLength && newLength < 32 && newLength % oldLength == 0);
        int newReferenceMask = 0;
        int newReferenceCompressionMask = 0;
        for (int i = 0; i < newLength; i += this.getPlatformKind().getVectorLength()) {
            newReferenceMask |= this.referenceMask << i;
            newReferenceCompressionMask |= this.referenceCompressionMask << i;
        }
        assert (newReferenceMask != -1);
        return new LIRKind(newPlatformKind, newReferenceMask, newReferenceCompressionMask, this.derivedReferenceBase);
    }

    public LIRKind makeUnknownReference() {
        return new LIRKind(this.getPlatformKind(), -1, -1, null);
    }

    public boolean isDerivedReference() {
        return this.getDerivedReferenceBase() != null;
    }

    public AllocatableValue getDerivedReferenceBase() {
        return this.derivedReferenceBase;
    }

    public void setDerivedReferenceBase(AllocatableValue derivedReferenceBase) {
        assert (this.isDerivedReference());
        this.derivedReferenceBase = derivedReferenceBase;
    }

    public boolean isUnknownReference() {
        return this.referenceMask == -1;
    }

    public static boolean isUnknownReference(ValueKind<?> kind) {
        if (kind instanceof LIRKind) {
            return ((LIRKind)kind).isUnknownReference();
        }
        return true;
    }

    public static boolean isUnknownReference(Value value) {
        return LIRKind.isUnknownReference(value.getValueKind());
    }

    public int getReferenceCount() {
        assert (!this.isUnknownReference());
        return Integer.bitCount(this.referenceMask);
    }

    public boolean isReference(int idx) {
        assert (0 <= idx && idx < this.getPlatformKind().getVectorLength()) : "invalid index " + idx + " in " + (Object)((Object)this);
        return !this.isUnknownReference() && (this.referenceMask & 1 << idx) != 0;
    }

    public boolean isCompressedReference(int idx) {
        assert (0 <= idx && idx < this.getPlatformKind().getVectorLength()) : "invalid index " + idx + " in " + (Object)((Object)this);
        return !this.isUnknownReference() && (this.referenceCompressionMask & 1 << idx) != 0;
    }

    public boolean isValue() {
        return this.referenceMask == 0;
    }

    public static boolean isValue(ValueKind<?> kind) {
        if (kind instanceof LIRKind) {
            return ((LIRKind)kind).isValue();
        }
        return false;
    }

    public static boolean isValue(Value value) {
        return LIRKind.isValue(value.getValueKind());
    }

    public String toString() {
        if (this.isValue()) {
            return this.getPlatformKind().name();
        }
        if (this.isUnknownReference()) {
            return this.getPlatformKind().name() + "[*]";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(this.getPlatformKind().name());
        ret.append('[');
        for (int i = 0; i < this.getPlatformKind().getVectorLength(); ++i) {
            if (this.isReference(i)) {
                ret.append('.');
                continue;
            }
            ret.append(' ');
        }
        ret.append(']');
        return ret.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getPlatformKind() == null ? 0 : this.getPlatformKind().hashCode());
        result = 31 * result + (this.getDerivedReferenceBase() == null ? 0 : this.getDerivedReferenceBase().hashCode());
        result = 31 * result + this.referenceMask;
        result = 31 * result + this.referenceCompressionMask;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LIRKind)) {
            return false;
        }
        LIRKind other = (LIRKind)((Object)obj);
        if (this.getPlatformKind() != other.getPlatformKind() || this.referenceMask != other.referenceMask || this.referenceCompressionMask != other.referenceCompressionMask) {
            return false;
        }
        if (this.isDerivedReference()) {
            if (!other.isDerivedReference()) {
                return false;
            }
            return this.getDerivedReferenceBase().equals((Object)other.getDerivedReferenceBase());
        }
        return !other.isDerivedReference();
    }

    public static boolean verifyMoveKinds(ValueKind<?> dst, ValueKind<?> src, RegisterAllocationConfig config) {
        if (src.equals(dst)) {
            return true;
        }
        if (LIRKind.isUnknownReference(dst) || LIRKind.isValue(dst) && LIRKind.isValue(src)) {
            PlatformKind dstPlatformKind;
            PlatformKind srcPlatformKind = src.getPlatformKind();
            if (srcPlatformKind.equals(dstPlatformKind = dst.getPlatformKind())) {
                return true;
            }
            return config.getRegisterCategory(srcPlatformKind).equals((Object)config.getRegisterCategory(dstPlatformKind));
        }
        return false;
    }
}

