/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.alloc;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.Loop;

public final class ComputeBlockOrder {
    private static final int INITIAL_WORKLIST_CAPACITY = 10;
    private static final int PENALTY_VERSUS_UNSCHEDULED = 10;

    public static <T extends AbstractBlockBase<T>> AbstractBlockBase<?>[] computeLinearScanOrder(int blockCount, T startBlock) {
        ArrayList order = new ArrayList();
        BitSet visitedBlocks = new BitSet(blockCount);
        PriorityQueue<T> worklist = ComputeBlockOrder.initializeWorklist(startBlock, visitedBlocks);
        ComputeBlockOrder.computeLinearScanOrder(order, worklist, visitedBlocks);
        assert (ComputeBlockOrder.checkOrder(order, blockCount));
        return order.toArray(new AbstractBlockBase[0]);
    }

    public static <T extends AbstractBlockBase<T>> AbstractBlockBase<?>[] computeCodeEmittingOrder(int blockCount, T startBlock) {
        ArrayList order = new ArrayList();
        BitSet visitedBlocks = new BitSet(blockCount);
        PriorityQueue<T> worklist = ComputeBlockOrder.initializeWorklist(startBlock, visitedBlocks);
        ComputeBlockOrder.computeCodeEmittingOrder(order, worklist, visitedBlocks);
        assert (ComputeBlockOrder.checkOrder(order, blockCount));
        return order.toArray(new AbstractBlockBase[0]);
    }

    private static <T extends AbstractBlockBase<T>> void computeCodeEmittingOrder(List<T> order, PriorityQueue<T> worklist, BitSet visitedBlocks) {
        while (!worklist.isEmpty()) {
            AbstractBlockBase nextImportantPath = (AbstractBlockBase)worklist.poll();
            ComputeBlockOrder.addPathToCodeEmittingOrder(nextImportantPath, order, worklist, visitedBlocks);
        }
    }

    private static <T extends AbstractBlockBase<T>> void computeLinearScanOrder(List<T> order, PriorityQueue<T> worklist, BitSet visitedBlocks) {
        while (!worklist.isEmpty()) {
            AbstractBlockBase nextImportantPath = (AbstractBlockBase)worklist.poll();
            while ((nextImportantPath = ComputeBlockOrder.addPathToLinearScanOrder(nextImportantPath, order, worklist, visitedBlocks)) != null) {
            }
        }
    }

    private static <T extends AbstractBlockBase<T>> PriorityQueue<T> initializeWorklist(T startBlock, BitSet visitedBlocks) {
        PriorityQueue result = new PriorityQueue(10, new BlockOrderComparator());
        result.add(startBlock);
        visitedBlocks.set(startBlock.getId());
        return result;
    }

    private static <T extends AbstractBlockBase<T>> T addPathToLinearScanOrder(T block, List<T> order, PriorityQueue<T> worklist, BitSet visitedBlocks) {
        block.setLinearScanNumber(order.size());
        order.add(block);
        T mostLikelySuccessor = ComputeBlockOrder.findAndMarkMostLikelySuccessor(block, visitedBlocks);
        ComputeBlockOrder.enqueueSuccessors(block, worklist, visitedBlocks);
        if (mostLikelySuccessor != null) {
            if (!mostLikelySuccessor.isLoopHeader() && mostLikelySuccessor.getPredecessorCount() > 1) {
                double unscheduledSum = 0.0;
                for (AbstractBlockBase pred : mostLikelySuccessor.getPredecessors()) {
                    if (pred.getLinearScanNumber() != -1) continue;
                    unscheduledSum += pred.getRelativeFrequency();
                }
                if (unscheduledSum > block.getRelativeFrequency() / 10.0) {
                    visitedBlocks.clear(mostLikelySuccessor.getId());
                    return null;
                }
            }
            return mostLikelySuccessor;
        }
        return null;
    }

    private static <T extends AbstractBlockBase<T>> void addPathToCodeEmittingOrder(T initialBlock, List<T> order, PriorityQueue<T> worklist, BitSet visitedBlocks) {
        T block = initialBlock;
        while (block != null) {
            if (!ComputeBlockOrder.skipLoopHeader(block)) {
                if (block.isLoopHeader()) {
                    block.setAlign(true);
                }
                ComputeBlockOrder.addBlock(block, order);
            }
            Loop<T> loop = block.getLoop();
            if (block.isLoopEnd() && ComputeBlockOrder.skipLoopHeader(loop.getHeader())) {
                ComputeBlockOrder.addBlock(loop.getHeader(), order);
                for (AbstractBlockBase successor : loop.getHeader().getSuccessors()) {
                    if (successor.getLoopDepth() != block.getLoopDepth()) continue;
                    successor.setAlign(true);
                }
            }
            T mostLikelySuccessor = ComputeBlockOrder.findAndMarkMostLikelySuccessor(block, visitedBlocks);
            ComputeBlockOrder.enqueueSuccessors(block, worklist, visitedBlocks);
            block = mostLikelySuccessor;
        }
    }

    private static <T extends AbstractBlockBase<T>> void addBlock(T header, List<T> order) {
        assert (!order.contains(header)) : "Cannot insert block twice";
        order.add(header);
    }

    private static <T extends AbstractBlockBase<T>> T findAndMarkMostLikelySuccessor(T block, BitSet visitedBlocks) {
        AbstractBlockBase result = null;
        for (AbstractBlockBase successor : block.getSuccessors()) {
            assert (successor.getRelativeFrequency() >= 0.0) : "Relative frequencies must be positive";
            if (visitedBlocks.get(successor.getId()) || successor.getLoopDepth() < block.getLoopDepth() || result != null && !(successor.getRelativeFrequency() >= result.getRelativeFrequency())) continue;
            result = successor;
        }
        if (result != null) {
            visitedBlocks.set(result.getId());
        }
        return (T)result;
    }

    private static <T extends AbstractBlockBase<T>> void enqueueSuccessors(T block, PriorityQueue<T> worklist, BitSet visitedBlocks) {
        for (AbstractBlockBase successor : block.getSuccessors()) {
            if (visitedBlocks.get(successor.getId())) continue;
            visitedBlocks.set(successor.getId());
            worklist.add(successor);
        }
    }

    private static <T extends AbstractBlockBase<T>> boolean skipLoopHeader(AbstractBlockBase<T> block) {
        return block.isLoopHeader() && !block.isLoopEnd() && block.getLoop().numBackedges() == 1L;
    }

    private static boolean checkOrder(List<? extends AbstractBlockBase<?>> order, int expectedBlockCount) {
        assert (order.size() == expectedBlockCount) : String.format("Number of blocks in ordering (%d) does not match expected block count (%d)", order.size(), expectedBlockCount);
        return true;
    }

    private static class BlockOrderComparator<T extends AbstractBlockBase<T>>
    implements Comparator<T> {
        private static final double EPSILON = 1.0E-6;

        private BlockOrderComparator() {
        }

        @Override
        public int compare(T a, T b) {
            int diff;
            if (((AbstractBlockBase)a).getRelativeFrequency() > 1.0E-6 && ((AbstractBlockBase)b).getRelativeFrequency() > 1.0E-6 && (diff = ((AbstractBlockBase)b).getLoopDepth() - ((AbstractBlockBase)a).getLoopDepth()) != 0) {
                return diff;
            }
            if (((AbstractBlockBase)a).getRelativeFrequency() > ((AbstractBlockBase)b).getRelativeFrequency()) {
                return -1;
            }
            return 1;
        }
    }
}

