/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.alloc;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.PriorityQueue;
import org.graalvm.compiler.core.common.alloc.Trace;
import org.graalvm.compiler.core.common.alloc.TraceBuilderResult;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;

public final class UniDirectionalTraceBuilder {
    private final PriorityQueue<AbstractBlockBase<?>> worklist;
    private final BitSet processed;
    private final int[] blocked;
    private final Trace[] blockToTrace;

    public static TraceBuilderResult computeTraces(DebugContext debug, AbstractBlockBase<?> startBlock, AbstractBlockBase<?>[] blocks, TraceBuilderResult.TrivialTracePredicate pred) {
        return new UniDirectionalTraceBuilder(blocks).build(debug, startBlock, blocks, pred);
    }

    private UniDirectionalTraceBuilder(AbstractBlockBase<?>[] blocks) {
        this.processed = new BitSet(blocks.length);
        this.worklist = new PriorityQueue(UniDirectionalTraceBuilder::compare);
        assert (this.worklist != null);
        this.blocked = new int[blocks.length];
        this.blockToTrace = new Trace[blocks.length];
        for (AbstractBlockBase<?> block : blocks) {
            this.blocked[block.getId()] = block.getPredecessorCount();
        }
    }

    private static int compare(AbstractBlockBase<?> a, AbstractBlockBase<?> b) {
        return Double.compare(b.getRelativeFrequency(), a.getRelativeFrequency());
    }

    private boolean processed(AbstractBlockBase<?> b) {
        return this.processed.get(b.getId());
    }

    private TraceBuilderResult build(DebugContext debug, AbstractBlockBase<?> startBlock, AbstractBlockBase<?>[] blocks, TraceBuilderResult.TrivialTracePredicate pred) {
        try (Indent indent = debug.logAndIndent("UniDirectionalTraceBuilder: start trace building: %s", startBlock);){
            ArrayList<Trace> traces = this.buildTraces(debug, startBlock);
            TraceBuilderResult traceBuilderResult = TraceBuilderResult.create(debug, blocks, traces, this.blockToTrace, pred);
            return traceBuilderResult;
        }
    }

    protected ArrayList<Trace> buildTraces(DebugContext debug, AbstractBlockBase<?> startBlock) {
        ArrayList<Trace> traces = new ArrayList<Trace>();
        this.worklist.add(startBlock);
        while (!this.worklist.isEmpty()) {
            AbstractBlockBase<?> block = this.worklist.poll();
            assert (block != null);
            if (this.processed(block)) continue;
            Trace trace = new Trace(this.findTrace(debug, block));
            for (AbstractBlockBase<?> traceBlock : trace.getBlocks()) {
                this.blockToTrace[traceBlock.getId()] = trace;
            }
            trace.setId(traces.size());
            traces.add(trace);
        }
        return traces;
    }

    private List<AbstractBlockBase<?>> findTrace(DebugContext debug, AbstractBlockBase<?> traceStart) {
        assert (this.checkPredecessorsProcessed(traceStart));
        ArrayList trace = new ArrayList();
        int blockNumber = 0;
        try (Indent i = debug.logAndIndent("StartTrace: %s", traceStart);){
            AbstractBlockBase<?> block = traceStart;
            while (block != null) {
                debug.log("add %s (freq: %f)", block, (Object)block.getRelativeFrequency());
                this.processed.set(block.getId());
                trace.add(block);
                this.unblock(block);
                block.setLinearScanNumber(blockNumber++);
                block = this.selectNext(block);
            }
        }
        return trace;
    }

    private boolean checkPredecessorsProcessed(AbstractBlockBase<?> block) {
        for (AbstractBlockBase pred : block.getPredecessors()) {
            assert (this.processed(pred)) : "Predecessor unscheduled: " + pred;
        }
        return true;
    }

    private void unblock(AbstractBlockBase<?> block) {
        for (AbstractBlockBase successor : block.getSuccessors()) {
            if (this.processed(successor)) continue;
            int n = successor.getId();
            int n2 = this.blocked[n] - 1;
            this.blocked[n] = n2;
            int blockCount = n2;
            assert (blockCount >= 0);
            if (blockCount != 0) continue;
            this.worklist.add(successor);
        }
    }

    private AbstractBlockBase<?> selectNext(AbstractBlockBase<?> block) {
        AbstractBlockBase next = null;
        for (AbstractBlockBase successor : block.getSuccessors()) {
            if (this.processed(successor) || next != null && !(successor.getRelativeFrequency() > next.getRelativeFrequency())) continue;
            next = successor;
        }
        return next;
    }
}

