/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.spi;

import java.util.Arrays;

public class ForeignCallDescriptor {
    private final String name;
    private final Class<?> resultType;
    private final Class<?>[] argumentTypes;

    public ForeignCallDescriptor(String name, Class<?> resultType, Class<?> ... argumentTypes) {
        this.name = name;
        this.resultType = resultType;
        this.argumentTypes = argumentTypes;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public Class<?>[] getArgumentTypes() {
        return (Class[])this.argumentTypes.clone();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ForeignCallDescriptor) {
            ForeignCallDescriptor other = (ForeignCallDescriptor)obj;
            return other.name.equals(this.name) && other.resultType.equals(this.resultType) && Arrays.equals(other.argumentTypes, this.argumentTypes);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name).append('(');
        String sep = "";
        for (Class<?> arg : this.argumentTypes) {
            sb.append(sep).append(arg.getSimpleName());
            sep = ",";
        }
        return sb.append(')').append(this.resultType.getSimpleName()).toString();
    }
}

