/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.type;

import java.util.Objects;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;

public abstract class AbstractObjectStamp
extends AbstractPointerStamp {
    private final ResolvedJavaType type;
    private final boolean exactType;

    protected AbstractObjectStamp(ResolvedJavaType type, boolean exactType, boolean nonNull, boolean alwaysNull) {
        super(nonNull, alwaysNull);
        this.type = type;
        this.exactType = exactType;
    }

    @Override
    public void accept(SpeculationReasonGroup.SpeculationContextObject.Visitor v) {
        super.accept(v);
        v.visitObject(this.type);
        v.visitBoolean(this.exactType);
    }

    protected abstract AbstractObjectStamp copyWith(ResolvedJavaType var1, boolean var2, boolean var3, boolean var4);

    @Override
    protected final AbstractPointerStamp copyWith(boolean newNonNull, boolean newAlwaysNull) {
        return this.copyWith(this.type, this.exactType, newNonNull, newAlwaysNull);
    }

    @Override
    public Stamp unrestricted() {
        return this.copyWith(null, false, false, false);
    }

    @Override
    public Stamp empty() {
        return this.copyWith(null, true, true, false);
    }

    @Override
    public Stamp constant(Constant c, MetaAccessProvider meta) {
        JavaConstant jc = (JavaConstant)c;
        ResolvedJavaType constType = jc.isNull() ? null : meta.lookupJavaType(jc);
        return this.copyWith(constType, jc.isNonNull(), jc.isNonNull(), jc.isNull());
    }

    @Override
    public boolean hasValues() {
        return !this.exactType || this.type != null && AbstractObjectStamp.isConcreteType(this.type);
    }

    @Override
    public JavaKind getStackKind() {
        return JavaKind.Object;
    }

    @Override
    public ResolvedJavaType javaType(MetaAccessProvider metaAccess) {
        if (this.type != null) {
            return this.type;
        }
        return metaAccess.lookupJavaType(Object.class);
    }

    public ResolvedJavaType type() {
        return this.type;
    }

    public boolean isExactType() {
        return this.exactType && this.type != null;
    }

    protected void appendString(StringBuilder str) {
        if (this.isEmpty()) {
            str.append(" empty");
        } else {
            str.append(this.nonNull() ? "!" : "").append(this.exactType ? "#" : "").append(' ').append(this.type == null ? "-" : this.type.getName()).append(this.alwaysNull() ? " NULL" : "");
        }
    }

    @Override
    public Stamp meet(Stamp otherStamp) {
        boolean meetAlwaysNull;
        boolean meetNonNull;
        boolean meetExactType;
        ResolvedJavaType meetType;
        if (this == otherStamp) {
            return this;
        }
        AbstractObjectStamp other = (AbstractObjectStamp)otherStamp;
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        if (other.alwaysNull()) {
            meetType = this.type();
            meetExactType = this.exactType;
            meetNonNull = false;
            meetAlwaysNull = this.alwaysNull();
        } else if (this.alwaysNull()) {
            meetType = other.type();
            meetExactType = other.exactType;
            meetNonNull = false;
            meetAlwaysNull = other.alwaysNull();
        } else {
            meetType = AbstractObjectStamp.meetTypes(this.type(), other.type());
            boolean bl = meetExactType = this.exactType && other.exactType;
            if (meetExactType && this.type != null && other.type != null) {
                meetExactType = Objects.equals(meetType, this.type) && Objects.equals(meetType, other.type);
            }
            meetNonNull = this.nonNull() && other.nonNull();
            meetAlwaysNull = false;
        }
        if (Objects.equals(meetType, this.type) && meetExactType == this.exactType && meetNonNull == this.nonNull() && meetAlwaysNull == this.alwaysNull()) {
            return this;
        }
        if (Objects.equals(meetType, other.type) && meetExactType == other.exactType && meetNonNull == other.nonNull() && meetAlwaysNull == other.alwaysNull()) {
            return other;
        }
        return this.copyWith(meetType, meetExactType, meetNonNull, meetAlwaysNull);
    }

    @Override
    public Stamp join(Stamp otherStamp) {
        return this.join0(otherStamp, false);
    }

    @Override
    public Stamp improveWith(Stamp other) {
        return this.join0(other, true);
    }

    private Stamp join0(Stamp otherStamp, boolean improve) {
        ResolvedJavaType joinType;
        boolean joinExactType;
        if (this == otherStamp) {
            return this;
        }
        AbstractObjectStamp other = (AbstractObjectStamp)otherStamp;
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return other;
        }
        boolean joinAlwaysNull = this.alwaysNull() || other.alwaysNull();
        boolean joinNonNull = this.nonNull() || other.nonNull();
        boolean bl = joinExactType = this.exactType || other.exactType;
        if (Objects.equals(this.type, other.type)) {
            joinType = this.type;
        } else if (this.type == null) {
            joinType = other.type;
        } else if (other.type == null) {
            joinType = this.type;
        } else if (this.type.isAssignableFrom(other.type)) {
            joinType = other.type;
            if (this.exactType) {
                joinAlwaysNull = true;
            }
        } else if (other.type.isAssignableFrom(this.type)) {
            joinType = this.type;
            if (other.exactType) {
                joinAlwaysNull = true;
            }
        } else {
            if (improve) {
                joinType = this.type;
                joinExactType = this.exactType;
            } else {
                joinType = null;
            }
            if (joinExactType || !AbstractObjectStamp.isInterfaceOrArrayOfInterface(this.type) && !AbstractObjectStamp.isInterfaceOrArrayOfInterface(other.type)) {
                joinAlwaysNull = true;
            }
        }
        if (joinAlwaysNull) {
            joinType = null;
            joinExactType = false;
        }
        if (joinExactType && joinType == null) {
            return this.empty();
        }
        if (joinAlwaysNull && joinNonNull) {
            return this.empty();
        }
        if (joinExactType && !AbstractObjectStamp.isConcreteType(joinType)) {
            return this.empty();
        }
        if (Objects.equals(joinType, this.type) && joinExactType == this.exactType && joinNonNull == this.nonNull() && joinAlwaysNull == this.alwaysNull()) {
            return this;
        }
        if (Objects.equals(joinType, other.type) && joinExactType == other.exactType && joinNonNull == other.nonNull() && joinAlwaysNull == other.alwaysNull()) {
            return other;
        }
        return this.copyWith(joinType, joinExactType, joinNonNull, joinAlwaysNull);
    }

    private static boolean isInterfaceOrArrayOfInterface(ResolvedJavaType t) {
        return t.isInterface() || t.isArray() && t.getElementalType().isInterface();
    }

    public static boolean isConcreteType(ResolvedJavaType type) {
        return !type.isAbstract() || type.isArray();
    }

    private static ResolvedJavaType meetTypes(ResolvedJavaType a, ResolvedJavaType b) {
        int hashB;
        if (Objects.equals(a, b)) {
            return a;
        }
        if (a == null || b == null) {
            return null;
        }
        int hashA = a.getName().hashCode();
        if (hashA < (hashB = b.getName().hashCode())) {
            return AbstractObjectStamp.meetOrderedNonNullTypes(a, b);
        }
        if (hashB < hashA) {
            return AbstractObjectStamp.meetOrderedNonNullTypes(b, a);
        }
        int diff = a.getName().compareTo(b.getName());
        if (diff <= 0) {
            return AbstractObjectStamp.meetOrderedNonNullTypes(a, b);
        }
        return AbstractObjectStamp.meetOrderedNonNullTypes(b, a);
    }

    private static ResolvedJavaType meetOrderedNonNullTypes(ResolvedJavaType a, ResolvedJavaType b) {
        ResolvedJavaType result = a.findLeastCommonAncestor(b);
        if (result.isJavaLangObject() && a.isInterface() && b.isInterface()) {
            ResolvedJavaType[] interfacesA = a.getInterfaces();
            ResolvedJavaType[] interfacesB = b.getInterfaces();
            for (int i = 0; i < interfacesA.length; ++i) {
                ResolvedJavaType interface1 = interfacesA[i];
                for (int j = 0; j < interfacesB.length; ++j) {
                    ResolvedJavaType interface2 = interfacesB[j];
                    ResolvedJavaType leastCommon = AbstractObjectStamp.meetTypes(interface1, interface2);
                    if (!leastCommon.isInterface()) continue;
                    return leastCommon;
                }
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.exactType ? 1231 : 1237);
        result = 31 * result + (this.type == null || this.type.isJavaLangObject() ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractObjectStamp other = (AbstractObjectStamp)obj;
        if (this.exactType != other.exactType) {
            return false;
        }
        if (this.type == null ? other.type != null && !other.type.isJavaLangObject() : (other.type == null ? this.type != null && !this.type.isJavaLangObject() : !this.type.equals(other.type))) {
            return false;
        }
        return super.equals(other);
    }
}

