/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.type;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IllegalStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.RawPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.core.common.type.VoidStamp;
import org.graalvm.compiler.debug.GraalError;

public class StampFactory {
    private static final Stamp[] stampCache = new Stamp[JavaKind.values().length];
    private static final Stamp[] emptyStampCache = new Stamp[JavaKind.values().length];
    private static final Stamp objectStamp = new ObjectStamp(null, false, false, false);
    private static final Stamp objectNonNullStamp = new ObjectStamp(null, false, true, false);
    private static final Stamp objectAlwaysNullStamp = new ObjectStamp(null, false, false, true);
    private static final Stamp positiveInt = StampFactory.forInteger(JavaKind.Int, 0L, Integer.MAX_VALUE, 0L, Integer.MAX_VALUE);
    private static final Stamp booleanTrue = StampFactory.forInteger(JavaKind.Boolean, -1L, -1L, 1L, 1L);
    private static final Stamp booleanFalse = StampFactory.forInteger(JavaKind.Boolean, 0L, 0L, 0L, 0L);
    private static final Stamp rawPointer = new RawPointerStamp();

    private static void setCache(JavaKind kind, Stamp stamp) {
        StampFactory.stampCache[kind.ordinal()] = stamp;
    }

    private static void setIntCache(JavaKind kind) {
        int bits = kind.getStackKind().getBitCount();
        long mask = kind.isUnsigned() ? CodeUtil.mask((int)kind.getBitCount()) : CodeUtil.mask((int)bits);
        StampFactory.setCache(kind, IntegerStamp.create(bits, kind.getMinValue(), kind.getMaxValue(), 0L, mask));
    }

    private static void setFloatCache(JavaKind kind) {
        StampFactory.setCache(kind, new FloatStamp(kind.getBitCount()));
    }

    public static Stamp tautology() {
        return booleanTrue;
    }

    public static Stamp contradiction() {
        return booleanFalse;
    }

    public static Stamp forKind(JavaKind kind) {
        assert (stampCache[kind.ordinal()] != null) : "unexpected forKind(" + kind + ")";
        return stampCache[kind.ordinal()];
    }

    public static Stamp forVoid() {
        return VoidStamp.getInstance();
    }

    public static Stamp intValue() {
        return StampFactory.forKind(JavaKind.Int);
    }

    public static Stamp positiveInt() {
        return positiveInt;
    }

    public static Stamp empty(JavaKind kind) {
        return emptyStampCache[kind.ordinal()];
    }

    public static IntegerStamp forInteger(JavaKind kind, long lowerBound, long upperBound, long downMask, long upMask) {
        return IntegerStamp.create(kind.getBitCount(), lowerBound, upperBound, downMask, upMask);
    }

    public static IntegerStamp forInteger(JavaKind kind, long lowerBound, long upperBound) {
        return StampFactory.forInteger(kind.getBitCount(), lowerBound, upperBound);
    }

    public static IntegerStamp forIntegerWithMask(int bits, long newLowerBound, long newUpperBound, IntegerStamp maskStamp) {
        IntegerStamp limit = StampFactory.forInteger(bits, newLowerBound, newUpperBound);
        return IntegerStamp.create(bits, newLowerBound, newUpperBound, limit.downMask() | maskStamp.downMask(), limit.upMask() & maskStamp.upMask());
    }

    public static IntegerStamp forIntegerWithMask(int bits, long newLowerBound, long newUpperBound, long newDownMask, long newUpMask) {
        IntegerStamp limit = StampFactory.forInteger(bits, newLowerBound, newUpperBound);
        return IntegerStamp.create(bits, newLowerBound, newUpperBound, limit.downMask() | newDownMask, limit.upMask() & newUpMask);
    }

    public static IntegerStamp forInteger(int bits) {
        return IntegerStamp.create(bits, CodeUtil.minValue((int)bits), CodeUtil.maxValue((int)bits), 0L, CodeUtil.mask((int)bits));
    }

    public static IntegerStamp forUnsignedInteger(int bits) {
        return StampFactory.forUnsignedInteger(bits, 0L, NumUtil.maxValueUnsigned(bits), 0L, CodeUtil.mask((int)bits));
    }

    public static IntegerStamp forUnsignedInteger(int bits, long unsignedLowerBound, long unsignedUpperBound) {
        return StampFactory.forUnsignedInteger(bits, unsignedLowerBound, unsignedUpperBound, 0L, CodeUtil.mask((int)bits));
    }

    public static IntegerStamp forUnsignedInteger(int bits, long unsignedLowerBound, long unsignedUpperBound, long downMask, long upMask) {
        long upperBound;
        long lowerBound = CodeUtil.signExtend((long)unsignedLowerBound, (int)bits);
        if (!NumUtil.sameSign(lowerBound, upperBound = CodeUtil.signExtend((long)unsignedUpperBound, (int)bits))) {
            lowerBound = CodeUtil.minValue((int)bits);
            upperBound = CodeUtil.maxValue((int)bits);
        }
        long mask = CodeUtil.mask((int)bits);
        return IntegerStamp.create(bits, lowerBound, upperBound, downMask & mask, upMask & mask);
    }

    public static IntegerStamp forInteger(int bits, long lowerBound, long upperBound) {
        return IntegerStamp.create(bits, lowerBound, upperBound, 0L, CodeUtil.mask((int)bits));
    }

    public static FloatStamp forFloat(JavaKind kind, double lowerBound, double upperBound, boolean nonNaN) {
        assert (kind.isNumericFloat());
        return new FloatStamp(kind.getBitCount(), lowerBound, upperBound, nonNaN);
    }

    public static Stamp forConstant(JavaConstant value) {
        JavaKind kind = value.getJavaKind();
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: 
            case Int: 
            case Long: {
                long mask = value.asLong() & CodeUtil.mask((int)kind.getBitCount());
                return StampFactory.forInteger(kind.getStackKind(), value.asLong(), value.asLong(), mask, mask);
            }
            case Float: {
                return StampFactory.forFloat(kind, value.asFloat(), value.asFloat(), !Float.isNaN(value.asFloat()));
            }
            case Double: {
                return StampFactory.forFloat(kind, value.asDouble(), value.asDouble(), !Double.isNaN(value.asDouble()));
            }
            case Illegal: {
                return StampFactory.forKind(JavaKind.Illegal);
            }
            case Object: {
                if (value.isNull()) {
                    return StampFactory.alwaysNull();
                }
                return StampFactory.objectNonNull();
            }
        }
        throw new GraalError("unexpected kind: %s", kind);
    }

    public static Stamp forConstant(JavaConstant value, MetaAccessProvider metaAccess) {
        if (value.getJavaKind() == JavaKind.Object) {
            ResolvedJavaType type = value.isNull() ? null : metaAccess.lookupJavaType(value);
            return new ObjectStamp(type, value.isNonNull(), value.isNonNull(), value.isNull());
        }
        return StampFactory.forConstant(value);
    }

    public static Stamp object() {
        return objectStamp;
    }

    public static Stamp objectNonNull() {
        return objectNonNullStamp;
    }

    public static Stamp alwaysNull() {
        return objectAlwaysNullStamp;
    }

    public static ObjectStamp object(TypeReference type) {
        return StampFactory.object(type, false);
    }

    public static ObjectStamp objectNonNull(TypeReference type) {
        return StampFactory.object(type, true);
    }

    public static ObjectStamp object(TypeReference type, boolean nonNull) {
        if (type == null) {
            return new ObjectStamp(null, false, nonNull, false);
        }
        return new ObjectStamp(type.getType(), type.isExact(), nonNull, false);
    }

    public static Stamp[] createParameterStamps(Assumptions assumptions, ResolvedJavaMethod method) {
        return StampFactory.createParameterStamps(assumptions, method, false);
    }

    public static Stamp[] createParameterStamps(Assumptions assumptions, ResolvedJavaMethod method, boolean trustInterfaceTypes) {
        Signature signature = method.getSignature();
        Stamp[] result = new Stamp[signature.getParameterCount(method.hasReceiver())];
        int index = 0;
        ResolvedJavaType accessingClass = method.getDeclaringClass();
        if (method.hasReceiver()) {
            result[index++] = trustInterfaceTypes ? StampFactory.objectNonNull(TypeReference.createTrusted(assumptions, accessingClass)) : StampFactory.objectNonNull(TypeReference.create(assumptions, accessingClass));
        }
        for (int i = 0; i < signature.getParameterCount(false); ++i) {
            JavaType type = signature.getParameterType(i, accessingClass);
            JavaKind kind = type.getJavaKind();
            Stamp stamp = kind == JavaKind.Object && type instanceof ResolvedJavaType ? (trustInterfaceTypes ? StampFactory.object(TypeReference.createTrusted(assumptions, (ResolvedJavaType)type)) : StampFactory.object(TypeReference.create(assumptions, (ResolvedJavaType)type))) : StampFactory.forKind(kind);
            result[index++] = stamp;
        }
        return result;
    }

    public static Stamp pointer() {
        return rawPointer;
    }

    public static StampPair forDeclaredType(Assumptions assumptions, JavaType returnType, boolean nonNull) {
        if (returnType.getJavaKind() == JavaKind.Object && returnType instanceof ResolvedJavaType) {
            ResolvedJavaType resolvedJavaType = (ResolvedJavaType)returnType;
            TypeReference reference = TypeReference.create(assumptions, resolvedJavaType);
            ResolvedJavaType elementalType = resolvedJavaType.getElementalType();
            if (elementalType.isInterface()) {
                TypeReference uncheckedType;
                assert (reference == null || !reference.getType().equals(resolvedJavaType));
                ResolvedJavaType elementalImplementor = elementalType.getSingleImplementor();
                if (elementalImplementor != null && !elementalType.equals(elementalImplementor)) {
                    ResolvedJavaType implementor = elementalImplementor;
                    ResolvedJavaType t = resolvedJavaType;
                    while (t.isArray()) {
                        implementor = implementor.getArrayClass();
                        t = t.getComponentType();
                    }
                    uncheckedType = TypeReference.createTrusted(assumptions, implementor);
                } else {
                    uncheckedType = TypeReference.createTrusted(assumptions, resolvedJavaType);
                }
                return StampPair.create(StampFactory.object(reference, nonNull), StampFactory.object(uncheckedType, nonNull));
            }
            return StampPair.createSingle(StampFactory.object(reference, nonNull));
        }
        return StampPair.createSingle(StampFactory.forKind(returnType.getJavaKind()));
    }

    static {
        StampFactory.setIntCache(JavaKind.Boolean);
        StampFactory.setIntCache(JavaKind.Byte);
        StampFactory.setIntCache(JavaKind.Short);
        StampFactory.setIntCache(JavaKind.Char);
        StampFactory.setIntCache(JavaKind.Int);
        StampFactory.setIntCache(JavaKind.Long);
        StampFactory.setFloatCache(JavaKind.Float);
        StampFactory.setFloatCache(JavaKind.Double);
        StampFactory.setCache(JavaKind.Object, objectStamp);
        StampFactory.setCache(JavaKind.Void, VoidStamp.getInstance());
        StampFactory.setCache(JavaKind.Illegal, IllegalStamp.getInstance());
        for (JavaKind k : JavaKind.values()) {
            if (stampCache[k.ordinal()] == null) continue;
            StampFactory.emptyStampCache[k.ordinal()] = stampCache[k.ordinal()].empty();
        }
    }
}

