/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.phases;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.phases.BaseTier;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.ExpandLogicPhase;
import org.graalvm.compiler.phases.common.FixReadsPhase;
import org.graalvm.compiler.phases.common.InsertMembarsPhase;
import org.graalvm.compiler.phases.common.LoweringPhase;
import org.graalvm.compiler.phases.common.ProfileCompiledMethodsPhase;
import org.graalvm.compiler.phases.common.PropagateDeoptimizeProbabilityPhase;
import org.graalvm.compiler.phases.common.UseTrappingNullChecksPhase;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.phases.tiers.LowTierContext;

public class LowTier
extends BaseTier<LowTierContext> {
    public LowTier(OptionValues options) {
        CanonicalizerPhase canonicalizer = this.createCanonicalizerPhase(options);
        CanonicalizerPhase canonicalizerWithoutGVN = canonicalizer.copyWithoutGVN();
        if (Options.ProfileCompiledMethods.getValue(options).booleanValue()) {
            this.appendPhase(new ProfileCompiledMethodsPhase());
        }
        this.appendPhase(new LoweringPhase(canonicalizer, LoweringTool.StandardLoweringStage.LOW_TIER));
        this.appendPhase(new ExpandLogicPhase());
        this.appendPhase(new FixReadsPhase(true, new SchedulePhase(GraalOptions.StressTestEarlyReads.getValue(options) != false ? SchedulePhase.SchedulingStrategy.EARLIEST : SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS_IMPLICIT_NULL_CHECKS)));
        this.appendPhase(canonicalizerWithoutGVN);
        this.appendPhase(new UseTrappingNullChecksPhase());
        this.appendPhase(new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required));
        this.appendPhase(new PropagateDeoptimizeProbabilityPhase());
        if (GraalOptions.LateMembars.getValue(options).booleanValue()) {
            this.appendPhase(new InsertMembarsPhase());
        }
        this.appendPhase(new SchedulePhase(SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS));
    }

    static class Options {
        @Option(help={""}, type=OptionType.Debug)
        public static final OptionKey<Boolean> ProfileCompiledMethods = new OptionKey<Boolean>(false);

        Options() {
        }
    }
}

