/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.sparc;

import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.core.sparc.SPARCImmediateAddressNode;
import org.graalvm.compiler.core.sparc.SPARCIndexedAddressNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.phases.common.AddressLoweringPhase;

public class SPARCAddressLowering
extends AddressLoweringPhase.AddressLowering {
    @Override
    public AddressNode lower(ValueNode base, ValueNode offset) {
        JavaConstant immBase = SPARCAddressLowering.asImmediate(base);
        if (immBase != null && SPARCAssembler.isSimm13(immBase)) {
            return this.lower(offset, immBase.asLong());
        }
        JavaConstant immOffset = SPARCAddressLowering.asImmediate(offset);
        if (immOffset != null && SPARCAssembler.isSimm13(immOffset)) {
            return this.lower(base, immOffset.asLong());
        }
        return base.graph().unique(new SPARCIndexedAddressNode(base, offset));
    }

    private AddressNode lower(ValueNode base, long displacement) {
        if (base instanceof AddNode) {
            AddNode add = (AddNode)base;
            JavaConstant immX = SPARCAddressLowering.asImmediate(add.getX());
            if (immX != null && SPARCAssembler.isSimm13(displacement + immX.asLong())) {
                return this.lower(add.getY(), displacement + immX.asLong());
            }
            JavaConstant immY = SPARCAddressLowering.asImmediate(add.getY());
            if (immY != null && SPARCAssembler.isSimm13(displacement + immY.asLong())) {
                return this.lower(add.getX(), displacement + immY.asLong());
            }
            if (displacement == 0L) {
                return this.lower(add.getX(), add.getY());
            }
        }
        assert (SPARCAssembler.isSimm13(displacement));
        return base.graph().unique(new SPARCImmediateAddressNode(base, (int)displacement));
    }

    private static JavaConstant asImmediate(ValueNode value) {
        JavaConstant c = value.asJavaConstant();
        if (c != null && c.getJavaKind().isNumericInteger()) {
            return c;
        }
        return null;
    }
}

